/**
 * @file RegulatoryGNSSMethod.cpp
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include <string.h>
#include "RegulatoryGNSSMethod.h"
namespace org {
	namespace bosch {

DEFINE_CLASS_LOGGER_AND_LEVEL("wifi_business_logic/Regulation", cRegulatoryGNSSMethod, Debug);

cRegulatoryGNSSMethod::cRegulatoryGNSSMethod() :
		cRegulatoryMethod(REGULATORY_METHOD_GNSS, REGULATORY_METHOD_PRIO_HIGH,
				eCC_SOURCE_GNSS, CC_TYPE_ALPHA2 | CC_TYPE_ALPHA3)
{

	_notify = false;
	_countryUpdateAvailability = false;
	_navclient = new cNavigationClient();
	if (_navclient) {
		_navclient->updateServiceAvailability(true);
		_navclient->registerCountryChangeNotification(this);
	}
}
cRegulatoryGNSSMethod::cRegulatoryGNSSMethod(cRegulatoryChangeNotifier *observer) :
		cRegulatoryMethod(REGULATORY_METHOD_GNSS, REGULATORY_METHOD_PRIO_HIGH, eCC_SOURCE_GNSS,
				CC_TYPE_ALPHA2 | CC_TYPE_ALPHA3)
{
	int iRet;

	_notify = false;
	_countryUpdateAvailability = false;
	_navclient = new cNavigationClient();
	if (_navclient) {
		_navclient->updateServiceAvailability(true);
		_navclient->registerCountryChangeNotification(this);
	}

	if (observer) {
		iRet = Register(observer);
		if (iRet < 0)
			LOG_ERROR ("Failed to register the observer[%p]: %s/%d", observer,
					strerror(-iRet), -iRet);
	}
}
cRegulatoryGNSSMethod::~cRegulatoryGNSSMethod()
{
	if (_navclient)
		_navclient->unRegisterCountryChangeNotification(this);
	delete _navclient;
}
void cRegulatoryGNSSMethod::updateCountryCodeInfo()
{
	if(_navclient)
		_navclient->updateCCodeInfo();
}
int cRegulatoryGNSSMethod::start()
{
	if (!_notify) {
		_notify = true;

		/* Usually we dont need this if condition, as the
		 * core would have called start only if the service
		 * is available but just to be sure */
		if (_availability)
			updateCountryCodeInfo();
	}
	return 0;
}

void cRegulatoryGNSSMethod::checkServiceAvailability()
{

	bool old = _availability;

	LOG_INFO("Old: \"%s\", _serviceAvailability: \"%s\", _cc_availability: \"%s\"",
			old == true ? "Y" : "N", SERVICE_AVAILABLE == _serviceAvailability ? "Y" : "N",
					_countryUpdateAvailability == true ? "Y" : "N");

	_availability = false;
	if (SERVICE_AVAILABLE == _serviceAvailability &&
			_countryUpdateAvailability == true)
		_availability = true;

	if (old != _availability)
		notifyServiceAvailability();

}

void cRegulatoryGNSSMethod::setCountryChangeUpdateChannel()
{/*
	::std::string busName;
	cNavigationUpdateNotifier *client;
	::std::vector<cNavigationUpdateNotifier*>::iterator it;

	if (!_navclients.size())
		return;

	std::sort(_navclients.begin(), _navclients.end(), cNavigationUpdateNotifier::NavPrioComparison);
	client = _navclients.front();
	if (client) {
		busName = client->getBusName();
		LOG_INFO ("Relying updates from the navigaton client: %s", busName.c_str());
	}

	for (it = _navclients.begin(); it != _navclients.end(); ++it) {
		if (!(*it)->getBusName().compare(busName)) {
			(*it)->updateServiceAvailability(true);
			(*it)->updateCountryCodeChange(true);
		} else {
			(*it)->updateServiceAvailability(false);
			(*it)->updateCountryCodeChange(false);
		}
	}
*/}

void cRegulatoryGNSSMethod::countryChangeAvailability(bool availability)
{
	LOG_INFO ("Change in country change update service availability: %s "
			"previous: %s", (availability == true) ? "Y" : "N",
					(_countryUpdateAvailability == true) ? "Y" : "N");

	if (_countryUpdateAvailability && !availability) {
		_countryUpdateAvailability = false;
		checkServiceAvailability();
	}
	else if (!_countryUpdateAvailability && availability) {
		_countryUpdateAvailability = true;
		checkServiceAvailability();
	}
}

int cRegulatoryGNSSMethod::stop()
{
	if (_notify)
		_notify = false;

	return 0;
}

void cRegulatoryGNSSMethod::countryChangeUpdate(const ::std::string &country)
{
	LOG_INFO ("Navigation Client Update :%s Notify: %s", country.c_str(),
			(_notify == true) ? "YES" : "NO");

	if (true == _notify && !country.empty())
		notifyRegChange(country);
}

void cRegulatoryGNSSMethod::setCountryCodeInfo (const cc_availability_t serAvail,
		const ::std::string &cc, const uint16_t numeric)
{
	cc_availability_t old = _serviceAvailability;

	LOG_INFO("Old: %s ServiceAvailability: %s, country code: %s numeric: %u",
			SERVICE_UNAVAILABLE == old ? "N" : "Y",
			SERVICE_UNAVAILABLE == serAvail ? "N" : "Y", cc.c_str(), numeric);

	_serviceAvailability = serAvail;
	_numeric_cc = numeric;

	if (old != _serviceAvailability)
		checkServiceAvailability();

	if (SERVICE_AVAILABLE == _serviceAvailability && _navclient)
		_navclient->setCountryCodeInfo(cc);
}

	}
}

/** @} */
