/**
 * @file Pipe.cpp
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Main file for Wifi_Business_Logic.
 *
 *
 * @{
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include "asf/core/Logger.h"
#include "Pipe.h"

namespace org
{
namespace bosch
{

DEFINE_CLASS_LOGGER_AND_LEVEL("wifi_business_logic/Regulation", cPipe, Debug);

cPipe::cPipe()
{
   int iRet;

   m_iPipe[0] = m_iPipe[1] = -1;
   iRet = pipe(m_iPipe);
   if (iRet < 0)
   {
      LOG_ERROR("Failed to create the pipe : %s/%d", strerror(-iRet), -iRet);
   }
   else
   {
      LOG_INFO("Successfully created the pipe : %d | %d", m_iPipe[1], m_iPipe[0]);
   }
}

int cPipe::iGetPipe(const ePipeType eType)
{
   switch (eType)
   {
      default:
      case PIPE_END_INVAL:
         return -1;
      case PIPE_END_READ:
         return m_iPipe[0];
      case PIPE_END_WRITE:
         return m_iPipe[1];
   }

   return -1;
}

std::string cPipe::sGetPipeEvent(const ePipeCmd eCmd)
{
   switch (eCmd)
   {
      case PIPE_CMD_INVAL:
         return "PIPE_CMD_INVAL";
      case PIPE_CMD_FD_ADDED:
         return "PIPE_CMD_FD_ADDED";
      case PIPE_CMD_FD_MODIFIED:
         return "PIPE_CMD_FD_MODIFIED";
      case PIPE_CMD_FD_DELETED:
         return "PIPE_CMD_FD_DELETED";
      case PIPE_CMD_TERMINATE:
         return "PIPE_CMD_TERMINATE";
   }
         return "UNKNOWN";
}

int cPipe::iClosePipe(const ePipeType eType)
{
   int iRet = -1;

   switch (eType)
   {
      default:
      case PIPE_END_INVAL:
         return iRet;

      case PIPE_END_READ:
      {
         if (m_iPipe[0] != -1)
         {
            iRet = close(m_iPipe[0]);
            if (iRet < 0)
            {
               iRet = -errno;
               LOG_ERROR("Failed to close the Read end of the pipe : %s/%d", strerror(-iRet), -iRet);
            }
            m_iPipe[0] = -1;
         }
         else
         {
            iRet = 0;
         }
      }
      break;

      case PIPE_END_WRITE:
      {
         if (m_iPipe[1] != -1)
         {
            iRet = close(m_iPipe[1]);
            if (iRet < 0)
            {
               iRet = -errno;
               LOG_ERROR("Failed to close the Write end of the pipe : %s/%d", strerror(-iRet), -iRet);
            }
            m_iPipe[1] = -1;
         }
         else
         {
            iRet = 0;
         }
      }
      break;
   }

   return iRet;
}

cPipe::~cPipe()
{
   if (m_iPipe[0] != -1)
      close(m_iPipe[0]);
   if (m_iPipe[1] != -1)
      close(m_iPipe[1]);
}

}
}

/** @} */
