/**
 * @file MCCClient.cpp
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include <string.h>
#include "MCCClient.h"
#include "ISO3166CountryInfo.h"

namespace org {
	namespace bosch {

DEFINE_CLASS_LOGGER_AND_LEVEL ("wifi_business_logic/Regulation", cMCCClient, Debug);

cMCCClient::cMCCClient()
{
}

cMCCClient::~cMCCClient()
{
}

void cMCCClient::convertMCCtoAlpha2(const uint16_t &mcc, ::std::string &alpha2)
{
#define ASSIGN_ALPHA2(string, value)	\
	string.assign(value);	\
	break;

	switch(mcc) {
	default: break;
	case 213: ASSIGN_ALPHA2(alpha2,"AD")
	case 424: ASSIGN_ALPHA2(alpha2,"AE")
	case 412: ASSIGN_ALPHA2(alpha2,"AF")
	case 365: ASSIGN_ALPHA2(alpha2,"AI")
	case 276: ASSIGN_ALPHA2(alpha2,"AL")
	case 283: ASSIGN_ALPHA2(alpha2,"AM")
	case 362: ASSIGN_ALPHA2(alpha2,"AN")
	case 722: ASSIGN_ALPHA2(alpha2,"AR")
	case 544: ASSIGN_ALPHA2(alpha2,"AS")
	case 232: ASSIGN_ALPHA2(alpha2,"AT")
	case 505: ASSIGN_ALPHA2(alpha2,"AU")
	case 363: ASSIGN_ALPHA2(alpha2,"AW")
	case 400: ASSIGN_ALPHA2(alpha2,"AZ")
	case 218: ASSIGN_ALPHA2(alpha2,"BA")
	case 342: ASSIGN_ALPHA2(alpha2,"BB")
	case 470: ASSIGN_ALPHA2(alpha2,"BD")
	case 206: ASSIGN_ALPHA2(alpha2,"BE")
	case 613: ASSIGN_ALPHA2(alpha2,"BF")
	case 284: ASSIGN_ALPHA2(alpha2,"BG")
	case 426: ASSIGN_ALPHA2(alpha2,"BH")
//	case 340: ASSIGN_ALPHA2(alpha2,"BL")
	case 350: ASSIGN_ALPHA2(alpha2,"BM")	/* Bermuda also has the MCC code of 338? */
	case 528: ASSIGN_ALPHA2(alpha2,"BN")
	case 736: ASSIGN_ALPHA2(alpha2,"BO")
	case 724: ASSIGN_ALPHA2(alpha2,"BR")
	case 364: ASSIGN_ALPHA2(alpha2,"BS")
	case 402: ASSIGN_ALPHA2(alpha2,"BT")
	case 257: ASSIGN_ALPHA2(alpha2,"BY")
	case 702: ASSIGN_ALPHA2(alpha2,"BZ")
	case 302: ASSIGN_ALPHA2(alpha2,"CA")
	case 623: ASSIGN_ALPHA2(alpha2,"CF")
	case 228: ASSIGN_ALPHA2(alpha2,"CH")
	case 612: ASSIGN_ALPHA2(alpha2,"CI")
	case 730: ASSIGN_ALPHA2(alpha2,"CL")
	case 460: ASSIGN_ALPHA2(alpha2,"CN")
	case 732: ASSIGN_ALPHA2(alpha2,"CO")
	case 712: ASSIGN_ALPHA2(alpha2,"CR")
	case 368: ASSIGN_ALPHA2(alpha2,"CU")
	/* No MCC code available for "Christmas Island" ==> CX */
	case 280: ASSIGN_ALPHA2(alpha2,"CY")
	case 230: ASSIGN_ALPHA2(alpha2,"CZ")
	case 262: ASSIGN_ALPHA2(alpha2,"DE")
	case 238: ASSIGN_ALPHA2(alpha2,"DK")
	case 366: ASSIGN_ALPHA2(alpha2,"DM")
	case 370: ASSIGN_ALPHA2(alpha2,"DO")
	case 603: ASSIGN_ALPHA2(alpha2,"DZ")
	case 740: ASSIGN_ALPHA2(alpha2,"EC")
	case 248: ASSIGN_ALPHA2(alpha2,"EE")
	case 602: ASSIGN_ALPHA2(alpha2,"EG")
	case 214: ASSIGN_ALPHA2(alpha2,"ES")
	case 636: ASSIGN_ALPHA2(alpha2,"ET")
	case 244: ASSIGN_ALPHA2(alpha2,"FI")
	case 550: ASSIGN_ALPHA2(alpha2,"FM")
	case 208: ASSIGN_ALPHA2(alpha2,"FR")
	case 234:
	case 235: ASSIGN_ALPHA2(alpha2,"GB")
	case 352: ASSIGN_ALPHA2(alpha2,"GD")
	case 282: ASSIGN_ALPHA2(alpha2,"GE")
//	case 647: ASSIGN_ALPHA2(alpha2,"GF")
	case 620: ASSIGN_ALPHA2(alpha2,"GH")
	case 290: ASSIGN_ALPHA2(alpha2,"GL")
//	case 340: ASSIGN_ALPHA2(alpha2,"GP") --> GP and BL have same MCC codes
	case 202: ASSIGN_ALPHA2(alpha2,"GR")
	case 704: ASSIGN_ALPHA2(alpha2,"GT")
//	case 310:
//	case 311: ASSIGN_ALPHA2(alpha2,"GU")
	case 738: ASSIGN_ALPHA2(alpha2,"GY")
	case 454: ASSIGN_ALPHA2(alpha2,"HK")
	case 708: ASSIGN_ALPHA2(alpha2,"HN")
	case 219: ASSIGN_ALPHA2(alpha2,"HR")
	case 372: ASSIGN_ALPHA2(alpha2,"HT")
	case 216: ASSIGN_ALPHA2(alpha2,"HU")
	case 510: ASSIGN_ALPHA2(alpha2,"ID")
	case 272: ASSIGN_ALPHA2(alpha2,"IE")
	case 425: ASSIGN_ALPHA2(alpha2,"IL")
	case 404:
	case 405: ASSIGN_ALPHA2(alpha2,"IN")
	case 432: ASSIGN_ALPHA2(alpha2,"IR")
	case 274: ASSIGN_ALPHA2(alpha2,"IS")
	case 222: ASSIGN_ALPHA2(alpha2,"IT")
//	case 338: ASSIGN_ALPHA2(alpha2,"JM")	/* JM abd LC have same codes 338 */
	case 416: ASSIGN_ALPHA2(alpha2,"JO")
	case 440:
	case 441: ASSIGN_ALPHA2(alpha2,"JP")
	case 639: ASSIGN_ALPHA2(alpha2,"KE")
	case 456: ASSIGN_ALPHA2(alpha2,"KH")
	case 356: ASSIGN_ALPHA2(alpha2,"KN")
	case 467: ASSIGN_ALPHA2(alpha2,"KP")
	case 450: ASSIGN_ALPHA2(alpha2,"KR")
	case 419: ASSIGN_ALPHA2(alpha2,"KW")
	case 346: ASSIGN_ALPHA2(alpha2,"KY")
	case 401: ASSIGN_ALPHA2(alpha2,"KZ")
	case 415: ASSIGN_ALPHA2(alpha2,"LB")
//	case 338: ASSIGN_ALPHA2(alpha2,"LC") /* JM abd LC have same codes 338 */
	case 295: ASSIGN_ALPHA2(alpha2,"LI")
	case 413: ASSIGN_ALPHA2(alpha2,"LK")
	case 651: ASSIGN_ALPHA2(alpha2,"LS")
	case 246: ASSIGN_ALPHA2(alpha2,"LT")
	case 270: ASSIGN_ALPHA2(alpha2,"LU")
	case 247: ASSIGN_ALPHA2(alpha2,"LV")
	case 604: ASSIGN_ALPHA2(alpha2,"MA")
	case 212: ASSIGN_ALPHA2(alpha2,"MC")
	case 259: ASSIGN_ALPHA2(alpha2,"MD")
	case 297: ASSIGN_ALPHA2(alpha2,"ME")
//	case 340: ASSIGN_ALPHA2(alpha2,"MF")
	case 551: ASSIGN_ALPHA2(alpha2,"MH")
	case 294: ASSIGN_ALPHA2(alpha2,"MK")
	case 428: ASSIGN_ALPHA2(alpha2,"MN")
	case 455: ASSIGN_ALPHA2(alpha2,"MO")
//	case 310: ASSIGN_ALPHA2(alpha2,"MP")
//	case 340: ASSIGN_ALPHA2(alpha2,"MQ")
	case 609: ASSIGN_ALPHA2(alpha2,"MR")
	case 278: ASSIGN_ALPHA2(alpha2,"MT")
	case 617: ASSIGN_ALPHA2(alpha2,"MU")
	case 472: ASSIGN_ALPHA2(alpha2,"MV")
	case 650: ASSIGN_ALPHA2(alpha2,"MW")
	case 334: ASSIGN_ALPHA2(alpha2,"MX")
	case 502: ASSIGN_ALPHA2(alpha2,"MY")
	case 621: ASSIGN_ALPHA2(alpha2,"NG")
	case 710: ASSIGN_ALPHA2(alpha2,"NI")
	case 204: ASSIGN_ALPHA2(alpha2,"NL")
	case 242: ASSIGN_ALPHA2(alpha2,"NO")
	case 429: ASSIGN_ALPHA2(alpha2,"NP")
	case 530: ASSIGN_ALPHA2(alpha2,"NZ")
	case 422: ASSIGN_ALPHA2(alpha2,"OM")
	case 714: ASSIGN_ALPHA2(alpha2,"PA")
	case 716: ASSIGN_ALPHA2(alpha2,"PE")
	case 547: ASSIGN_ALPHA2(alpha2,"PF")
	case 537: ASSIGN_ALPHA2(alpha2,"PG")
	case 515: ASSIGN_ALPHA2(alpha2,"PH")
	case 410: ASSIGN_ALPHA2(alpha2,"PK")
	case 260: ASSIGN_ALPHA2(alpha2,"PL")
	case 308: ASSIGN_ALPHA2(alpha2,"PM")
	case 330: ASSIGN_ALPHA2(alpha2,"PR")
	case 268: ASSIGN_ALPHA2(alpha2,"PT")
	case 552: ASSIGN_ALPHA2(alpha2,"PW")
	case 744: ASSIGN_ALPHA2(alpha2,"PY")
	case 427: ASSIGN_ALPHA2(alpha2,"QA")
//	case 647: ASSIGN_ALPHA2(alpha2,"RE") /* RE and GF uses same country code*/
	case 226: ASSIGN_ALPHA2(alpha2,"RO")
	case 220: ASSIGN_ALPHA2(alpha2,"RS")
	case 250: ASSIGN_ALPHA2(alpha2,"RU")
	case 635: ASSIGN_ALPHA2(alpha2,"RW")
	case 420: ASSIGN_ALPHA2(alpha2,"SA")
	case 240: ASSIGN_ALPHA2(alpha2,"SE")
	case 525: ASSIGN_ALPHA2(alpha2,"SG")
	case 293: ASSIGN_ALPHA2(alpha2,"SI")
	case 231: ASSIGN_ALPHA2(alpha2,"SK")
	case 608: ASSIGN_ALPHA2(alpha2,"SN")
	case 746: ASSIGN_ALPHA2(alpha2,"SR")
	case 706: ASSIGN_ALPHA2(alpha2,"SV")
	case 417: ASSIGN_ALPHA2(alpha2,"SY")
//	case 338:
	case 376: ASSIGN_ALPHA2(alpha2,"TC")
	case 622: ASSIGN_ALPHA2(alpha2,"TD")
	case 615: ASSIGN_ALPHA2(alpha2,"TG")
	case 520: ASSIGN_ALPHA2(alpha2,"TH")
	case 605: ASSIGN_ALPHA2(alpha2,"TN")
	case 286: ASSIGN_ALPHA2(alpha2,"TR")
	case 374: ASSIGN_ALPHA2(alpha2,"TT")
	case 466: ASSIGN_ALPHA2(alpha2,"TW")
	case 640: ASSIGN_ALPHA2(alpha2,"TZ")
	case 255: ASSIGN_ALPHA2(alpha2,"UA")
	case 641: ASSIGN_ALPHA2(alpha2,"UG")
//	case 310:
//	case 311:
	case 312:
	case 313:
	case 314:
	case 316: ASSIGN_ALPHA2(alpha2,"US")
	case 748: ASSIGN_ALPHA2(alpha2,"UY")
	case 434: ASSIGN_ALPHA2(alpha2,"UZ")
	case 360: ASSIGN_ALPHA2(alpha2,"VC")
	case 734: ASSIGN_ALPHA2(alpha2,"VE")
//	case '?': ASSIGN_ALPHA2(alpha2,"VI")
	case 452: ASSIGN_ALPHA2(alpha2,"VN")
	case 541: ASSIGN_ALPHA2(alpha2,"VU")
	case 543: ASSIGN_ALPHA2(alpha2,"WF")
	case 549: ASSIGN_ALPHA2(alpha2,"WS")
	case 421: ASSIGN_ALPHA2(alpha2,"YE")
//	case 647: ASSIGN_ALPHA2(alpha2,"YT")
	case 655: ASSIGN_ALPHA2(alpha2,"ZA")
	case 648: ASSIGN_ALPHA2(alpha2,"ZW")
	}
#undef ASSIGN_ALPHA2
}

void cMCCClient::setCountryCodeInfo(const uint16_t numeric)
{
	std::string alpha2;
	bool propagate = true;

	convertMCCtoAlpha2(numeric, alpha2);
	LOG_INFO ("MCC Code: %u, converted alpha 2 code: %s", numeric, alpha2.c_str());

	if (!alpha2.empty() &&
			0 == cISO3166CountryInfo::getInstance()->isValidAlpha2(alpha2.c_str())) {
		LOG_INFO ("Valid country code reported by the MCC module: %s",
				alpha2.c_str());
		if (_country.compare(alpha2))
			_country = alpha2;
	} else {
		if (_country.empty())
			propagate = false;
		_country.clear();
	}

	setServiceAvailability(alpha2.empty() ? false : true);
	if (propagate)
		updateCountryChange(_country);
}

void cMCCClient::updateCountryCodeInfo()
{
	LOG_INFO("MCC Client's service availability: %s",
			_serviceAvailability == true ? "Y" : "F");

	if (_serviceAvailability)
		updateCountryChange(_country);
}

	}
}

/** @} */
