/**
 * @file WifiChannel.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 *
 * @{
 */

#ifndef _WIFI_CHANNEL_H
#define _WIFI_CHANNEL_H

#include <errno.h>
#include "WBLUtils.h"

namespace org {
	namespace bosch {

#define IEEE80211_CHANNEL_DISABLED      		BIT(0)
#define IEEE80211_CHANNEL_NO_IR         		BIT(1)
#define IEEE80211_CHANNEL_RADAR         		BIT(2)
#define IEEE80211_CHANNEL_INDOOR        		BIT(4)
#define IEEE80211_CHANNEL_IR_CONCURRENT 		BIT(5)
#define IEEE80211_CHANNEL_DFS_USABLE            BIT(9)
#define IEEE80211_CHANNEL_DFS_UNAVAILABLE       BIT(10)
#define IEEE80211_CHANNEL_DFS_AVAILABLE         BIT(11)

#define IS_VALID_CHANNEL(flags)	\
	do {	\
		if ((flags & IEEE80211_CHANNEL_DISABLED) ||	\
			(flags & IEEE80211_CHANNEL_INDOOR) ||	\
			(flags & IEEE80211_CHANNEL_IR_CONCURRENT)) {	\
			return -EINVAL;	\
		}	\
		return 0;	\
	} while(0)

class cWifiChannel {
private:
	uint16_t _frequency, _channel;
	uint32_t _flags;
public:
	cWifiChannel() :
		_frequency(0),
		_channel(0),
		_flags(0) { }

	cWifiChannel(uint16_t freq, uint16_t chan, uint32_t flags) {
		_frequency = freq;
		_channel = chan;
		_flags = flags;
	}

	bool operator==(cWifiChannel &channel) {
		if (_frequency == channel.getFrequency() &&
				_channel == channel.getChannel() &&
				_flags == channel.getFlags())
			return true;
		return false;
	}

	cWifiChannel &operator=(cWifiChannel &channel) {
		if(this == &channel)
			return *this;
		_frequency = channel.getFrequency();
		_channel = channel.getChannel();
		_flags = channel.getFlags();
		return *this;
	}

	~cWifiChannel() { }

	int iSetFrequency(uint16_t freq) {
		if (_frequency == freq)
			return -EALREADY;
		_frequency = freq;
		return 0;
	}

	int iSetChannel(uint16_t chan) {
		if (_channel == chan)
			return -EALREADY;
		_channel = chan;
		return 0;
	}

	int iSetFlags(uint32_t flags) {
		if (_flags == flags)
			return -EALREADY;
		_flags = flags;
		return 0;
	}

	uint16_t &getFrequency() {
		return _frequency;
	}

	uint16_t &getChannel() {
		return _channel;
	}

	uint32_t &getFlags() {
		return _flags;
	}
};

	}
}

#endif //_WIFI_CHANNEL_H

/** @} */
