/**
 * @file RegulatoryMethodFactory.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _REGULATORY_METHOD_FACTORY_H
#define _REGULATORY_METHOD_FACTORY_H

#include "GenericSingleton.h"
#include "RegulatoryMethod.h"

namespace org {
	namespace bosch {

class cRegulatoryMethodFactory final:
		public GenericSingleton<cRegulatoryMethodFactory> {

	cRegulatoryMethodFactory();
	friend class GenericSingleton<cRegulatoryMethodFactory>;
	std::vector <cRegulatoryMethod *> _regulatoryclients;
public:
	virtual ~cRegulatoryMethodFactory();
	int destroyRegMethod(eRegulatoryMethod_t method);
	cRegulatoryMethod *getRegulatoryMethod(eRegulatoryMethod_t method);
	cRegulatoryMethod *getRegulatoryMethodfromSrc(const cc_source_t src);
};

	}
}

#endif //_REGULATORY_METHOD_FACTORY_H

/** @} */
