/**
 * @file RegulatoryMCCMethod.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _REGULATORY_MCC_METHOD_H
#define _REGULATORY_MCC_METHOD_H

#include "asf/core/Logger.h"
#include "RegulatoryMethod.h"

namespace org
{
    namespace bosch
    {

        class cMCCClient;
        class cRegulatoryChangeNotifier;
        class cNavigationUpdateNotifier;

        class cRegulatoryMCCMethod : public cRegulatoryMethod, public cCountryChangeUpdate
        {

            DECLARE_CLASS_LOGGER();
        private:
            bool _notify, _cc_availability;
            cMCCClient *_mccClient;
        public:
            cRegulatoryMCCMethod();
            cRegulatoryMCCMethod(const cRegulatoryMCCMethod& ref);
            cRegulatoryMCCMethod& operator=(const cRegulatoryMCCMethod& ref);
            cRegulatoryMCCMethod(cRegulatoryChangeNotifier *observer);
            virtual ~cRegulatoryMCCMethod();
            virtual int start();
            virtual int stop();
            void checkServiceAvailability();
            virtual void countryChangeUpdate(const ::std::string &country);
            virtual void countryChangeAvailability(bool availability);
            virtual void setCountryCodeInfo (const cc_availability_t serAvail, const ::std::string &cc, const uint16_t numeric);
        };

    }
}

#endif //_REGULATORY_GNSS_METHOD_H

/** @} */
