/**
 * @file RegulatoryChannelAvailability.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 *
 * @{
 */

#ifndef _REGULATORY_CHANNEL_AVAILABILITY_H
#define _REGULATORY_CHANNEL_AVAILABILITY_H

#include <vector>

namespace org {
    namespace bosch {

#define REGULATORY_CHANNEL_WPASUPPLICANT BIT(0)
#define REGULATORY_CHANNEL_WAPDMAN		 BIT(1)
#define REGULATORY_CHANNEL_GNETLINK		 BIT(2)

        typedef enum {
            REGULATORY_CHANNEL_INVAL,
            REGULATORY_CHANNEL_WPA_SUPPLICANT,
            REGULATORY_CHANNEL_WIFI_AP_DIRECT_MANAGER,
            REGULATORY_CHANNEL_GENERIC_NETLINK
        } eRegChannelType_t;

        class cRegChannelAvailability {
        public:
            cRegChannelAvailability() {}
            virtual ~cRegChannelAvailability() {}
            virtual void notifyRegChannelAvailabilty(const eRegChannelType_t type,
                    const bool availability) = 0;
        };

        class cRegulatoryChannel {
            eRegChannelType_t _regChanlType;
            std::vector<cRegChannelAvailability *> _observers;
        public:
            eRegChannelType_t getRegChannelType() {
                return _regChanlType;
            }
            int Subscribe(cRegChannelAvailability *observer) {
                std::vector<cRegChannelAvailability *>::iterator it;
                for (it = _observers.begin(); it < _observers.end(); it++) {
                    if (observer == *it)
                        return -EALREADY;
                }
                _observers.push_back (observer);
                return 0;
            }
            int UnSubscribe(cRegChannelAvailability *observer) {
                std::vector<cRegChannelAvailability *>::iterator it;
                for (it = _observers.begin(); it < _observers.end(); it++) {
                    if (observer == *it) {
                        _observers.erase (it);
                        return 0;
                    }
                }
                return -ENOENT;
            }
            void notifyRegChanStatus(const bool available) {
                std::vector<cRegChannelAvailability *>::iterator it;
                for (it = _observers.begin(); it < _observers.end(); ++it) {
                    (*it)->notifyRegChannelAvailabilty (_regChanlType, available);
                }
            }

            virtual int changeRegulatory(const ::std::string &country) = 0;
        protected:
            explicit cRegulatoryChannel(const eRegChannelType_t type) {
                _regChanlType = type;
            }
            virtual ~cRegulatoryChannel() {}
        };

    }
}

#endif //_REGULATORY_CHANNEL_AVAILABILITY_H

/** @} */
