/**
 * @file Poller.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Main file for Wifi_Business_Logic.
 *
 *
 * @{
 */

#ifndef _POLLER_H
#define _POLLER_H

#include <vector>
#include "asf/core/Logger.h"
#include "GenericSingleton.h"
#include "Pipe.h"
#include "Lock.h"

class Lock;
struct epoll_event;

namespace org
{
    namespace bosch
    {

        typedef enum
        {
            POLL_EVENT_INVAL,
            POLL_EVENT_READ,
            POLL_EVENT_WRITE
        } ePollEvent;

        typedef enum
        {
            POLL_STATE_INVAL,
            POLL_STATE_REGISTERED,
            POLL_STATE_ADD,
            POLL_STATE_MODIFY,
            POLL_STATE_REMOVE
        } ePollFDState;

        class cPipe;

        class cIOChannel
        {
        private:
            int m_iFileDesc;
            ePollEvent m_ePollEvent;
            ePollFDState m_ePollFdState;
        public:
            int iSetPollEvent(const ePollEvent eEvt);
            const ePollEvent &eGetPollEvent();
            const ePollFDState &eGetPollState();
            int iSetPollState(const ePollFDState eState);
            int iSetPollFd(const int iIOFd);
            const int &iGetPollFd();
            int iGetEpollType(const ePollEvent eEvent);
            int iGetEpollEvent(const ePollFDState eEvent);
            explicit cIOChannel(const ePollEvent eEvent);
            virtual ~cIOChannel();

            /*
             * Clients should return false in case if there is an
             * error so that the poller stops polling for the invalid FD.
             * True means continuous polling
             * */
            virtual bool bProcessEvent(int iPollFd, int iEvent) = 0;
        };

        class cPoller final: public GenericSingleton<cPoller>, public cIOChannel
        {

        public:
            int iRegisterForPoll(cIOChannel *pListener);
            int iUnRegisterFromPoll(cIOChannel *pListener);
            bool bProcessEvent(int iPollFd, int iEvent) override;
            int stopEventLoop();
            int vRunEventLoop();
            virtual ~cPoller();
            cPoller(const cPoller& ref);
            cPoller& operator=(const cPoller& ref);
        private:
            int m_iPollFd;
            int m_iMaxFds;
            int m_iCount;
            bool _terminate;
            Lock m_oLock;
            cPipe *m_pPipe;
            struct epoll_event *m_pEvents;
            std::vector<cIOChannel *> m_lListeners;

            cPoller();
            friend class GenericSingleton<cPoller> ;DECLARE_CLASS_LOGGER();};

    } //namespace bosch
} //namespace org

#endif //#_POLLER_H

/** @} */
