/**
 * @file Pipe.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Main file for Wifi_Business_Logic.
 *
 *
 * @{
 */


#ifndef _PIPE_H
#define _PIPE_H

#include <vector>
#include "asf/core/Logger.h"
#include "GenericSingleton.h"
#include "Lock.h"

class Lock;

namespace org {
	namespace bosch {

typedef enum {
	PIPE_END_INVAL,
	PIPE_END_READ,
	PIPE_END_WRITE
} ePipeType;

typedef enum {
	PIPE_CMD_INVAL,
	PIPE_CMD_FD_ADDED,
	PIPE_CMD_FD_MODIFIED,
	PIPE_CMD_FD_DELETED,
	PIPE_CMD_TERMINATE
} ePipeCmd;

class cPipe {

public:
	~cPipe();
	cPipe();
	int iGetPipe(const ePipeType eType);
	int iClosePipe(const ePipeType eType);
	std::string sGetPipeEvent(const ePipeCmd eCmd);
private:
	int m_iPipe[2];
	Lock m_oLock;
    DECLARE_CLASS_LOGGER();
};

	}
}

#endif //_PIPE_H

/** @} */
