/**
 * @file KDSConfiguration.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _KDS_CONFIGURATION_H
#define _KDS_CONFIGURATION_H

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif

#include "asf/core/Logger.h"
#include "GenericSingleton.h"
#include "WBLTypes.h"



#define      WBL_CPWBLOCKED_FILEPATH                    "/tmp/CarPlay_Wireless_Blocked.dat"
#define      WBL_CPWOVERRIDE_FILEPATH                    "/tmp/CarPlay_Wireless_Override.dat"
namespace org {
    namespace bosch {

class cKDSConfiguration final:
public GenericSingleton<cKDSConfiguration> {
private:
    DECLARE_CLASS_LOGGER();
    friend class GenericSingleton<cKDSConfiguration>;
    uint8_t _wifiFCCConfiguration;
    bool _supportCPW;
    bool _supportAAW;
    bool _wifi5GHzPDSupport;
    bool _wifi5GHzCDSupport;

    ::std::string _manufacturerName;
    ::std::string _modelName;
    ::std::string _vehicleDeviceName;

    cKDSConfiguration();
    void readWiFi5GHzConfiguration();
    void readAAWSupportData();
    void readCPWSupportData();
    void getManufacturerConfigurationData();
    void getVehicleFriendlyName();
    tBool bReadData(tU16 u16KdsKey, tU16 u16DataLen, tU8* pu8DataBuffer);
    ::std::string readVehicleManufacturerName(const ::std::string cstrManufacturerName);
    ::std::string readVehicleModelName(const ::std::string cstrModelName);
    bool getParsedString(::std::string &strToBeParsed);


public:
    virtual ~cKDSConfiguration();
    bool getWiFi5GHzConfiguration();
    ::std::string getManufacturerName();
    ::std::string getManufacturerModelName();
    bool isCPWSupport();
    bool isAAWSupport();
    ::std::string getVehicleName();
    bool isWiFiFCC();
    uint16_t getCarplayChannelsFromConfiguration(WBLFrequencyBand& requestedFrequency);
    uint16_t getAAWChannelsFromConfiguration();

};
}
}

#endif //_KDS_CONFIGURATION_H

/** @} */
