/**
 * @file ISO3166CountryInfo.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _ISO3166_COUNTYR_INFO_H
#define _ISO3166_COUNTYR_INFO_H

#include <vector>
#include <map>
#include <fstream>
#include <errno.h>
#include <algorithm>
#include "GenericSingleton.h"
#include "asf/core/Logger.h"

namespace org {
	namespace bosch {

typedef enum {
	ISO3166_COUNTRY_CODE_ALPHA2,
	ISO3166_COUNTRY_CODE_ALPHA3,
	ISO3166_COUNTRY_CODE_MAX
} eISO3166CountryType;

class cISO3166CountryInfo final : public GenericSingleton<cISO3166CountryInfo> {

	eISO3166CountryType _alphatype;
	::std::string _iso3166infodb;
	::std::map< char, ::std::vector< ::std::string > > _alpha2;

private:

	friend class GenericSingleton<cISO3166CountryInfo>;

	cISO3166CountryInfo(const cISO3166CountryInfo& ref);
	cISO3166CountryInfo() :
			_alphatype(ISO3166_COUNTRY_CODE_ALPHA2),
			_iso3166infodb("/var/opt/bosch/static/connectivity/db/WBL_ISO3166Alpha2.txt")
	{
		::asf::core::Logger oLogger("wifi_business_logic/Regulation",
						::asf::core::Logger::Debug);
		::std::string output;
		::std::ifstream stream;
		::std::vector< ::std::string > countries;
		::std::map< char, ::std::vector< ::std::string > >::iterator it;

		if (!_iso3166infodb.empty()) {
			stream.open(_iso3166infodb.c_str());
			while (::std::getline(stream, output)) {
				if (stream.eof() || stream.fail() || stream.bad())
					break;
				oLogger.info ("Country code: \"%s\", len: \"%u\"", __LINE__, __FILE__,
						output.c_str(), output.length());
				if (output.length() == 2) {
					if ((it = _alpha2.find(output.at(0))) != _alpha2.end())
						it->second.push_back(output);
					else {
						countries.clear();
						countries.push_back(output);
						_alpha2[output.at(0)] = countries;
					}
				}
			}
			stream.close();
		}
	}


public:
	virtual ~cISO3166CountryInfo() { }
	int isValidAlpha2(const char *alpha2,
			eISO3166CountryType type = ISO3166_COUNTRY_CODE_ALPHA2) {
		size_t length = 0;
		::std::string alphastr;
		::std::vector < ::std::string >::iterator vit;
		::std::map< char, ::std::vector< ::std::string > >::iterator mit;

		if (!alpha2 || type != ISO3166_COUNTRY_CODE_ALPHA2 ||
				(length = strlen(alpha2)) != 2)
			return -EINVAL;

		alphastr = alpha2;
		if ((mit = _alpha2.find(alphastr.at(0))) != _alpha2.end())
			if (::std::find(mit->second.begin(), mit->second.end(), alphastr)
					!= mit->second.end())
				return 0;

		return -ENOENT;
	}
};

	}
}

#endif //_ISO3166_COUNTYR_INFO_H

/** @} */
