/**
 * @file CountryCodeClientInfo.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */
#ifndef _COUNTRY_CODE_CLIENT_INFO_H
#define _COUNTRY_CODE_CLIENT_INFO_H

#include <string.h>
#include "WBLUtils.h"

/* Country code Type */
#define CC_TYPE_ALPHA2			BIT(0)
#define CC_TYPE_ALPHA3			BIT(1)
#define CC_TYPE_NUMERIC			BIT(2)
#define CC_TYPE_MCC				BIT(3)

/* Country Code Source */
#define CC_SOURCE_GNSS			BIT(0)
#define CC_SOURCE_MCC			BIT(1)
#define CC_SOURCE_IEEE80211D	BIT(2)
#define CC_SOURCE_IPADDR		BIT(3)
#define CC_SOURCE_LASTMODE		BIT(4)

namespace org {
	namespace bosch {

typedef enum cc_type_info {
	eCC_TYPE_INVAL = 0,
	eCC_TYPE_ALPHA2,
	eCC_TYPE_ALPHA3,
	eCC_TYPE_NUMERIC,
	eCC_TYPE_MCC
} cc_type_t;

typedef enum cc_source_info {
	eCC_SOURCE_INVAL = 0,
	eCC_SOURCE_GNSS,
	eCC_SOURCE_MCC,
	eCC_SOURCE_IEEE80211D,
	eCC_SOURCE_IPADDR,
	eCC_SOURCE_LASTMODE
} cc_source_t;

typedef enum cc_service_availability {
	SERVICE_UNAVAILABLE = 0,
	SERVICE_AVAILABLE
} cc_availability_t;

class cCountryCodeClientInfo {

public:

	explicit cCountryCodeClientInfo(const cc_source_t src, const uint32_t type) {
		_numeric_cc = 0;
		_cc_source = src;
		_cc_type = type;
		_serviceAvailability = SERVICE_UNAVAILABLE;
	}
	virtual ~cCountryCodeClientInfo() { }

	virtual void setCountryCodeInfo (const cc_availability_t serAvail,
			const ::std::string &cc, const uint16_t numeric) {
		_numeric_cc = numeric;
		_country = cc;
		_serviceAvailability = serAvail;
	}

	cc_source_t &getCCSourceInfo() {
		return _cc_source;
	}

	static ::std::string CCSourceToString(const cc_source_t cc_src)
	{
		::std::string src;

		switch (cc_src) {
		default:
		case eCC_SOURCE_INVAL:
			src = "SOURCE_INVAL";
			break;
		case eCC_SOURCE_GNSS:
			src = "SOURCE_GNSS";
			break;
		case eCC_SOURCE_MCC:
			src = "SOURCE_MCC";
			break;
		case eCC_SOURCE_IEEE80211D:
			src = "SOURCE_IEEE80211D";
			break;
		case eCC_SOURCE_IPADDR:
			src = "SOURCE_IPADDR";
			break;
		case eCC_SOURCE_LASTMODE:
			src = "SOURCE_LASTMODE";
			break;
		}

		return src;
	}

protected:
	::std::string _country;
	uint16_t _numeric_cc;
	uint32_t _cc_type;
	cc_source_t _cc_source;
	cc_availability_t _serviceAvailability;
};

	}
}

#endif //_COUNTRY_CODE_CLIENT_INFO_H

/** @} */
