/**
 * @file NavigationUpdateNotif.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */
#ifndef _NAVIGATION_UPDATE_NOTIF_H
#define _NAVIGATION_UPDATE_NOTIF_H

#include <cmath>
#include "asf/core/Logger.h"
#include "CountryChangeNotifier.h"

#define GET_ALPHA2_FROM_TABLE_A(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("AND")) alpha2.assign("AD");	\
			else if (!alpha3.compare("ARE")) alpha2.assign("AE");	\
			else if (!alpha3.compare("AFG")) alpha2.assign("AF");	\
			else if (!alpha3.compare("ATG")) alpha2.assign("AG");	\
			else if (!alpha3.compare("AIA")) alpha2.assign("AI");	\
			else if (!alpha3.compare("ALB")) alpha2.assign("AL");	\
			else if (!alpha3.compare("ARM")) alpha2.assign("AM");	\
			else if (!alpha3.compare("ANT")) alpha2.assign("AN");	\
			else if (!alpha3.compare("AGO")) alpha2.assign("AO");	\
			else if (!alpha3.compare("ATA")) alpha2.assign("AQ");	\
			else if (!alpha3.compare("ARG")) alpha2.assign("AR");	\
			else if (!alpha3.compare("ASM")) alpha2.assign("AS");	\
			else if (!alpha3.compare("AUT")) alpha2.assign("AT");	\
			else if (!alpha3.compare("AUS")) alpha2.assign("AU");	\
			else if (!alpha3.compare("ABW")) alpha2.assign("AW");	\
			else if (!alpha3.compare("ALA")) alpha2.assign("AX");	\
			else if (!alpha3.compare("AZE")) alpha2.assign("AZ");	\
			else if (!alpha3.compare("ATF")) alpha2.assign("TF");	\
		} while (0);
#define GET_ALPHA2_FROM_TABLE_B(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("BIH")) alpha2.assign("BA");	\
			else if (!alpha3.compare("BRB")) alpha2.assign("BB");	\
			else if (!alpha3.compare("BGD")) alpha2.assign("BD");	\
			else if (!alpha3.compare("BEL")) alpha2.assign("BE");	\
			else if (!alpha3.compare("BFA")) alpha2.assign("BF");	\
			else if (!alpha3.compare("BGR")) alpha2.assign("BG");	\
			else if (!alpha3.compare("BHR")) alpha2.assign("BH");	\
			else if (!alpha3.compare("BDI")) alpha2.assign("BI");	\
			else if (!alpha3.compare("BEN")) alpha2.assign("BJ");	\
			else if (!alpha3.compare("BES")) alpha2.assign("BQ");	\
			else if (!alpha3.compare("BMU")) alpha2.assign("BM");	\
			else if (!alpha3.compare("BRN")) alpha2.assign("BN");	\
			else if (!alpha3.compare("BOL")) alpha2.assign("BO");	\
			else if (!alpha3.compare("BRA")) alpha2.assign("BR");	\
			else if (!alpha3.compare("BHS")) alpha2.assign("BS");	\
			else if (!alpha3.compare("BTN")) alpha2.assign("BT");	\
			else if (!alpha3.compare("BVT")) alpha2.assign("BV");	\
			else if (!alpha3.compare("BWA")) alpha2.assign("BW");	\
			else if (!alpha3.compare("BLM")) alpha2.assign("BL");	\
			else if (!alpha3.compare("BLR")) alpha2.assign("BY");	\
			else if (!alpha3.compare("BLZ")) alpha2.assign("BZ");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_C(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("CAN")) alpha2.assign("CA");	\
			else if (!alpha3.compare("CCK")) alpha2.assign("CC");	\
			else if (!alpha3.compare("COD")) alpha2.assign("CD");	\
			else if (!alpha3.compare("CAF")) alpha2.assign("CF");	\
			else if (!alpha3.compare("COG")) alpha2.assign("CG");	\
			else if (!alpha3.compare("CHE")) alpha2.assign("CH");	\
			else if (!alpha3.compare("CIV")) alpha2.assign("CI");	\
			else if (!alpha3.compare("COK")) alpha2.assign("CK");	\
			else if (!alpha3.compare("CHL")) alpha2.assign("CL");	\
			else if (!alpha3.compare("CMR")) alpha2.assign("CM");	\
			else if (!alpha3.compare("CHN")) alpha2.assign("CN");	\
			else if (!alpha3.compare("COL")) alpha2.assign("CO");	\
			else if (!alpha3.compare("CRI")) alpha2.assign("CR");	\
			else if (!alpha3.compare("CUB")) alpha2.assign("CU");	\
			else if (!alpha3.compare("CUW")) alpha2.assign("CW");	\
			else if (!alpha3.compare("CPV")) alpha2.assign("CV");	\
			else if (!alpha3.compare("CXR")) alpha2.assign("CX");	\
			else if (!alpha3.compare("CYP")) alpha2.assign("CY");	\
			else if (!alpha3.compare("CZE")) alpha2.assign("CZ");	\
			else if (!alpha3.compare("CYM")) alpha2.assign("KY");	\
			else if (!alpha3.compare("COM")) alpha2.assign("KM");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_D(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("DEU")) alpha2.assign("DE");	\
			else if (!alpha3.compare("DJI")) alpha2.assign("DJ");	\
			else if (!alpha3.compare("DNK")) alpha2.assign("DK");	\
			else if (!alpha3.compare("DMA")) alpha2.assign("DM");	\
			else if (!alpha3.compare("DOM")) alpha2.assign("DO");	\
			else if (!alpha3.compare("DZA")) alpha2.assign("DZ");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_E(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("ECU")) alpha2.assign("EC");	\
			else if (!alpha3.compare("EST")) alpha2.assign("EE");	\
			else if (!alpha3.compare("EGY")) alpha2.assign("EG");	\
			else if (!alpha3.compare("ESH")) alpha2.assign("EH");	\
			else if (!alpha3.compare("ERI")) alpha2.assign("ER");	\
			else if (!alpha3.compare("ESP")) alpha2.assign("ES");	\
			else if (!alpha3.compare("ETH")) alpha2.assign("ET");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_F(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("FIN")) alpha2.assign("FI");	\
			else if (!alpha3.compare("FJI")) alpha2.assign("FJ");	\
			else if (!alpha3.compare("FLK")) alpha2.assign("FK");	\
			else if (!alpha3.compare("FSM")) alpha2.assign("FM");	\
			else if (!alpha3.compare("FRO")) alpha2.assign("FO");	\
			else if (!alpha3.compare("FRA")) alpha2.assign("FR");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_G(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("GAB")) alpha2.assign("GA");	\
			else if (!alpha3.compare("GBR")) alpha2.assign("GB");	\
			else if (!alpha3.compare("GRD")) alpha2.assign("GD");	\
			else if (!alpha3.compare("GEO")) alpha2.assign("GE");	\
			else if (!alpha3.compare("GGY")) alpha2.assign("GG");	\
			else if (!alpha3.compare("GUF")) alpha2.assign("GF");	\
			else if (!alpha3.compare("GHA")) alpha2.assign("GH");	\
			else if (!alpha3.compare("GIB")) alpha2.assign("GI");	\
			else if (!alpha3.compare("GRL")) alpha2.assign("GL");	\
			else if (!alpha3.compare("GMB")) alpha2.assign("GM");	\
			else if (!alpha3.compare("GIN")) alpha2.assign("GN");	\
			else if (!alpha3.compare("GLP")) alpha2.assign("GP");	\
			else if (!alpha3.compare("GNQ")) alpha2.assign("GQ");	\
			else if (!alpha3.compare("GRC")) alpha2.assign("GR");	\
			else if (!alpha3.compare("GTM")) alpha2.assign("GT");	\
			else if (!alpha3.compare("GUM")) alpha2.assign("GU");	\
			else if (!alpha3.compare("GNB")) alpha2.assign("GW");	\
			else if (!alpha3.compare("GUY")) alpha2.assign("GY");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_H(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("HKG")) alpha2.assign("HK");	\
			else if (!alpha3.compare("HMD")) alpha2.assign("HM");	\
			else if (!alpha3.compare("HND")) alpha2.assign("HN");	\
			else if (!alpha3.compare("HRV")) alpha2.assign("HR");	\
			else if (!alpha3.compare("HTI")) alpha2.assign("HT");	\
			else if (!alpha3.compare("HUN")) alpha2.assign("HU");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_I(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("IDN")) alpha2.assign("ID");	\
			else if (!alpha3.compare("IMN")) alpha2.assign("IM");	\
			else if (!alpha3.compare("IRL")) alpha2.assign("IE");	\
			else if (!alpha3.compare("ISR")) alpha2.assign("IL");	\
			else if (!alpha3.compare("IND")) alpha2.assign("IN");	\
			else if (!alpha3.compare("IOT")) alpha2.assign("IO");	\
			else if (!alpha3.compare("IRQ")) alpha2.assign("IQ");	\
			else if (!alpha3.compare("IRN")) alpha2.assign("IR");	\
			else if (!alpha3.compare("ISL")) alpha2.assign("IS");	\
			else if (!alpha3.compare("ITA")) alpha2.assign("IT");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_J(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("JAM")) alpha2.assign("JM");	\
			else if (!alpha3.compare("JOR")) alpha2.assign("JO");	\
			else if (!alpha3.compare("JPN")) alpha2.assign("JP");	\
			else if (!alpha3.compare("JEY")) alpha2.assign("JE");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_K(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("KEN")) alpha2.assign("KE");	\
			else if (!alpha3.compare("KGZ")) alpha2.assign("KG");	\
			else if (!alpha3.compare("KHM")) alpha2.assign("KH");	\
			else if (!alpha3.compare("KIR")) alpha2.assign("KI");	\
			else if (!alpha3.compare("KNA")) alpha2.assign("KN");	\
			else if (!alpha3.compare("KOR")) alpha2.assign("KR");	\
			else if (!alpha3.compare("KWT")) alpha2.assign("KW");	\
			else if (!alpha3.compare("KAZ")) alpha2.assign("KZ");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_L(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("LAO")) alpha2.assign("LA");	\
			else if (!alpha3.compare("LBN")) alpha2.assign("LB");	\
			else if (!alpha3.compare("LCA")) alpha2.assign("LC");	\
			else if (!alpha3.compare("LIE")) alpha2.assign("LI");	\
			else if (!alpha3.compare("LKA")) alpha2.assign("LK");	\
			else if (!alpha3.compare("LBR")) alpha2.assign("LR");	\
			else if (!alpha3.compare("LSO")) alpha2.assign("LS");	\
			else if (!alpha3.compare("LTU")) alpha2.assign("LT");	\
			else if (!alpha3.compare("LUX")) alpha2.assign("LU");	\
			else if (!alpha3.compare("LVA")) alpha2.assign("LV");	\
			else if (!alpha3.compare("LBY")) alpha2.assign("LY");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_M(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("MAR")) alpha2.assign("MA");	\
			else if (!alpha3.compare("MCO")) alpha2.assign("MC");	\
			else if (!alpha3.compare("MDA")) alpha2.assign("MD");	\
			else if (!alpha3.compare("MDG")) alpha2.assign("MG");	\
			else if (!alpha3.compare("MHL")) alpha2.assign("MH");	\
			else if (!alpha3.compare("MKD")) alpha2.assign("MK");	\
			else if (!alpha3.compare("MLI")) alpha2.assign("ML");	\
			else if (!alpha3.compare("MMR")) alpha2.assign("MM");	\
			else if (!alpha3.compare("MNG")) alpha2.assign("MN");	\
			else if (!alpha3.compare("MAC")) alpha2.assign("MO");	\
			else if (!alpha3.compare("MAF")) alpha2.assign("MF");	\
			else if (!alpha3.compare("MNE")) alpha2.assign("ME");	\
			else if (!alpha3.compare("MNP")) alpha2.assign("MP");	\
			else if (!alpha3.compare("MTQ")) alpha2.assign("MQ");	\
			else if (!alpha3.compare("MRT")) alpha2.assign("MR");	\
			else if (!alpha3.compare("MSR")) alpha2.assign("MS");	\
			else if (!alpha3.compare("MLT")) alpha2.assign("MT");	\
			else if (!alpha3.compare("MUS")) alpha2.assign("MU");	\
			else if (!alpha3.compare("MDV")) alpha2.assign("MV");	\
			else if (!alpha3.compare("MWI")) alpha2.assign("MW");	\
			else if (!alpha3.compare("MEX")) alpha2.assign("MX");	\
			else if (!alpha3.compare("MYS")) alpha2.assign("MY");	\
			else if (!alpha3.compare("MOZ")) alpha2.assign("MZ");	\
			else if (!alpha3.compare("MYT")) alpha2.assign("YT");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_N(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("NAM")) alpha2.assign("NA");	\
			else if (!alpha3.compare("NCL")) alpha2.assign("NC");	\
			else if (!alpha3.compare("NER")) alpha2.assign("NE");	\
			else if (!alpha3.compare("NFK")) alpha2.assign("NF");	\
			else if (!alpha3.compare("NGA")) alpha2.assign("NG");	\
			else if (!alpha3.compare("NIC")) alpha2.assign("NI");	\
			else if (!alpha3.compare("NLD")) alpha2.assign("NL");	\
			else if (!alpha3.compare("NOR")) alpha2.assign("NO");	\
			else if (!alpha3.compare("NPL")) alpha2.assign("NP");	\
			else if (!alpha3.compare("NRU")) alpha2.assign("NR");	\
			else if (!alpha3.compare("NIU")) alpha2.assign("NU");	\
			else if (!alpha3.compare("NZL")) alpha2.assign("NZ");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_O(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("OMN")) alpha2.assign("OM");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_P(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("PAN")) alpha2.assign("PA");	\
			else if (!alpha3.compare("PER")) alpha2.assign("PE");	\
			else if (!alpha3.compare("PYF")) alpha2.assign("PF");	\
			else if (!alpha3.compare("PNG")) alpha2.assign("PG");	\
			else if (!alpha3.compare("PHL")) alpha2.assign("PH");	\
			else if (!alpha3.compare("PAK")) alpha2.assign("PK");	\
			else if (!alpha3.compare("POL")) alpha2.assign("PL");	\
			else if (!alpha3.compare("PCN")) alpha2.assign("PN");	\
			else if (!alpha3.compare("PRI")) alpha2.assign("PR");	\
			else if (!alpha3.compare("PSE")) alpha2.assign("PS");	\
			else if (!alpha3.compare("PRT")) alpha2.assign("PT");	\
			else if (!alpha3.compare("PLW")) alpha2.assign("PW");	\
			else if (!alpha3.compare("PRY")) alpha2.assign("PY");	\
			else if (!alpha3.compare("PRK")) alpha2.assign("KP");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_Q(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("QAT")) alpha2.assign("QA");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_R(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("REU")) alpha2.assign("RE");	\
			else if (!alpha3.compare("ROU")) alpha2.assign("RO");	\
			else if (!alpha3.compare("RUS")) alpha2.assign("RU");	\
			else if (!alpha3.compare("RWA")) alpha2.assign("RW");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_S(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("SAU")) alpha2.assign("SA");	\
			else if (!alpha3.compare("SLB")) alpha2.assign("SB");	\
			else if (!alpha3.compare("SYC")) alpha2.assign("SC");	\
			else if (!alpha3.compare("SDN")) alpha2.assign("SD");	\
			else if (!alpha3.compare("SWE")) alpha2.assign("SE");	\
			else if (!alpha3.compare("SGP")) alpha2.assign("SG");	\
			else if (!alpha3.compare("SHN")) alpha2.assign("SH");	\
			else if (!alpha3.compare("SVN")) alpha2.assign("SI");	\
			else if (!alpha3.compare("SJM")) alpha2.assign("SJ");	\
			else if (!alpha3.compare("SVK")) alpha2.assign("SK");	\
			else if (!alpha3.compare("SLE")) alpha2.assign("SL");	\
			else if (!alpha3.compare("SMR")) alpha2.assign("SM");	\
			else if (!alpha3.compare("SEN")) alpha2.assign("SN");	\
			else if (!alpha3.compare("SOM")) alpha2.assign("SO");	\
			else if (!alpha3.compare("SUR")) alpha2.assign("SR");	\
			else if (!alpha3.compare("STP")) alpha2.assign("ST");	\
			else if (!alpha3.compare("SLV")) alpha2.assign("SV");	\
			else if (!alpha3.compare("SYR")) alpha2.assign("SY");	\
			else if (!alpha3.compare("SWZ")) alpha2.assign("SZ");	\
			else if (!alpha3.compare("SXM")) alpha2.assign("SX");	\
			else if (!alpha3.compare("SRB")) alpha2.assign("RS");	\
			else if (!alpha3.compare("SPM")) alpha2.assign("PM");	\
			else if (!alpha3.compare("SCG")) alpha2.assign("CS");	\
			else if (!alpha3.compare("SGS")) alpha2.assign("GS");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_T(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("TCA")) alpha2.assign("TC");	\
			else if (!alpha3.compare("TCD")) alpha2.assign("TD");	\
			else if (!alpha3.compare("TGO")) alpha2.assign("TG");	\
			else if (!alpha3.compare("THA")) alpha2.assign("TH");	\
			else if (!alpha3.compare("TJK")) alpha2.assign("TJ");	\
			else if (!alpha3.compare("TKL")) alpha2.assign("TK");	\
			else if (!alpha3.compare("TLS")) alpha2.assign("TL");	\
			else if (!alpha3.compare("TKM")) alpha2.assign("TM");	\
			else if (!alpha3.compare("TUN")) alpha2.assign("TN");	\
			else if (!alpha3.compare("TON")) alpha2.assign("TO");	\
			else if (!alpha3.compare("TUR")) alpha2.assign("TR");	\
			else if (!alpha3.compare("TTO")) alpha2.assign("TT");	\
			else if (!alpha3.compare("TUV")) alpha2.assign("TV");	\
			else if (!alpha3.compare("TWN")) alpha2.assign("TW");	\
			else if (!alpha3.compare("TZA")) alpha2.assign("TZ");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_U(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("UKR")) alpha2.assign("UA");	\
			else if (!alpha3.compare("UGA")) alpha2.assign("UG");	\
			else if (!alpha3.compare("UMI")) alpha2.assign("UM");	\
			else if (!alpha3.compare("USA")) alpha2.assign("US");	\
			else if (!alpha3.compare("URY")) alpha2.assign("UY");	\
			else if (!alpha3.compare("UZB")) alpha2.assign("UZ");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_V(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("VAT")) alpha2.assign("VA");	\
			else if (!alpha3.compare("VCT")) alpha2.assign("VC");	\
			else if (!alpha3.compare("VEN")) alpha2.assign("VE");	\
			else if (!alpha3.compare("VGB")) alpha2.assign("VG");	\
			else if (!alpha3.compare("VIR")) alpha2.assign("VI");	\
			else if (!alpha3.compare("VNM")) alpha2.assign("VN");	\
			else if (!alpha3.compare("VUT")) alpha2.assign("VU");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_W(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("WLF")) alpha2.assign("WF");	\
			else if (!alpha3.compare("WSM")) alpha2.assign("WS");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_Y(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("YEM")) alpha2.assign("YE");	\
		} while(0);
#define GET_ALPHA2_FROM_TABLE_Z(alpha3, alpha2)	\
		do {	\
			if (!alpha3.compare("ZAF")) alpha2.assign("ZA");	\
			else if (!alpha3.compare("ZMB")) alpha2.assign("ZM");	\
			else if (!alpha3.compare("ZWE")) alpha2.assign("ZW");	\
		} while(0);

namespace org {
	namespace bosch {

class cCountryChangeUpdate;

typedef enum {
	NAV_METHOD_PRIO_LOW = -100,
	NAV_METHOD_PRIO_DEFAULT = 0,
	NAV_METHOD_PRIO_HIGH = 100
} eNavMethodPriority_t;

class cNavigationUpdateNotifier :
		public cCountryChangeNotifier {

public:

	explicit cNavigationUpdateNotifier(const eNavMethodPriority_t prio) {
		_serviceAvailability = false;
		_ccupdate = false;
		_priority = prio;
	}
	virtual ~cNavigationUpdateNotifier() { }

	int getMethodPriority() {
		return _priority;
	}
	static bool NavPrioComparison (cNavigationUpdateNotifier *method1,
			cNavigationUpdateNotifier *method2) {
		return method1->getMethodPriority() > method2->getMethodPriority();
	}

	virtual void updateCountryCodeChange(bool update) {
		::asf::core::Logger oLogger("wifi_business_logic/Regulation",
				::asf::core::Logger::Debug);
		oLogger.info ("%p Current updated Status: %s Changed status: %s", __LINE__, __FILE__,
				this, _ccupdate ? "Update" : "Dont_Update", update ? "Update"
						: "Dont_Update");
		_ccupdate = update;
	}

	virtual void updateCountryCodeInfo() = 0;

	void updateCCodeInfo() {
		::asf::core::Logger oLogger("wifi_business_logic/Regulation",
				::asf::core::Logger::Debug);

		oLogger.info ("%p Current updated Status: %s", __LINE__, __FILE__,
				this, _ccupdate ? "Update" : "Dont_Update");

		if (_ccupdate)
			updateCountryCodeInfo();
	}

protected:
	bool _ccupdate;

	void notifyCountryChange(const ::std::string &country) {
		if (_ccupdate)
			updateCountryChange(country);
	}

	::std::string convertAlpha3ToAlpha2(const ::std::string alpha3)
	{
		char first = '\0';
		::std::string alpha2;

		if (!alpha3.empty()) {

			first = alpha3.at(0);
			if (first == 'A') {
				GET_ALPHA2_FROM_TABLE_A(alpha3, alpha2);
			}
			else if (first == 'B') {
				GET_ALPHA2_FROM_TABLE_B(alpha3, alpha2);
			}
			else if (first == 'C') {
				GET_ALPHA2_FROM_TABLE_C(alpha3, alpha2);
			}
			else if (first == 'D') {
				GET_ALPHA2_FROM_TABLE_D(alpha3, alpha2);
			}
			else if (first == 'E') {
				GET_ALPHA2_FROM_TABLE_E(alpha3, alpha2);
			}
			else if (first == 'F') {
				GET_ALPHA2_FROM_TABLE_F(alpha3, alpha2);
			}
			else if (first == 'G') {
				GET_ALPHA2_FROM_TABLE_G(alpha3, alpha2);
			}
			else if (first == 'H') {
				GET_ALPHA2_FROM_TABLE_H(alpha3, alpha2);
			}
			else if (first == 'I') {
				GET_ALPHA2_FROM_TABLE_I(alpha3, alpha2);
			}
			else if (first == 'J') {
				GET_ALPHA2_FROM_TABLE_J(alpha3, alpha2);
			}
			else if (first == 'K') {
				GET_ALPHA2_FROM_TABLE_K(alpha3, alpha2);
			}
			else if (first == 'L') {
				GET_ALPHA2_FROM_TABLE_L(alpha3, alpha2);
			}
			else if (first == 'M') {
				GET_ALPHA2_FROM_TABLE_M(alpha3, alpha2);
			}
			else if (first == 'N') {
				GET_ALPHA2_FROM_TABLE_N(alpha3, alpha2);
			}
			else if (first == 'O') {
				GET_ALPHA2_FROM_TABLE_O(alpha3, alpha2);
			}
			else if (first == 'P') {
				GET_ALPHA2_FROM_TABLE_P(alpha3, alpha2);
			}
			else if (first == 'Q') {
				GET_ALPHA2_FROM_TABLE_Q(alpha3, alpha2);
			}
			else if (first == 'R') {
				GET_ALPHA2_FROM_TABLE_R(alpha3, alpha2);
			}
			else if (first == 'S') {
				GET_ALPHA2_FROM_TABLE_S(alpha3, alpha2);
			}
			else if (first == 'T') {
				GET_ALPHA2_FROM_TABLE_T(alpha3, alpha2);
			}
			else if (first == 'U') {
				GET_ALPHA2_FROM_TABLE_U(alpha3, alpha2);
			}
			else if (first == 'V') {
				GET_ALPHA2_FROM_TABLE_V(alpha3, alpha2);
			}
			else if (first == 'W') {
				GET_ALPHA2_FROM_TABLE_W(alpha3, alpha2);
			}
			else if (first == 'Y') {
				GET_ALPHA2_FROM_TABLE_Y(alpha3, alpha2);
			}
			else if (first == 'Z') {
				GET_ALPHA2_FROM_TABLE_Z(alpha3, alpha2);
			}
		}

		return alpha2;
	}

private:
	eNavMethodPriority_t _priority;
};

	}
}

#endif //_NAVIGATION_UPDATE_NOTIF_H

/** @} */
