/**
 * @file WBLPriorityManager.h
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */
#ifndef _WBL_PRIORITY_MANAGER_H
#define _WBL_PRIORITY_MANAGER_H

#include "asf/core/Logger.h"
#include "IWBLPriorityManager.h"


namespace org
{
namespace bosch
{

using namespace ::asf::core;

class WBLPriorityManager : public IWBLPriorityManager
{
public:
   WBLPriorityManager();
   virtual ~WBLPriorityManager();

   virtual void updateAllInterfaces() override;
   virtual void onPMChangeinModes(PriorityList& list) override;
   virtual void onPMChangeinTimer(uint& timer) override;

   virtual void getWifiPriorityList(PriorityList& list)const override {list = _wifiPriorityList;}

   uint getConflictTimer() override {return _timer;}

private:

   void loadDefaultModeValues(PriorityList& list);
   void loadDefaultTimerValue(uint& timer);
   PriorityList _wifiPriorityList;
   uint32 _timer;

   DECLARE_CLASS_LOGGER();
};

   } // namespace bosch
   }// namespace org

#endif //_WBL_PRIORITY_MANAGER_H

/** @} */
