/**
 * @file IWBLPriorityManager.h
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef I_WBL_PRIORITY_MANAGER_H
#define I_WBL_PRIORITY_MANAGER_H

#include "WBLMessageTypes.h"

namespace org
{
namespace bosch
{

class IWBLPriorityManager
{
public:
   virtual ~IWBLPriorityManager()
   {
   }

   virtual void updateAllInterfaces() = 0;
   virtual void onPMChangeinModes(PriorityList &modes) = 0;
   virtual void onPMChangeinTimer(uint &timer) = 0;
   virtual void getWifiPriorityList(PriorityList& list)const = 0;
   virtual uint getConflictTimer() = 0;
   //TO DO: Add for properties here
};

} //namespace bosch
} //namespace org

#endif /* I_WBL_PRIORITY_MANAGER_H */

/** @} */
