/**
 * @file APConfigurationManager.cpp
 * @author RBEI/ECO3 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include "APConfigurationManager.h"
#include "FwStringUtils.h"
namespace org
{
namespace bosch
{

#define DEFAULT_AP_PASSPHRASE_LENGTH 12

DEFINE_CLASS_LOGGER_AND_LEVEL("wifi_business_logic/APConfigurationManager", APConfigurationManager, Debug);

APConfigurationManager::APConfigurationManager()
{
   LOG_INFO("APConfigurationManager::%s", __func__);
}

APConfigurationManager::~APConfigurationManager()
{
}
::std::string APConfigurationManager::getAPTypePassphrase(WBLAPType apType)
{
    LOG_INFO("APConfigurationManager::%s", __func__);
    ::std::string passphrase;
    IDBManager* dbmgrIf = DBManagerFactory::getInstance()->getDBManagerIf();
    if (dbmgrIf)
    {
        passphrase = dbmgrIf->getAPTypePassphrase(apType);
    }
    //If no passphrase generate the passphrase
    if(passphrase.empty())
    {
        passphrase = generateRandomPassphrase();
    }
    return passphrase;
}

::std::string APConfigurationManager::generateRandomPassphrase(const int pwdlength)
{
    LOG_INFO("APConfigurationManager::%s", __func__);
    ::std::string passphrase;
    int len = pwdlength;
    if (len <= 0)
        len = DEFAULT_AP_PASSPHRASE_LENGTH;
    unsigned char* csprngPWD = new unsigned char[len + 1];
    //Openssl Rand_bytes provide CSPRNG passphrase
    int retStatus = RAND_bytes(csprngPWD, len);
    if (!retStatus)
    {
        LOG_DEBUG("APConfigurationManager::%s Passphrase Generation Error :%d",
                __func__, retStatus);
    }
    else
    {
        passphrase = bByteToHexStrConvert(csprngPWD);
        LOG_DEBUG("APConfigurationManager::%s passphrase:%s", __func__,passphrase.c_str());
    }
    delete[] csprngPWD;
    return passphrase;
}

::std::string APConfigurationManager::bByteToHexStrConvert(unsigned char* byteInput)
{
    LOG_INFO("APConfigurationManager::%s", __func__);
    ::std::string pass;
    const uint8_t *temp= byteInput;
    char arr[3];
    for (auto i=0 ; temp[i]; i++)
    {
       memset(arr, 0, sizeof (arr));
       ::fw::convertByte2HexString(arr,static_cast<unsigned char>(temp[i]),(i%2)?true:false);
       pass.append(arr);
    }
    return pass;
}

} // namespace bosch
} // namespace org
