/**
 * @file APConfigurationManager.h
 * @author RBEI/ECO3 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _AP_CONFIGURATION_MANAGER_H
#define _AP_CONFIGURATION_MANAGER_H

#include "asf/core/Logger.h"
#include "GenericSingleton.h"
#include "DBManagerFactory.h"
#include <openssl/rand.h>

namespace org
{
namespace bosch
{

class APConfigurationManager final:public GenericSingleton<APConfigurationManager>
{
public:
    virtual ~APConfigurationManager();
    APConfigurationManager(const APConfigurationManager &r) = delete;
    const APConfigurationManager &operator=(const APConfigurationManager &r) = delete;
    ::std::string generateRandomPassphrase(const int length = 0);
    ::std::string getAPTypePassphrase(WBLAPType apType);
    ::std::string bByteToHexStrConvert(unsigned char* byteInput);

    DECLARE_CLASS_LOGGER();
private:
    APConfigurationManager();
    friend class GenericSingleton<APConfigurationManager>;

    /*Client Request for PrepareSetup in AAW/CPW AP Type.
     * If the Requested Type is CPW/AAW it would check the DB for the passphrase for particular APType
     * and if available it would use the same passphrase to prepare the setup else it would use the RAND_METHOD
     * from openSSL library to prepare the cryptographically secure passphrase.
     * If clients wanted to explicitly change the passphrase then they could use Randomize action type
     * which also generates passphrase using RAND_METHOD.
     * After the preparation of RequestedSetup WBL
     * would update the LastIntendedMode DB with the passphrase along with the APType.
     */

};

} // namespace bosch
} // namespace org

#endif //_AP_CONFIGURATION_MANAGER_H
