/**
 * @file IEEE80211EventNotifier.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
 
 
#include <cstdio>
#include "IEEE80211EventObserver.h"
#include "IEEE80211EventNotifier.h"

namespace org
{
namespace bosch
{

DEFINE_CLASS_LOGGER_AND_LEVEL("wifi_business_logic/IEEE80211Clients", IEEE80211EventNotifier, Info);

IEEE80211EventNotifier::IEEE80211EventNotifier()
{

   LOG_INFO ("IEEE80211EventNotifier() entered ");
}

IEEE80211EventNotifier::~IEEE80211EventNotifier()
{
   try
   {
	_observers.clear();
   }catch(...){}
} 

bool IEEE80211EventNotifier::registerObserver(IEEE80211EventType type, IEEE80211EventObserver* observer)
{
   LOG_INFO ("IEEE80211EventNotifier::registerObserver() entered ");
   if (observer)
   {
      _observers[type] = observer;
      return true;
   }
   return false;
}

bool IEEE80211EventNotifier::deregisterObserver(IEEE80211EventType type, IEEE80211EventObserver* observer)
{
    
   (void)observer;
   LOG_INFO ("IEEE80211EventNotifier::deregisterObserver() entered ");
   std::map<IEEE80211EventType, IEEE80211EventObserver*>::iterator it = _observers.find(type);
   if (_observers.end() != it)
   {
      _observers.erase(it);
      return true;
   }

   return false;
}

bool IEEE80211EventNotifier::notifyObservers(IEEE80211EventType type, const IEEE80211EventMsg* msg) const
{
   LOG_INFO ("IEEE80211EventNotifier::notifyObservers() entered ");
   std::map<IEEE80211EventType, IEEE80211EventObserver*>::const_iterator it = _observers.find(type);
   if ((_observers.end() != it) && (it->second))
   {
      it->second->processIEEE80211Event(type, msg);
      return true;
   }
   return false;
}

} //namespace bosch
} //namespace org

/** @} */
