/**
 * @file IEEE80211EventMsg.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#include "IEEE80211EventMsg.h"

namespace org
{
namespace bosch
{
	
IEEE80211EventMsg::IEEE80211EventMsg(IEEE80211EventID msgID) :
   _msgID(msgID), 
   _errcode(IEEE80211_ERROR_NONE)
{

}

IEEE80211EventMsg::~IEEE80211EventMsg()
{
   _msgID = IEEE80211_MSG_UNKNOWN;
   _errcode = IEEE80211_ERROR_NONE;

}

IEEE80211EventMsg::IEEE80211EventMsg(const IEEE80211EventMsg& ref)
{
   *this = ref;
}

IEEE80211EventMsg& IEEE80211EventMsg::operator=(const IEEE80211EventMsg& ref)
{
   if (this == &ref)
   {
      return *this;
   }
   this->_msgID = ref._msgID;
   this->_errcode = ref._errcode;

   return *this;
}

void IEEE80211EventMsg::printIEEE80211EventMsg() const
{

}

void IEEE80211EventMsg::setIEEE80211ErrCode(IEEE80211ErrorCode err)
{
   _errcode = err;
}

IEEE80211ErrorCode IEEE80211EventMsg::getIEEE80211ErrCode() const
{
   return _errcode;
}

IEEE80211EventID IEEE80211EventMsg::getIEEE80211EventID() const
{
   return _msgID;
}

void IEEE80211EventMsg::setIEEE80211EventID(const IEEE80211EventID msgID)
{
	_msgID = msgID;
}

} //namespace bosch
} //namespace org

/** @} */