/**
 * @file WifiConnectionStatus
 * @author RBEI/ECO3 Karthikeyan Madeswaran
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */
#ifndef _WIFICONNECTIONSTATUS_H_
#define _WIFICONNECTIONSTATUS_H_

#include "asf/core/AsyncTask.h"
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
#include "asf/threading/Once.h"
#include "asf/core/Types.h"

#include <linux/nl80211.h>
#include "WBLUtils.h"
#include "WatchDog.h"
#include "NetlinkSocket.h"
#include "GenericSingleton.h"
#include "WifiMlmeUpdates.h"
#include "WBLMessageTypes.h"
#include "asf/core/Timer.h"
#include "WBLTypeProperties.h"

struct nl_msg;
struct nlattr;
struct nl_sock;

typedef int (*iEventhandler) (struct nl_msg *, void *);

namespace org {
   namespace bosch {

using namespace ::asf::core;
using namespace ::asf::threading;

class cWifiConnectionStatusNotifier;
class cWifiConnectionStatusObserver;

class cWifiConnectionWatchDog : public cWatchDog {
public:
   cWifiConnectionWatchDog();
   ~cWifiConnectionWatchDog();
   int start () override;
   int stop(bool reset) override;
   virtual void expired(::boost::shared_ptr< ::asf::core::TimerPayload > data) override;
private:
   struct timespec _startTime;
   DECLARE_CLASS_LOGGER();
};

class cWifiHealthCalculator :public AsyncResultTask <uint32>
{
public:
   cWifiHealthCalculator(WifiMode mode);
   ~cWifiHealthCalculator();
   virtual void run() override;
   int readFromProcFile(const char* fileName,const char* readParameter);
   void computeConnectionStatusSTA();
   void computeConnectionStatusAP();
   virtual void interrupt();
private:
   DECLARE_CLASS_LOGGER();
   int m_healthValue;
   WifiMode m_mode;
};

class cWifiConnectionStatusObserver {
public:
   cWifiConnectionStatusObserver() { }
   virtual ~cWifiConnectionStatusObserver() { }
   virtual void wifiConnectionStatusChanged(const WifiMode mode,const uint32 healthValue) = 0;
};

class cWifiConnectionStatusNotifier  {
   ::std::vector< cWifiConnectionStatusObserver* > _connStatusObservers;
public:
   cWifiConnectionStatusNotifier() { }
   virtual ~cWifiConnectionStatusNotifier() { }
   virtual int subscribeWifiConnectionStatus(cWifiConnectionStatusObserver *observer) final;
   virtual int unSubscribeWifiConnectionStatus(cWifiConnectionStatusObserver *observer) final;
   virtual void updateConnectionStatus(const WifiMode mode,const uint32 healthValue);
};

class cWifiConnectionStatus final:
         public GenericSingleton<cWifiConnectionStatus>,
         public AsyncResultCallbackIF< uint32 >,
         public cNetLink,
         public cWatchDogCallbackIf,
         public cWifiMlmeConnectionObserver,
         public cWifiConnectionStatusNotifier

{
public:
   virtual ~cWifiConnectionStatus();
   cWifiConnectionStatus(const cWifiConnectionStatus &r) = delete;
   const cWifiConnectionStatus &operator=(const cWifiConnectionStatus &r) = delete;
   virtual void MlmeConnected(const ::std::string &ifName, const ::std::string &associatedBss,
         const unsigned int &ifIndex,const ::std::string &macaddr) override;
   virtual void MlmeDisConnected(const ::std::string &ifName, const ::std::string &disconnectedBss) override;

   virtual void onAsyncResult(const ::boost::shared_ptr< AsyncResult< uint32 > >& result) override;
   virtual void watchDogExpired(void *data);

   /*Netlink Functions*/
   virtual int iStartWatch();
   int iGenlRequest(bool event_socket, enum nl80211_commands cmd, int flags, const unsigned int &ifindex,iEventhandler handler);
   int iGenlSendRecv(struct nl_sock *sk, struct nl_msg *msg, iEventhandler handler, void *data);
   struct nl_sock *createNlSocket();
   static int iGenlFinishHandler(struct nl_msg *msg, void *arg);
   static int iGenlAckHandler(struct nl_msg *msg, void *arg);
   static int iGenlSeqCheckHandler(struct nl_msg *msg, void *arg);
   static int iGenlErrorHandler(struct sockaddr_nl *nla, struct nlmsgerr *err, void *arg);
   static int iProcessGenlScanEvent(struct nl_msg *msg, void *arg);
   static int iProcessStationInfoEvent(struct nlattr **attr, void *arg);
   static int iProcessScanInfoEvent(struct nlattr **attr, void *arg);
   static const std::string sConvertGenlEventToString(enum nl80211_commands eGeNlEvt);
   int iSetUpEventHandler();

   void notifyActiveWiFiSetups(WifiSetUpList wifiSetups);

private:
   void initiateNLSockets();
   void closeNLSockets();
   cWifiConnectionStatus();
   void updateSessionHealthStatus(const uint32 healthVal);
   void notifyHealthValue(const uint32 healthValue);
   void setDefaultValues();
   void initiateConnectionStatus(const WifiMode mode);
   void closeConnectionStatus();
   DECLARE_CLASS_LOGGER();
   friend class GenericSingleton<cWifiConnectionStatus>;
   //Timer _connTimer;
   cWatchDog *m_watchDog;
   int m_iNl80211id;
   unsigned int m_ifIndex;
   ::std::string m_macaddr;
   uint32 m_healthIndicatorValue;
   ::std::vector<cWifiConnectionStatusNotifier *> _cWifiConnectionStatusobservers;
   bool m_bAPPower;
   WifiMode m_currentMode;
   uint32 m_sessionCount;
};

}
}


#endif /* _WIFICONNECTIONSTATUS_H_ */
