/**
 * @file STAModeClient_Types.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
 
#ifndef _STA_MODE_CLIENT_TYPES_H
#define _STA_MODE_CLIENT_TYPES_H

#include <string>
#include <vector>
#include "WBLTypes.h"

#include "asf/core/Types.h"

namespace org
{
namespace bosch
{

//Forward declarations
class TechnologyProperty;
class TechnologyItem;

typedef std::vector<TechnologyItem> TechnologyList;

class TechnologyProperty
{
   public:
   TechnologyProperty();
   TechnologyProperty(const TechnologyProperty &ref);
   TechnologyProperty& operator=(const TechnologyProperty &ref);
   bool operator==(const TechnologyProperty &ref);
   virtual ~TechnologyProperty();
   bool isPowered;
   WBLPowerStateType powerState;
   bool isConnected;
   ::std::string name;
   ::std::string type; //TO DO:Convert to enum
   uint32 frequency;
   uint16 currChannel;
   uint32 connHealth;
};

class TechnologyItem final
{
   public:
   TechnologyItem();
   TechnologyItem(const TechnologyItem &ref);
   TechnologyItem& operator=(const TechnologyItem &ref);
   bool operator==(const TechnologyItem &ref);
   virtual ~TechnologyItem();
   std::string objPath;
   TechnologyProperty property;
};

} //namespace bosch
} //namespace org
 
#endif //_STA_MODE_CLIENT_TYPES_H

/** @} */
