/**
 * @file STAModeClient_Msgs.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _STA_MODE_CLIENT_MSGS_H
#define _STA_MODE_CLIENT_MSGS_H

#include <string>

#include "IEEE80211EventMsg.h"
#include "STAModeClient_Types.h"

namespace org
{
namespace bosch
{

class TechnologyAddedMsg : public IEEE80211EventMsg
{
public:
   TechnologyAddedMsg() :
         IEEE80211EventMsg(IEEE80211_MSG_STA_MODE_TECHNOLOGYADDED_IND)
   {
   }
   virtual ~TechnologyAddedMsg()
   {
   }
   void setTechnologyItem(const TechnologyItem& technologyItem)
   {
      _techItem = technologyItem;
   }
   void getTechnologyItem(TechnologyItem& technologyItem)const
   {
      technologyItem = _techItem;
   }
private:
   TechnologyItem _techItem;
};

class TechnologyRemovedMsg : public IEEE80211EventMsg
{
public:
   TechnologyRemovedMsg() :
         IEEE80211EventMsg(IEEE80211_MSG_STA_MODE_TECHNOLOGYREMOVED_IND)
   {
   }
   virtual ~TechnologyRemovedMsg()
   {
   }
   ::std::string getObjPath()const
   {
      return _sobjPath;
   }
   void setobjPath(const ::std::string sObjPath)
   {
      _sobjPath = sObjPath;
   }
private:
   ::std::string _sobjPath;
};

class TechnologyChangedMsg : public IEEE80211EventMsg
{
public:
   TechnologyChangedMsg() :
         IEEE80211EventMsg(IEEE80211_MSG_STA_MODE_POWERED_IND)
   {
   }
   virtual ~TechnologyChangedMsg()
   {
   }
   void setTechnologyItem(const TechnologyItem& technologyItem)
   {
      _techItem = technologyItem;
   }
   void getTechnologyItem(TechnologyItem& technologyItem)const
   {
      technologyItem = _techItem;
   }
private:
   TechnologyItem _techItem;
};

} //namespace bosch
} //namespace org

#endif //_STA_MODE_CLIENT_MSGS_H

/** @} */
