/**
 * @file IEEE80211EventMsg.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _IEEE_80211_EVENT_MSG_H
#define _IEEE_80211_EVENT_MSG_H

#include "IEEE80211Defines.h"

namespace org
{
namespace bosch
{
	
class IEEE80211EventMsg
{
public:
   IEEE80211EventMsg(IEEE80211EventID msgID);
   IEEE80211EventMsg(const IEEE80211EventMsg& ref);
   IEEE80211EventMsg& operator=(const IEEE80211EventMsg& ref);
   virtual ~IEEE80211EventMsg();
   virtual void printIEEE80211EventMsg() const;
   virtual void setIEEE80211ErrCode(IEEE80211ErrorCode err);
   virtual IEEE80211ErrorCode getIEEE80211ErrCode() const final;
   virtual IEEE80211EventID getIEEE80211EventID() const final;
   virtual void setIEEE80211EventID(const IEEE80211EventID msgID);
private:
   IEEE80211EventID _msgID;
   IEEE80211ErrorCode _errcode;
};

} //namespace bosch
} //namespace org

#endif //_IEEE_80211_EVENT_MSG_H

/** @} */
