/**
 * @file IEEE80211Defines.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _IEEE_80211_DEFINES_H
#define _IEEE_80211_DEFINES_H

namespace org
{
namespace bosch
{

enum IEEE80211EventID
{
   /* For STA Mode - Connman signals */
   IEEE80211_MSG_STA_MODE_TECHNOLOGYADDED_IND = 0,
   IEEE80211_MSG_STA_MODE_TECHNOLOGYREMOVED_IND,
   /* For STA Mode - Connman properties */
   IEEE80211_MSG_STA_MODE_POWERED_IND,
   IEEE80211_MSG_STA_MODE_POWERSTATE_IND,
   IEEE80211_MSG_STA_MODE_CONNECTED_IND,
   IEEE80211_MSG_STA_MODE_NAME_IND,
   IEEE80211_MSG_STA_MODE_TYPE_IND,
   IEEE80211_MSG_STA_MODE_CURRCHANNEL_IND,
   IEEE80211_MSG_STA_MODE_RESTORE_START,
   IEEE80211_MSG_STA_MODE_RESTORE_COMPLETE,
   /*For AP Mode - Access Point signals */
   IEEE80211_MSG_AP_MODE_APADDED_IND,
   IEEE80211_MSG_AP_MODE_APREMOVED_IND,
   IEEE80211_MSG_AP_MODE_ASADDED_IND,
   IEEE80211_MSG_AP_MODE_ASREMOVED_IND,
   IEEE80211_MSG_AP_MODE_ASCHANGED_IND,
   /*For AP Mode - Access Point properties */
   IEEE80211_MSG_AP_MODE_AP_POWERED_IND,
   IEEE80211_MSG_AP_MODE_AP_SSID_IND,
   IEEE80211_MSG_AP_MODE_AP_PASSPHRASE_IND,
   IEEE80211_MSG_AP_MODE_AP_CURRENTCHANNEL_IND,
   IEEE80211_MSG_AP_MODE_AP_SECURITY_IND,
   IEEE80211_MSG_AP_MODE_AP_VENDOR_IES_IND,
   IEEE80211_MSG_AP_MODE_AP_MACADDRESS_IND,
   IEEE80211_MSG_AP_MODE_AP_SUPPCHANNELS_IND,
   IEEE80211_MSG_AP_MODE_AP_MAXSTA_IND,
   IEEE80211_MSG_AP_MODE_AP_HIDDEN_IND,
   IEEE80211_MSG_AP_MODE_AP_INTERFACE_IND,
   IEEE80211_MSG_AP_MODE_AP_POWERSTATE_IND,
   IEEE80211_MSG_AP_MODE_AP_POWERFAILURE_IND,
   IEEE80211_MSG_AP_MODE_AP_TYPE_IND,
   IEEE80211_MSG_AP_MODE_AP_IPV4_CONFIGURATION_IND,
   IEEE80211_MSG_AP_MODE_AP_TETHERING_IND,
   IEEE80211_MSG_AP_MODE_AP_HEALTH_IND,
   IEEE80211_MSG_AP_MODE_AP_REG_VENDOR_IND,
   IEEE80211_MSG_AP_MODE_AP_UNREG_VENDOR_IND,
   IEEE80211_MSG_AP_MODE_AP_ACCESS_NETWORK_TYPE_IND,
   /*For AP Mode - Associated Station properties */
   IEEE80211_MSG_AP_MODE_AS_MACADDRESS_IND,
   IEEE80211_MSG_AP_MODE_AS_APPATH_IND,
   IEEE80211_MSG_AP_MODE_AS_INTERFACE_IND,
   IEEE80211_MSG_AP_MODE_AS_IPADDRESS_IND,
   IEEE80211_MSG_AP_MODE_AS_HOSTNAME_IND,
   /* For AP Mode - Requests */
   IEEE80211_MSG_AP_MODE_AP_SETOPERATINGCHANNEL,
   IEEE80211_MSG_AP_MODE_AP_DEAUTHENTICATESTATION,
   IEEE80211_MSG_AP_MODE_CLEAR_DATA_RESP,
   IEEE80211_MSG_AP_MODE_RESTORE_START,
   IEEE80211_MSG_AP_MODE_RESTORE_COMPLETE,
   //----------------------------------------
   IEEE80211_MSG_UNKNOWN = 255
};


enum IEEE80211EventType
{
   IEEE80211_EVENT_STA,
   IEEE80211_EVENT_AP,
   IEEE80211_EVENT_P2P,
   IEEE80211_EVENT_UNKNOWN
};

enum IEEE80211ErrorCode
{
   IEEE80211_ERROR_NONE,
   IEEE80211_ERROR_INVALID_ARGS,
   IEEE80211_ERROR_INVALID_STA,
   IEEE80211_ERROR_INVALID_CHANNEL,
   IEEE80211_ERROR_INVALID_LENGTH,
   IEEE80211_ERROR_ALREADY_EXIST,
   IEEE80211_ERROR_UNKNOWN
};

} //namespace bosch
} //namespace org
 
#endif //_IEEE_80211_DEFINES_H

/** @} */
