/**
 * @file IEEE80211Client.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _IEEE_80211_CLIENT_H
#define _IEEE_80211_CLIENT_H

#include <string>

#include "IEEE80211EventNotifier.h"
#include "WBLTypes.h"
#include "LCMFactory.h"

namespace org
{
namespace bosch
{

//Forward declaration

class IEEE80211Client : public IEEE80211EventNotifier
{
public:

   IEEE80211Client()
   {
   }

   virtual ~IEEE80211Client()
   {
   }

   virtual bool setPowered(const ::std::string& objPath, bool powered) = 0;
   LCMWiFiState getWifiState() const
   {
      LCMWiFiState currState = LCM_WIFISTATE_UNKNOWN;
      LCMFactory* lcmFactory = LCMFactory::getInstance();
      ILCMClient* poLCMClient = (lcmFactory) ? (lcmFactory->getLCMClientIf()) : (nullptr);
      if (poLCMClient)
      {
         currState = poLCMClient->getCurrentWiFiState();
      }
      return currState;
   }

private:

   IEEE80211Client(const IEEE80211Client&);
   const IEEE80211Client& operator=(const IEEE80211Client&);

};

} // namespace bosch
} // namespace org

#endif //_IEEE_80211_CLIENT_H

/** @} */
