/**
 * @file DBManager.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 * @brief
 *
 * @{
 */

#ifndef _DB_MANAGER_H
#define _DB_MANAGER_H

#include <glib.h>

#include "asf/core/Logger.h"

#include "WBLTypes.h"
#include "IDBManager.h"
#include "WBLDefines.h"
#include "CryptoUtilFactory.h"

namespace org
{
namespace bosch
{

class DBManager: public IDBManager
{
public:
    DBManager();
    virtual ~DBManager();
    virtual bool readLIMFromDB(LIMList& list) override;
    virtual bool writeLIMToDB(const LIMItem& item) override;
    virtual void removeLIMItem(const WifiMode& mode) override;
    virtual bool readPoweredSetting(const WifiMode mode,::std::string& objPath) override;

    virtual bool readAPConfigsFromDB(APSetup &configAPSetup,bool &isRestricted) override;
    virtual bool writeAPConfigsToDB(const APSetup &configAPSetup,const bool isRestricted) override;

    //For PriorityManagement
    virtual bool readPMFromDB(PriorityList& list, uint &timer) override;
    virtual bool writeModesToDB(const PriorityList& list) override;
    virtual bool writeTimerToDB(const uint &timer) override;

    virtual ::std::string getRegulatoryInfo(const ::std::string &group) override;
    virtual int setRegulatoryInfo(const ::std::string &country,::std::string &group) override;
    virtual int getRegulatoryWatchDogInfo(const ::std::string &group,const ::std::string &key, unsigned int *watchDogVal) override;
    virtual int setRegulatoryWatchDogInfo(::std::string &group,const ::std::string &key, unsigned int watchDogVal) override;
    virtual int removeKey(::std::string &group, const ::std::string &key) override;
    virtual int getRegulatorySources(::std::string &group, const ::std::string &key, ::std::string &sources) override;

    virtual int getHWLimitationInfo(const ::std::string &group, HWLimitationInfo &info) override;

    void convertString2ByteArray(const ::std::string stringData, std::vector < uint8 >& byteArray);

    virtual ::std::string getAPTypePassphrase(const WBLAPType type) override;
    virtual bool setAPTypePassphrase(const WBLAPType type,const ::std::string &passphrase) override;
    virtual void  clearLIMData() override;
private:
    GKeyFile* loadConfFile(std::string sFilePath);
    bool readAPLIMItem(GKeyFile* keyFile,LIMItem& item)const;
    bool readSTALIMItem(GKeyFile* keyFile,LIMItem& item)const;

    bool checkFileIsEncrypted(std::string sFilePath/*, GKeyFile** skeyFile*/);
    GKeyFile* decryptAndLoadFile(std::string sFilePath);
    bool encryptAndSaveFile(std::string sFilePath);
    bool storeAndEncrypt(GKeyFile *keyFile, std::string sFilePath);
   // int createTempFile(char** pathname, const char* filename);
    int destroyTempFile(const char* pathname);
    void dbDumpFile (const char *file);
    CryptoUtil* poCryptoUtil;
    GKeyFile *LIMkeyFile;
    DECLARE_CLASS_LOGGER();

};
} //namespace bosch
} //namespace org

#endif //_DB_MANAGER_H

/** @} */
