/**
 * @file CryptoUtilFactory.h
 * @author RBEI/ECO3 Murali Kakkanavar
 * @copyright (c) 2020 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _CRYPTO_UTIL_FACTORY_H
#define _CRYPTO_UTIL_FACTORY_H

#include "WBLDefines.h"
#include "GenericSingleton.h"
#include "CryptoSDC.h"

namespace org
{
namespace bosch
{

class CryptoUtilFactory final: public GenericSingleton< CryptoUtilFactory >
{

public:
    CryptoUtilFactory(const CryptoUtilFactory& ref);
    CryptoUtilFactory& operator=(const CryptoUtilFactory& ref);

    virtual ~CryptoUtilFactory()
    {
        RELEASE_MEM(_poCryptoUtil);
    }

    CryptoUtil* getCryptoUtil()
    {
        return _poCryptoUtil;
    }

    private:
    friend class GenericSingleton< CryptoUtilFactory > ;
    CryptoUtilFactory() :
    _poCryptoUtil(nullptr)
    {
        _poCryptoUtil = new CryptoSDC;
    }

    CryptoUtil* _poCryptoUtil;

};

} // namespace bosch
} // namespace org

#endif //_CRYPTO_UTIL_FACTORY_H

/** @} */
