/**
 * @file StateMachineProperties.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include "WBLDefines.h"
#include "StateMachineProperties.h"

namespace org
{
namespace bosch
{

WifiSetupEventProperty::WifiSetupEventProperty() :
            DbusProperties(),
            _eventSTATechAdded("EVENT_STA_TECH_ADDED"),
            _eventSTATechRemoved("EVENT_STA_TECH_REMOVED"),
            _eventSTAPowered("EVENT_STA_POWERED"),
            _eventSTAConnected("EVENT_STA_CONNECTED"),
            _eventAPAdded("EVENT_AP_ADDED"),
            _eventAPRemoved("EVENT_AP_REMOVED"),
            _eventAPPowered("EVENT_AP_POWERED"),
            _eventAPSSID("EVENT_AP_SSID"),
            _eventAPPassphrase("EVENT_AP_PASSPHRASE"),
            _eventAPCurrentChannel("EVENT_AP_CURRENTCHANNEL"),
            _eventAPSecurity("EVENT_AP_SECURITY"),
            _eventAPVendorID("EVENT_AP_VENDORID"),
            _eventAPSuppChannels("EVENT_AP_SUPPCHANNELS"),
            _eventAPHidden("EVENT_AP_HIDDEN"),
            _eventAPTethering("EVENT_AP_TETHERING"),
            _eventAPNetworkType("EVENT_AP_NETWORK_TYPE"),
            _eventAPMaxSta("EVENT_AP_MAXSTA"),
            _eventAPRegVendor("EVENT_AP_REGISTER_VENDOR"),
            _eventAPUnRegVendor("EVENT_AP_UNREGISTER_VENDOR"),
            _eventAPSetOpChannel("EVENT_AP_SETOPERATINGCHANNEL"),
            _eventAPDeauthStation("EVENT_AP_DEAUTHSTATION"),
            _eventAPCleared("EVENT_AP_CLEARED"),
            _eventASAdded("EVENT_AS_ADDED"),
            _eventASRemoved("EVENT_AS_REMOVED"),
            _eventUnknown("EVENT_UNKNOWN")
{
   _string2EnumList[_eventSTATechAdded] = (int) WIFI_SETUP_EVENT_STA_TECH_ADDED;
   _string2EnumList[_eventSTATechRemoved] = (int) WIFI_SETUP_EVENT_STA_TECH_REMOVED;
   _string2EnumList[_eventSTAPowered] = (int) WIFI_SETUP_EVENT_STA_POWERED;
   _string2EnumList[_eventSTAConnected] = (int) WIFI_SETUP_EVENT_STA_CONNECTED;
   _string2EnumList[_eventAPAdded] = (int) WIFI_SETUP_EVENT_AP_ADDED;
   _string2EnumList[_eventAPRemoved] = (int) WIFI_SETUP_EVENT_AP_REMOVED;
   _string2EnumList[_eventAPPowered] = (int) WIFI_SETUP_EVENT_AP_POWERED;
   _string2EnumList[_eventAPSSID] = (int) WIFI_SETUP_EVENT_AP_SSID;
   _string2EnumList[_eventAPPassphrase] = (int) WIFI_SETUP_EVENT_AP_PASSPHRASE;
   _string2EnumList[_eventAPCurrentChannel] = (int) WIFI_SETUP_EVENT_AP_CURRENTCHANNEL;
   _string2EnumList[_eventAPSecurity] = (int) WIFI_SETUP_EVENT_AP_SECURITY;
   _string2EnumList[_eventAPVendorID] = (int) WIFI_SETUP_EVENT_AP_VENDORID;
   _string2EnumList[_eventAPSuppChannels] = (int) WIFI_SETUP_EVENT_AP_SUPPCHANNELS;
   _string2EnumList[_eventAPHidden] = (int) WIFI_SETUP_EVENT_AP_HIDDEN;
   _string2EnumList[_eventAPTethering] = (int) WIFI_SETUP_EVENT_AP_TETHERING;
   _string2EnumList[_eventAPNetworkType] = (int) WIFI_SETUP_EVENT_AP_NETWORK_TYPE;
   _string2EnumList[_eventAPRegVendor] = (int) WIFI_SETUP_EVENT_AP_REG_VENDOR;
   _string2EnumList[_eventAPUnRegVendor] = (int) WIFI_SETUP_EVENT_AP_UNREG_VENDOR;
   _string2EnumList[_eventAPMaxSta] = (int) WIFI_SETUP_EVENT_AP_MAXSTA;
   _string2EnumList[_eventAPSetOpChannel] = (int) WIFI_SETUP_EVENT_AP_SETOPERATINGCHANNEL;
   _string2EnumList[_eventAPDeauthStation] = (int) WIFI_SETUP_EVENT_AP_DEAUTHSTATION;
   _string2EnumList[_eventAPCleared] = (int)WIFI_SETUP_EVENT_AP_CLEAR_DATA;
   _string2EnumList[_eventASAdded] = (int) WIFI_SETUP_EVENT_AS_ADDED;
   _string2EnumList[_eventASRemoved] = (int) WIFI_SETUP_EVENT_AS_REMOVED;
   _string2EnumList[_eventUnknown] = (int) WIFI_SETUP_EVENT_UNKNOWN;

   _enum2StringList[(int) WIFI_SETUP_EVENT_STA_TECH_ADDED] = &_eventSTATechAdded;
   _enum2StringList[(int) WIFI_SETUP_EVENT_STA_TECH_REMOVED] = &_eventSTATechRemoved;
   _enum2StringList[(int) WIFI_SETUP_EVENT_STA_POWERED] = &_eventSTAPowered;
   _enum2StringList[(int) WIFI_SETUP_EVENT_STA_CONNECTED] = &_eventSTAConnected;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_ADDED] = &_eventAPAdded;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_REMOVED] = &_eventAPRemoved;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_POWERED] = &_eventAPPowered;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_SSID] = &_eventAPSSID;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_PASSPHRASE] = &_eventAPPassphrase;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_CURRENTCHANNEL] = &_eventAPCurrentChannel;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_SECURITY] = &_eventAPSecurity;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_VENDORID] = &_eventAPVendorID;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_SUPPCHANNELS] = &_eventAPSuppChannels;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_HIDDEN] = &_eventAPHidden;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_TETHERING] = &_eventAPTethering;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_NETWORK_TYPE] = &_eventAPNetworkType;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_MAXSTA] = &_eventAPMaxSta;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_REG_VENDOR] = &_eventAPRegVendor;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_UNREG_VENDOR] = &_eventAPUnRegVendor;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_SETOPERATINGCHANNEL] = &_eventAPSetOpChannel;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_DEAUTHSTATION] = &_eventAPDeauthStation;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AP_CLEAR_DATA] = &_eventAPCleared;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AS_ADDED] = &_eventASAdded;
   _enum2StringList[(int) WIFI_SETUP_EVENT_AS_REMOVED] = &_eventASRemoved;
   _enum2StringList[(int) WIFI_SETUP_EVENT_UNKNOWN] = &_eventUnknown;
}

WifiSetupEventProperty::~WifiSetupEventProperty()
{
}

WifiSetupEventID WifiSetupEventProperty::getEvent2Enum(const ::std::string& value) const
{
   return (WifiSetupEventID) convertString2Enum(value);
}

const ::std::string& WifiSetupEventProperty::getEvent2String(const WifiSetupEventID value) const
{
   return convertEnum2String((const int) value);
}

WifiSetupStateProperty::WifiSetupStateProperty() :
            DbusProperties(),
            _stateDisabled("ST_SETUP_DISABLED"),
            _stateIdle("ST_SETUP_IDLE"),
            _statePreparing("ST_PREPARING_SETUP"),
            _stateDeactivating("ST_DEACTIVATING_SETUP"),
            _stateDisabling("ST_DISABLING_SETUP"),
            _stateEnabling("ST_ENABLING_SETUP"),
            _stateResetting("ST_RESETTING_SETUP"),
            _stateError("ST_SETUP_ERROR")
{
   _string2EnumList[_stateDisabled] = (int) ST_SETUP_DISABLED;
   _string2EnumList[_stateIdle] = (int) ST_SETUP_IDLE;
   _string2EnumList[_statePreparing] = (int) ST_PREPARING_SETUP;
   _string2EnumList[_stateDeactivating] = (int) ST_DEACTIVATING_SETUP;
   _string2EnumList[_stateDisabling] = (int) ST_DISABLING_SETUP;
   _string2EnumList[_stateEnabling] = (int) ST_ENABLING_SETUP;
   _string2EnumList[_stateResetting] = (int) ST_RESETTING_SETUP;
   _string2EnumList[_stateError] = (int) ST_SETUP_ERROR;

   _enum2StringList[(int) ST_SETUP_DISABLED] = &_stateDisabled;
   _enum2StringList[(int) ST_SETUP_IDLE] = &_stateIdle;
   _enum2StringList[(int) ST_PREPARING_SETUP] = &_statePreparing;
   _enum2StringList[(int) ST_DEACTIVATING_SETUP] = &_stateDeactivating;
   _enum2StringList[(int) ST_DISABLING_SETUP] = &_stateDisabling;
   _enum2StringList[(int) ST_ENABLING_SETUP] = &_stateEnabling;
   _enum2StringList[(int) ST_RESETTING_SETUP] = &_stateResetting;
   _enum2StringList[(int) ST_SETUP_ERROR] = &_stateError;
}

WifiSetupStateProperty::~WifiSetupStateProperty()
{
}

WifiSetupStateType WifiSetupStateProperty::getState2Enum(const ::std::string& value) const
{
   return (WifiSetupStateType) convertString2Enum(value);
}

const ::std::string& WifiSetupStateProperty::getState2String(const WifiSetupStateType value) const
{
   return convertEnum2String((const int) value);
}

PreparingSetupSubstateProperty::PreparingSetupSubstateProperty() :
            DbusProperties(),
            _stateResolvingLimitations("PREP_SUBSTATE_RESOLVING_LIMITATIONS"),
            _stateConfiguringFrequency("PREP_SUBSTATE_CONFIGURING_FREQUENCY"),
            _stateConfiguringChannel("PREP_SUBSTATE_CONFIGURING_CHANNEL"),
            _stateConfiguringSSID("PREPREP_SUBSTAT_CONFIGURING_SSID"),
            _stateConfiguringPassphrase("PREP_SUBSTATE_CONFIGURING_PASSPHRASE"),
            _stateConfiguringSecurity("PREP_SUBSTATE_CONFIGURING_SECURITY"),
            _stateConfiguringVisibility("PREP_SUBSTATE_CONFIGURING_VISIBILITY"),
            _stateConfiguringTethering("PREP_SETUP_ST_CONFIGURING_TETHERING"),
            _stateConfiguringNetworkType("PREP_SETUP_ST_CONFIGURING_NETWORKTYPE"),
            _stateConfiguringMaxSta("PREP_SETUP_ST_CONFIGURING_MAXSTA"),
            _statePoweringON("PREP_SUBSTATE_POWERING_ON"),
            _stateIdle("PREP_SUBSTATE_IDLE")
{
   _string2EnumList[_stateResolvingLimitations] = (int) PREP_SETUP_ST_RESOLVING_LIMITATIONS;
   _string2EnumList[_stateInitiateConfigurations] = (int) PREP_SETUP_ST_INITIATE_CONFIGURATION;
   _string2EnumList[_stateConfiguringFrequency] = (int) PREP_SETUP_ST_CONFIGURING_FREQUENCY;
   _string2EnumList[_stateConfiguringChannel] = (int) PREP_SETUP_ST_CONFIGURING_CHANNEL;
   _string2EnumList[_stateConfiguringSSID] = (int) PREP_SETUP_ST_CONFIGURING_SSID;
   _string2EnumList[_stateConfiguringPassphrase] = (int) PREP_SETUP_ST_CONFIGURING_PASSPHRASE;
   _string2EnumList[_stateConfiguringSecurity] = (int) PREP_SETUP_ST_CONFIGURING_SECURITY;
   _string2EnumList[_stateConfiguringVisibility] = (int) PREP_SETUP_ST_CONFIGURING_VISIBILITY;
   _string2EnumList[_stateConfiguringTethering] = (int) PREP_SETUP_ST_CONFIGURING_TETHERING;
   _string2EnumList[_stateConfiguringNetworkType] = (int) PREP_SETUP_ST_CONFIGURING_NETWORKTYPE;
   _string2EnumList[_stateConfiguringMaxSta] = (int) PREP_SETUP_ST_CONFIGURING_MAXSTA;
   _string2EnumList[_statePoweringON] = (int) PREP_SETUP_ST_POWERING_ON;
   _string2EnumList[_stateIdle] = (int) PREP_SETUP_ST_IDLE;

   _enum2StringList[(int) PREP_SETUP_ST_RESOLVING_LIMITATIONS] = &_stateResolvingLimitations;
   _enum2StringList[(int) PREP_SETUP_ST_INITIATE_CONFIGURATION] = &_stateInitiateConfigurations;
   _enum2StringList[(int) PREP_SETUP_ST_CONFIGURING_FREQUENCY] = &_stateConfiguringFrequency;
   _enum2StringList[(int) PREP_SETUP_ST_CONFIGURING_CHANNEL] = &_stateConfiguringChannel;
   _enum2StringList[(int) PREP_SETUP_ST_CONFIGURING_SSID] = &_stateConfiguringSSID;
   _enum2StringList[(int) PREP_SETUP_ST_CONFIGURING_PASSPHRASE] = &_stateConfiguringPassphrase;
   _enum2StringList[(int) PREP_SETUP_ST_CONFIGURING_SECURITY] = &_stateConfiguringSecurity;
   _enum2StringList[(int) PREP_SETUP_ST_CONFIGURING_VISIBILITY] = &_stateConfiguringVisibility;
   _enum2StringList[(int) PREP_SETUP_ST_CONFIGURING_TETHERING] = &_stateConfiguringTethering;
   _enum2StringList[(int) PREP_SETUP_ST_CONFIGURING_NETWORKTYPE] = &_stateConfiguringNetworkType;
   _enum2StringList[(int) PREP_SETUP_ST_CONFIGURING_MAXSTA] = &_stateConfiguringMaxSta;
   _enum2StringList[(int) PREP_SETUP_ST_POWERING_ON] = &_statePoweringON;
   _enum2StringList[(int) PREP_SETUP_ST_IDLE] = &_stateIdle;
}

PreparingSetupSubstateProperty::~PreparingSetupSubstateProperty()
{
}

PreparingSetupSubstate PreparingSetupSubstateProperty::getSubstate2Enum(const ::std::string& value) const
{
   return (PreparingSetupSubstate) convertString2Enum(value);
}

const ::std::string& PreparingSetupSubstateProperty::getSubstate2String(const PreparingSetupSubstate value) const
{
   return convertEnum2String((const int) value);
}

} //namespace bosch
} //namespace org

/** @} */
