/**
 * @file WifiSetupState.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WIFI_SETUP_STATE_H
#define _WIFI_SETUP_STATE_H

#include <boost/shared_ptr.hpp>

#include "asf/core/Logger.h"

#include "StateMachineMsg.h"
#include "StateMachineTypes.h"
#include "WBLMessageTypes.h"
#include "WBLASFComponent.h"
#include "IWifiSetupSM.h"
#include "LCMFactory.h"

namespace org
{
namespace bosch
{

//! Defines
#define IS_CURRENT_MODE(WIFI_MODE) (_wifiMode == WIFI_MODE)
#define IS_STA_MODE() (WIFI_MODE_STA == _wifiMode)
#define IS_AP_MODE() ((WIFI_MODE_AP1 == _wifiMode) || (WIFI_MODE_AP2 == _wifiMode))

// forward declarations

class WifiSetupState
{
public:

   explicit WifiSetupState(WifiSetupStateType stateType, IWifiSetupSM* wifiSetupSMIf);
   virtual ~WifiSetupState();

   WifiSetupStateType getStateType() const;

   IEEE80211STAClientIf* getSTAClientIf()const;
   IEEE80211APClientIf* getAPClientIf() const;

   virtual void onEntry(::boost::shared_ptr< StateMachineMsg > msg);
   virtual void onRequest(::boost::shared_ptr< PrepareSetupMsg > msg);
   virtual void onRequest(::boost::shared_ptr< DeActivateSetupMsg > msg);
   virtual void onRequest(::boost::shared_ptr< DisableSetupMsg > msg);
   virtual void onRequest(::boost::shared_ptr< RestoreFactorySettingsMsg > msg);
   virtual void onEvent(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);

protected:

   virtual void switchToErrorState() final;

   IWifiSetupSM* const _wifiSetupSMIf;
   WifiMode _wifiMode;

private:

   WifiSetupState();
   WifiSetupState(const WifiSetupState&);
   WifiSetupState& operator=(const WifiSetupState&);

   const WifiSetupStateType _stateType;

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_WIFI_SETUP_STATE_H

/** @} */
