/**
 * @file SetupDisabledState.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _SETUP_DISABLED_STATE_H
#define _SETUP_DISABLED_STATE_H

#include <boost/shared_ptr.hpp>

#include "asf/core/Logger.h"

#include "WBLMessageTypes.h"
#include "WifiSetupState.h"

namespace org
{
namespace bosch
{

// forward declarations

class SetupDisabledState final: public WifiSetupState
{
public:

   explicit SetupDisabledState(IWifiSetupSM* wifiSetupSMIf);
   virtual ~SetupDisabledState();

   //! Override WifiSetupState interfaces
   virtual void onEntry(::boost::shared_ptr< StateMachineMsg > msg) override;
   virtual void onRequest(::boost::shared_ptr< PrepareSetupMsg > msg) override;
   virtual void onRequest(::boost::shared_ptr< DeActivateSetupMsg > msg) override;
   virtual void onRequest(::boost::shared_ptr< DisableSetupMsg > msg) override;
   virtual void onEvent(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError) override;

private:

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_SETUP_DISABLED_STATE_H

/** @} */
