/**
 * @file ResettingSetupState.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _RESETTING_SETUP_STATE_H
#define _RESETTING_SETUP_STATE_H

#include <boost/shared_ptr.hpp>

#include "asf/core/Logger.h"

#include "WBLMessageTypes.h"
#include "WifiSetupState.h"

namespace org
{
namespace bosch
{

class ResettingSetupState final: public WifiSetupState
{
public:

   explicit ResettingSetupState(IWifiSetupSM* wifiSetupSMIf);
   virtual ~ResettingSetupState();

   //! Override WifiSetupState interfaces
   virtual void onEntry(::boost::shared_ptr< StateMachineMsg > msg) override;
   virtual void onEvent(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError) override;

private:

   void setSubState(const ResetSetupSubstate subState);
   ResetSetupSubstate getSubState()const;
   void sendRestoreFactorySettingsResult(const SMErrorCode errCode);

   void onEntryPoweringOff();
   void onEntryClearData();
   void onEntryIdle();

   void handlePoweringOffState(const WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);
   void handleClearDataState(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError);

   bool clearConnmanContent();
   bool clearDbFiles();

   ResetSetupSubstate _subState;
   WifiSetUpItem _activeWifiSetup;

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_RESETTING_SETUP_STATE_H

/** @} */
