/**
 * @file DisablingSetupState.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _DISABLING_SETUP_STATE_H
#define _DISABLING_SETUP_STATE_H

#include <boost/shared_ptr.hpp>

#include "asf/core/Logger.h"

#include "WBLMessageTypes.h"
#include "WifiSetupState.h"

namespace org
{
namespace bosch
{

// forward declarations

class DisablingSetupState final : public WifiSetupState
{
public:

   explicit DisablingSetupState(IWifiSetupSM* wifiSetupSMIf);
   virtual ~DisablingSetupState();

   //! Override WifiSetupState interfaces
   virtual void onEntry(::boost::shared_ptr< StateMachineMsg > msg) override;
   virtual void onRequest(::boost::shared_ptr< DisableSetupMsg > msg) override;
   virtual void onEvent(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError) override;

private:

   bool sendDisableRequest();
   void onDisableSetupSuccess();
   bool isSTAPoweredON();

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_DISABLING_SETUP_STATE_H

/** @} */
