/**
 * @file WifiSetupControllerSM.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WIFI_SETUP_CONTROLLER_SM_H
#define _WIFI_SETUP_CONTROLLER_SM_H

#include <boost/shared_ptr.hpp>

#include "asf/core/Logger.h"

#include "ICmdWifiSetupControllerSM.h"
#include "IWifiSetupSM.h"
#include "WBLMessageTypes.h"
#include "StateMachineTypes.h"
#include "StateMachineMsg.h"
#include "WifiSetupState.h"

namespace org
{
namespace bosch
{

// forward declarations
class IRespWifiSetupControllerSM;

class WifiSetupControllerSM final: public ICmdWifiSetupControllerSM, public IWifiSetupSM
{
public:

   explicit WifiSetupControllerSM(WifiMode wifiMode, IRespWifiSetupControllerSM* respWifiSetupSM);
   virtual ~WifiSetupControllerSM();

   //! Override ICmdWifiSetupControllerSM interfaces
   virtual void onRequest(::boost::shared_ptr< PrepareSetupMsg > msg) override;
   virtual void onRequest(::boost::shared_ptr< DeActivateSetupMsg > msg) override;
   virtual void onRequest(::boost::shared_ptr< DisableSetupMsg > msg) override;
   virtual void onRequest(::boost::shared_ptr< RestoreFactorySettingsMsg > msg) override;
   virtual void onEvent(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError) override;
   virtual bool isSMBusy() const override;

   //! Override IWifiSetupSM interfaces
   virtual WifiMode getWifiMode() const override;
   virtual WifiSetupStateType getStateType() const override;
   virtual void setState(WifiSetupStateType state, ::boost::shared_ptr< StateMachineMsg > msg) override;
   virtual const WifiSetUpItem& getWifiSetupInfo() const override;
   virtual const WifiSetUpList& getAllWifiSetups() const override;

   virtual ::boost::shared_ptr< PrepareSetupMsg > getPrepareSetupMsg() override;
   virtual ::boost::shared_ptr< DeActivateSetupMsg > getDeactivateSetupMsg() override;
   virtual ::boost::shared_ptr< DisableSetupMsg > getDisableSetupMsg() override;
   virtual ::boost::shared_ptr< RestoreFactorySettingsMsg > getRestoreFactorySettingsMsg() override;

   virtual void setPrepareSetupMsg(::boost::shared_ptr< PrepareSetupMsg > msg) override;
   virtual void setDeactivateSetupMsg(::boost::shared_ptr< DeActivateSetupMsg > msg) override;
   virtual void setDisableSetupMsg(::boost::shared_ptr< DisableSetupMsg > msg) override;
   virtual void setRestoreFactorySettingsMsg(::boost::shared_ptr< RestoreFactorySettingsMsg > msg) override;

   virtual void sendMsgResponse(::boost::shared_ptr< WBLBaseMsg > msg, WBLErrorCode errorCode) override;
   virtual void sendRequest(::boost::shared_ptr< WBLBaseMsg > msg) override;

private:

   const enum WifiMode _wifiMode;

   IRespWifiSetupControllerSM* const _respWifiSetupSM;

   WifiSetUpItem _wifiSetupItem;

   ::boost::shared_ptr< PrepareSetupMsg > _prepareSetupMsg;
   ::boost::shared_ptr< DeActivateSetupMsg > _deactSetupMsg;
   ::boost::shared_ptr< DisableSetupMsg > _disableSetupMsg;
   ::boost::shared_ptr< RestoreFactorySettingsMsg > _resetSetupMsg;

   ::boost::shared_ptr< WifiSetupState > _setupDisabledState;
   ::boost::shared_ptr< WifiSetupState > _idleState;
   ::boost::shared_ptr< WifiSetupState > _preparingSetupState;
   ::boost::shared_ptr< WifiSetupState > _deactivatingSetupState;
   ::boost::shared_ptr< WifiSetupState > _disablingSetupState;
   ::boost::shared_ptr< WifiSetupState > _enablingSetupState;
   ::boost::shared_ptr< WifiSetupState > _errorState;
   ::boost::shared_ptr< WifiSetupState > _resetSetupState;

   ::boost::shared_ptr< WifiSetupState > _currentState;

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_WIFI_SETUP_CONTROLLER_SM_H

/** @} */
