/**
 * @file StateMachineMsg.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _STATE_MACHINE_MSG_H
#define _STATE_MACHINE_MSG_H

#include "WBLTypes.h"

namespace org
{
namespace bosch
{

enum SMEventID
{
   SM_EVENT_PREPARE_SETUP_ERROR = 0,
   SM_EVENT_DEACTIVATE_SETUP_ERROR,
   SM_EVENT_DISABLE_SETUP_ERROR,
   SM_EVENT_RESET_SETUP_ERROR,
   SM_EVENT_UNKNOWN = 255
};

enum SMErrorCode
{
   SM_ERR_NOERROR = 0,
   SM_ERR_PERM_DENIED,
   SM_ERR_NOTSUPPORTED,
   SM_ERR_REJECTED,
   SM_ERR_INPROGRESS,
   SM_ERR_CANCELLED,
   SM_ERR_FAILED,
   SM_ERR_INVALID_ARGS,
   SM_ERR_BUSY,
   SM_ERR_ALREADY_EXIST,
   SM_ERR_UNKNOWN = 255
};


class StateMachineMsg final
{
public:
   StateMachineMsg() :
      _eventID(SM_EVENT_UNKNOWN), _errorCode(SM_ERR_UNKNOWN)
   {
   }
   virtual ~StateMachineMsg()
   {
   }
   void setEventID(SMEventID eventID)
   {
      _eventID = eventID;
   }
   SMEventID getEventID() const
   {
      return _eventID;
   }
   void setErrorCode(SMErrorCode errorCode)
   {
      _errorCode = errorCode;
   }
   SMErrorCode getErrorCode() const
   {
      return _errorCode;
   }
private:
   SMEventID _eventID;
   SMErrorCode _errorCode;
};

} // namespace bosch
} // namespace org

#endif //_STATE_MACHINE_MSG_H

/** @} */
