/**
 * @file IEEE80211ConflictManager.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _IEEE_80211_CONFLICT_MGR_H
#define _IEEE_80211_CONFLICT_MGR_H 

#include <string>

#include "asf/core/Logger.h" 

#include "ICmdConflictManager.h"
#include "IRespStateMachineManager.h"
#include "IEEE80211EventObserver.h"
#include "APModeClient_Msgs.h"
#include "STAModeClient_Msgs.h"
#include "WBLTypes.h"
#include "WBLMessageTypes.h"

namespace org
{
namespace bosch
{

using namespace ::asf::core;

class IEEE80211ConflictManager final :
      public ICmdConflictManager,
      public IRespStateMachineManager,
      public IEEE80211EventObserver
{
public:

   IEEE80211ConflictManager();
   virtual ~IEEE80211ConflictManager();

   virtual void onProcessRequest(const ::boost::shared_ptr< WBLBaseMsg > msg) override;
   virtual void sendMsgResponse(const ::boost::shared_ptr< WBLBaseMsg >msg) override;
   virtual void processIEEE80211Event(IEEE80211EventType type,
         const IEEE80211EventMsg* eventMsg) override;
   bool getWiFiSetUps(WifiSetUpList& wifiSetupList)const override;

private:

   void notifyActiveWifiSetups();

   void processAPModeEvent(const IEEE80211EventMsg* eventMsg);
   void processSTAModeEvent(const IEEE80211EventMsg* eventMsg);

   void addWifiSetup(const AccessPointItem& apItem);
   void onAPUpdate(const AccessPointItem& apItem, const IEEE80211EventID eventID);
   void sendAPUpdate2SM(const WifiSetUpItem &apItem,
         const IEEE80211EventID eventID, const IEEE80211ErrorCode errCode);

   void addAssociatedStation(const AssociatedStationItem& asItem);
      void onASUpdate(const AssociatedStationItem& asItem, const IEEE80211EventID eventID);
   void removeAssociatedStation(const ::std::string& objPath);
   void addStationtoSetups(const AssociatedStationItem& asItem);
   void removeStationFromSetUps(const AssociatedStationItem& asItem);

   void addWifiSetup(const TechnologyItem& staItem);
   void onSTAUpdate(const TechnologyItem& staItem, const IEEE80211EventID eventID);
   void sendSTAUpdate2SM(const WifiSetUpItem& staItem,
         const IEEE80211EventID eventID, const IEEE80211ErrorCode errCode);

   void removeWifiSetup(const ::std::string& objPath);

   bool isWifiSetupAvailable(const ::std::string& objPath);
   bool getWifiSetupItem(const ::std::string& objPath,
         WifiSetUpItem& item);
   bool isAssociatedStationAvailable(const ::std::string& objPath);
   bool getAssociatedStationItem(const ::std::string& objPath,
         AssociatedStationItem &item);

   void printWifiSetup(const WifiSetUpItem& setup) const;
   void printAssociatedStation(const AssociatedStationItem& asItem) const;
   std::string createWifiSetupObjectPath(::std::string& interface) const;

   bool isSMBusy(const WifiMode& mode);
   bool isCPChannel(const uint16& channel, const WBLFrequencyBand& frequency);
   void sendConflictResolverMsg(const ::boost::shared_ptr< WBLBaseMsg > msg);

   void sendDeAuthStationMsg(const ::boost::shared_ptr< WBLBaseMsg > msg);
   void sendDeAuthStationResponse(const ::boost::shared_ptr< WBLBaseMsg > msg);

   LCMWiFiState getWifiState();
   bool checkLCMWifiStateAvailability(const ::boost::shared_ptr < WBLBaseMsg > msg);

   void supportedFrequencies(APSetup &apSetup);
   bool checkSupportedFrequency(APSetup &apSetup,WBLFrequencyBand frequencyBand);
   void updateLastRequestedAPType(const AccessPointItem& apItem);

   void updateRequestType(const ::boost::shared_ptr < WBLBaseMsg > msg);

 
   //TO DO : Check if this can be removed ?
   enum NumAccessPoints
   {
      MAX_ACCESS_POINTS = 1
   };

   //! Map with Key = [AP or STA mode native object path], Value = [WifiSetUpItem]
   std::map< ::std::string, WifiSetUpItem > _wifiSetups;
   //! Map with Key = [Associated Station object path], Value = [AssociatedStationItem]
   std::map< ::std::string , AssociatedStationItem > _associatedStations;

   bool _restoringLastMode;

   DECLARE_CLASS_LOGGER();

};

}// namespace bosch
}// namespace org

#endif //_IEEE_80211_CONFLICT_MGR_H

/** @} */
