/**
 * @file SMManagerFactory.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Factory class for ConflictManager
 *
 * @{
 */

#ifndef _SM_MANAGER_FACTORY_H
#define _SM_MANAGER_FACTORY_H

#include "GenericSingleton.h"
#include "StateMachineManager.h"
///#include "WifiSetupControllerSM.h"

namespace org
{
namespace bosch
{

typedef ::boost::shared_ptr < ICmdStateMachineManager >  tICmdStateMachineManagerSptr;
/*typedef ::boost::shared_ptr < ICmdWifiSetupControllerSM >  tICmdWifiSetupControllerSMSptr;
typedef ::boost::shared_ptr < IWifiSetupSM >  tIWifiSetupSMSptr;

typedef ::boost::shared_ptr < WifiSetupControllerSM >  tWifiSetupControllerSMSptr;
typedef std::map< WifiMode, tICmdWifiSetupControllerSMSptr > tStateMachinesMap;*/

class SMManagerFactory final: public GenericSingleton<SMManagerFactory>
{
public:

   SMManagerFactory();

   ~SMManagerFactory();

   //tStateMachinesMap createStateMachines();
   //void destroyStateMachines();

   tICmdStateMachineManagerSptr getStateMachineManagerIf();

   //tICmdWifiSetupControllerSMSptr getStateMachineIf(WifiMode wifiMode);
   //tIWifiSetupSMSptr getStateMachineIf(WifiMode wifiMode);

private:

   friend class GenericSingleton< SMManagerFactory >;

   ::boost::shared_ptr< StateMachineManager > _SMManager;

   //std::map< WifiMode, tWifiSetupControllerSMSptr > _stateMachinesMap;

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_SM_MANAGER_FACTORY_H

/** @} */
