/**
 * @file ConflictManagerFactory.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Factory class for ConflictManager
 *
 * @{
 */

#ifndef _CONFLICT_MANAGER_FACTORY_H
#define _CONFLICT_MANAGER_FACTORY_H

#include "GenericSingleton.h"
#include "IEEE80211ConflictManager.h"
#include "ConflictResolver.h"

namespace org
{
namespace bosch
{

class ConflictManagerFactory final: public GenericSingleton<ConflictManagerFactory>
{

public:
   ~ConflictManagerFactory();
   ConflictManagerFactory(const ConflictManagerFactory& ref);
   ConflictManagerFactory& operator=(const ConflictManagerFactory& ref);

   ICmdConflictManager* getConflictManagerRequestIf();
   ICmdConflictResolver* getConflictResolverIf();

private:
   ConflictManagerFactory();
   friend class GenericSingleton<ConflictManagerFactory>;

   IEEE80211ConflictManager* _poConflictMgr;
   ConflictResolver* _poConflictResolver;

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_CONFLICT_MANAGER_FACTORY_H

/** @} */
