/**
 * @file WBLTypeProperties.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include "WBLDefines.h"
#include "WBLTypeProperties.h"

namespace org
{
namespace bosch
{

WBLWifiModeProperty::WBLWifiModeProperty() :
            DbusProperties(),
            _modeAP("AP"),
            _modeSTA("STA"),
            _modeP2P("P2P"),
            _modeUnknown("UNKNOWN")
{
   _string2EnumList[_modeAP] = (int) WIFI_MODE_AP1;
   _string2EnumList[_modeSTA] = (int) WIFI_MODE_STA;
   _string2EnumList[_modeP2P] = (int) WIFI_MODE_P2P;
   _string2EnumList[_modeUnknown] = (int) WIFI_MODE_UNKNOWN;

   _enum2StringList[(int) WIFI_MODE_AP1] = &_modeAP;
   _enum2StringList[(int) WIFI_MODE_STA] = &_modeSTA;
   _enum2StringList[(int) WIFI_MODE_P2P] = &_modeP2P;
   _enum2StringList[(int) WIFI_MODE_UNKNOWN] = &_modeUnknown;
}

WBLWifiModeProperty::~WBLWifiModeProperty()
{
}

WifiMode WBLWifiModeProperty::getWifiMode2Enum(const ::std::string& value) const
{
   return (WifiMode) convertString2Enum(value);
}

const ::std::string& WBLWifiModeProperty::getWifiMode2String(const WifiMode value) const
{
   return convertEnum2String((const int) value);
}

WBLFrequencyProperty::WBLFrequencyProperty() :
            DbusProperties(),
            _frequency_2_4("2.4 GHz"),
            _frequency_5("5 GHz")
{
   _string2EnumList[_frequency_2_4] = (int) WBL_FREQ_BAND_2_4_GHZ;
   _string2EnumList[_frequency_5] = (int) WBL_FREQ_BAND_5_GHZ;

   _enum2StringList[(int) WBL_FREQ_BAND_2_4_GHZ] = &_frequency_2_4;
   _enum2StringList[(int) WBL_FREQ_BAND_5_GHZ] = &_frequency_5;
}

WBLFrequencyProperty::~WBLFrequencyProperty()
{
}

WBLFrequencyBand WBLFrequencyProperty::getFrequency2Enum(const ::std::string& value) const
{
   return (WBLFrequencyBand) convertString2Enum(value);
}

const ::std::string& WBLFrequencyProperty::getFrequency2String(const WBLFrequencyBand value) const
{
   return convertEnum2String((const int) value);
}

WBLSecurityProperty::WBLSecurityProperty() :
            DbusProperties(),
            _securityOpen("open"),
            _securityWEP("wep"),
            _securityWPA_PSK("wpa-psk"),
            _securityWPA2_PSK("wpa2-psk")
{
   _string2EnumList[_securityOpen] = (int) WBL_SECURITY_OPEN;
   _string2EnumList[_securityWEP] = (int) WBL_SECURITY_WEP;
   _string2EnumList[_securityWPA_PSK] = (int) WBL_SECURITY_WPA_PSK;
   _string2EnumList[_securityWPA2_PSK] = (int) WBL_SECURITY_WPA2_PSK;

   _enum2StringList[(int) WBL_SECURITY_OPEN] = &_securityOpen;
   _enum2StringList[(int) WBL_SECURITY_WEP] = &_securityWEP;
   _enum2StringList[(int) WBL_SECURITY_WPA_PSK] = &_securityWPA_PSK;
   _enum2StringList[(int) WBL_SECURITY_WPA2_PSK] = &_securityWPA2_PSK;

}

WBLSecurityProperty::~WBLSecurityProperty()
{
}

WBLSecurityType WBLSecurityProperty::getSecurity2Enum(const ::std::string& value) const
{
   return (WBLSecurityType) convertString2Enum(value);
}

const ::std::string& WBLSecurityProperty::getSecurity2String(const WBLSecurityType value) const
{
   return convertEnum2String((const int) value);
}

WBLAPTypeProperty::WBLAPTypeProperty() :
            DbusProperties(),
            _apTypeNormal("Normal"),
            _apTypeCarplay("CarPlayWireless"),
            _apTypeAAW("AndroidAutoWireless"),
            _apTypeRestricted("Restricted"),
            _apTypeUnknown("Unknown")
{
   _string2EnumList[_apTypeNormal] = (int) WBL_AP_TYPE_NORMAL;
   _string2EnumList[_apTypeCarplay] = (int) WBL_AP_TYPE_CARPLAY;
   _string2EnumList[_apTypeAAW] = (int) WBL_AP_TYPE_AAW;
   _string2EnumList[_apTypeRestricted] = (int) WBL_AP_TYPE_RESTRICTED;
   _string2EnumList[_apTypeUnknown] = (int) WBL_AP_TYPE_UNKNOWN;

   _enum2StringList[(int) WBL_AP_TYPE_NORMAL] = &_apTypeNormal;
   _enum2StringList[(int) WBL_AP_TYPE_CARPLAY] = &_apTypeCarplay;
   _enum2StringList[(int) WBL_AP_TYPE_AAW] = &_apTypeAAW;
   _enum2StringList[(int) WBL_AP_TYPE_RESTRICTED] = &_apTypeRestricted;
   _enum2StringList[(int) WBL_AP_TYPE_UNKNOWN] = &_apTypeUnknown;
}

WBLAPTypeProperty::~WBLAPTypeProperty()
{
}

WBLAPType WBLAPTypeProperty::getAPType2Enum(const ::std::string& value) const
{
   return (WBLAPType) convertString2Enum(value);
}

const ::std::string& WBLAPTypeProperty::getAPType2String(const WBLAPType value) const
{
   return convertEnum2String((const int) value);
}

WBLPowerStateProperty::WBLPowerStateProperty() :
            DbusProperties(),
            _statePoweringOn("WIFI_STATE_POWERING_ON"),
            _statePoweredOn("WIFI_STATE_POWERED_ON"),
            _statePoweringOff("WIFI_STATE_POWERING_OFF"),
            _statePoweredOff("WIFI_STATE_POWERED_OFF"),
            _statePowerFailure("WIFI_STATE_POWER_FAILURE"),
            _stateDeviceUnavailable("WIFI_STATE_DEVICE_UNAVAILABLE"),
            _stateDeviceavailable("WIFI_STATE_DEVICE_AVAILABLE")
{
   _string2EnumList[_statePoweringOn] = (int) WIFI_STATE_POWERING_ON;
   _string2EnumList[_statePoweredOn] = (int) WIFI_STATE_POWERED_ON;
   _string2EnumList[_statePoweringOff] = (int) WIFI_STATE_POWERING_OFF;
   _string2EnumList[_statePoweredOff] = (int) WIFI_STATE_POWERED_OFF;
   _string2EnumList[_statePowerFailure] = (int) WIFI_STATE_POWER_FAILURE;
   _string2EnumList[_stateDeviceUnavailable] = (int) WIFI_STATE_DEVICE_UNAVAILABLE;
   _string2EnumList[_stateDeviceavailable] = (int) WIFI_STATE_DEVICE_AVAILABLE;

   _enum2StringList[(int) WIFI_STATE_POWERING_ON] = &_statePoweringOn;
   _enum2StringList[(int) WIFI_STATE_POWERED_ON] = &_statePoweredOn;
   _enum2StringList[(int) WIFI_STATE_POWERING_OFF] = &_statePoweringOff;
   _enum2StringList[(int) WIFI_STATE_POWERED_OFF] = &_statePoweredOff;
   _enum2StringList[(int) WIFI_STATE_POWER_FAILURE] = &_statePowerFailure;
   _enum2StringList[(int) WIFI_STATE_DEVICE_UNAVAILABLE] = &_stateDeviceUnavailable;
   _enum2StringList[(int) WIFI_STATE_DEVICE_AVAILABLE] = &_stateDeviceavailable;
}

WBLPowerStateProperty::~WBLPowerStateProperty()
{
}

WBLPowerStateType WBLPowerStateProperty::getPowerState2Enum(const ::std::string& value) const
{
   return (WBLPowerStateType) convertString2Enum(value);
}

const ::std::string& WBLPowerStateProperty::getPowerState2String(const WBLPowerStateType value) const
{
   return convertEnum2String((const int) value);
}


WBLPowerFailureProperty::WBLPowerFailureProperty() :
            DbusProperties(),
            _typeUnavailable("WIFI_POWER_FAILURE_REASON_DEVICE_UNAVAILABLE"),
            _typeNotReady("WIFI_POWER_FAILURE_REASON_DEVICE_NOT_READY"),
            _typeDeviceFailure("WIFI_POWER_FAILURE_REASON_DEVICE_FAILURE"),
            _typeConfiguration("WIFI_POWER_FAILURE_REASON_CONFIGURATION"),
            _typeInternalFailure("WIFI_POWER_FAILURE_REASON_DEVICE_FAILURE"),
			_typeUnknown("WIFI_POWER_FAILURE_REASON_UNKNOWN")
{

   _string2EnumList[_typeUnavailable] = (int) WIFI_POWER_FAILURE_DEVICE_UNAVAILABLE;
   _string2EnumList[_typeNotReady] = (int) WIFI_POWER_FAILURE_DEVICE_NOT_READY;
   _string2EnumList[_typeDeviceFailure] = (int) WIFI_POWER_FAILURE_DEVICE_FAILURE;
   _string2EnumList[_typeConfiguration] = (int) WIFI_POWER_FAILURE_CONFIGURATION;
   _string2EnumList[_typeInternalFailure] = (int) WIFI_POWER_FAILURE_INTERNAL_FAILURE;
   _string2EnumList[_typeUnknown] = (int) WIFI_POWER_FAILURE_REASON_UNKNOWN;

   _enum2StringList[(int) WIFI_POWER_FAILURE_DEVICE_UNAVAILABLE] = &_typeUnavailable;
   _enum2StringList[(int) WIFI_POWER_FAILURE_DEVICE_NOT_READY] = &_typeNotReady;
   _enum2StringList[(int) WIFI_POWER_FAILURE_DEVICE_FAILURE] = &_typeDeviceFailure;
   _enum2StringList[(int) WIFI_POWER_FAILURE_CONFIGURATION] = &_typeConfiguration;
   _enum2StringList[(int) WIFI_POWER_FAILURE_INTERNAL_FAILURE] = &_typeInternalFailure;
   _enum2StringList[(int) WIFI_POWER_FAILURE_REASON_UNKNOWN] = &_typeUnknown;
}

WBLPowerFailureProperty::~WBLPowerFailureProperty()
{
}

WBLPowerFailureType WBLPowerFailureProperty::getPowerFailure2Enum(const ::std::string& value) const
{
   return (WBLPowerFailureType) convertString2Enum(value);
}

const ::std::string& WBLPowerFailureProperty::getPowerFailure2String(const WBLPowerFailureType value) const
{
   return convertEnum2String((const int) value);
}

WBLErrorCodeProperty::WBLErrorCodeProperty() :
            DbusProperties(),
            _errNoError("org.bosch.wbl.Error.noError"),
            _errInvalidArgs("org.bosch.wbl.Error.InvalidArguments"),
            _errPermissionDenied("org.bosch.wbl.Error.PermissionDenied"),
            _errNotSupported("org.bosch.wbl.Error.NotSupported"),
            _errRejected("org.bosch.wbl.Error.Rejected"),
            _errInProgress("org.bosch.wbl.Error.InProgress"),
            _errCancelled("org.bosch.wbl.Error.Cancelled"),
            _errAlreadyExist("org.bosch.wbl.Error.AlreadyExist"),
			_errWiFiStateBlocked("org.bosch.wbl.Error.WifiStateBlocked"),
			_errUnknown("org.bosch.wbl.Error.Unknown")

{
   _string2EnumList[_errNoError] = (int) WBL_ERR_NOERROR;
   _string2EnumList[_errInvalidArgs] = (int) WBL_ERR_INVALID_ARGS;
   _string2EnumList[_errPermissionDenied] = (int) WBL_ERR_PERM_DENIED;
   _string2EnumList[_errNotSupported] = (int) WBL_ERR_NOTSUPPORTED;
   _string2EnumList[_errRejected] = (int) WBL_ERR_REJECTED;
   _string2EnumList[_errInProgress] = (int) WBL_ERR_INPROGRESS;
   _string2EnumList[_errCancelled] = (int) WBL_ERR_CANCELLED;
   _string2EnumList[_errAlreadyExist] = (int) WBL_ERR_ALREADY_EXIST;
   _string2EnumList[_errWiFiStateBlocked] = (int) WBL_ERR_WIFISTATE_BLOCKED;
   _string2EnumList[_errUnknown] = (int) WBL_ERR_UNKNOWN;
   
   _enum2StringList[(int) WBL_ERR_NOERROR] = &_errNoError;
   _enum2StringList[(int) WBL_ERR_INVALID_ARGS] = &_errInvalidArgs;
   _enum2StringList[(int) WBL_ERR_PERM_DENIED] = &_errPermissionDenied;
   _enum2StringList[(int) WBL_ERR_NOTSUPPORTED] = &_errNotSupported;
   _enum2StringList[(int) WBL_ERR_REJECTED] = &_errRejected;
   _enum2StringList[(int) WBL_ERR_INPROGRESS] = &_errInProgress;
   _enum2StringList[(int) WBL_ERR_CANCELLED] = &_errCancelled;
   _enum2StringList[(int) WBL_ERR_ALREADY_EXIST] = &_errAlreadyExist;
   _enum2StringList[(int) WBL_ERR_WIFISTATE_BLOCKED] = &_errWiFiStateBlocked;
   _enum2StringList[(int) WBL_ERR_UNKNOWN] = &_errUnknown;

}

WBLErrorCodeProperty::~WBLErrorCodeProperty()
{
}

WBLErrorCode WBLErrorCodeProperty::getErrorCode2Enum(const ::std::string& value) const
{
   return (WBLErrorCode) convertString2Enum(value);
}

const ::std::string& WBLErrorCodeProperty::getErrorCode2String(const WBLErrorCode value) const
{
   return convertEnum2String((const int) value);
}

WBLConflictTypeProperty::WBLConflictTypeProperty() :
            DbusProperties(),
            _conflictReqStaUnavailable("MAX_STA_CONN"),
            _conflictAPConfMismatch("AP_CONFIG_MISMATCH"),
            _conflictWifiPowerOff("WIFI_OFF"),
            _conflictSimOpNotAllowed("SIMULTANEOUS_OP_NOT_ALLOWED")
{
   _string2EnumList[_conflictReqStaUnavailable] = (int) WBL_CONFLICT_REQ_STA_UNAVAILABLE;
   _string2EnumList[_conflictAPConfMismatch] = (int) WBL_CONFLICT_AP_CONFIG_MISMATCH;
   _string2EnumList[_conflictWifiPowerOff] = (int) WBL_CONFLICT_WIFI_POWER_OFF;
   _string2EnumList[_conflictSimOpNotAllowed] = (int) WBL_CONFLICT_SIMULTANEOUS_OP_NOTALLOWED;

   _enum2StringList[(int) WBL_CONFLICT_REQ_STA_UNAVAILABLE] = &_conflictReqStaUnavailable;
   _enum2StringList[(int) WBL_CONFLICT_AP_CONFIG_MISMATCH] = &_conflictAPConfMismatch;
   _enum2StringList[(int) WBL_CONFLICT_WIFI_POWER_OFF] = &_conflictWifiPowerOff;
   _enum2StringList[(int) WBL_CONFLICT_SIMULTANEOUS_OP_NOTALLOWED] = &_conflictSimOpNotAllowed;

   conflictIssueDesList.insert(std::pair<int,std::string>(WBL_CONFLICT_REQ_STA_UNAVAILABLE,"Station Slot full"));
   conflictIssueDesList.insert(std::pair<int,std::string>(WBL_CONFLICT_AP_CONFIG_MISMATCH,"Requested AP configuration will disable the already operating AP and the connected stations will be disconnected"));
   conflictIssueDesList.insert(std::pair<int,std::string>(WBL_CONFLICT_WIFI_POWER_OFF,"Wifi is OFF"));
   conflictIssueDesList.insert(std::pair<int,std::string>(WBL_CONFLICT_SIMULTANEOUS_OP_NOTALLOWED,"Not allowed to have two WLAN functions in parallel"));
   conflictIssueDesList.insert(std::pair<int,std::string>(WBL_CONFLICT_UNKNOWN,"Unknown Conflict"));
}

WBLConflictTypeProperty::~WBLConflictTypeProperty()
{
}

WBLConflictType WBLConflictTypeProperty::getConflictType2Enum(const ::std::string& value) const
{
   return (WBLConflictType) convertString2Enum(value);
}

const ::std::string& WBLConflictTypeProperty::getConflictType2String(const WBLConflictType value) const
{
   return convertEnum2String((const int) value);
}

WBLResolutionTypeProperty::WBLResolutionTypeProperty() :
            DbusProperties(),
            _resSetupPrepared("PREPARED"),
            _resSetupUserRejected("REJECTED_BY_USER"),
            _resSetupPrio("REJECTED_DUE_TO_LESS_PRIO"),
            _resSlotsFreed("STATION_SLOT_FREED")
{
   _string2EnumList[_resSetupPrepared] = (int) WBL_RES_SETUP_PREPARED;
   _string2EnumList[_resSetupUserRejected] = (int) WBL_RES_SETUP_REJECTED_USER;
   _string2EnumList[_resSetupPrio] = (int) WBL_RES_SETUP_REJECTED_PRIO;
   _string2EnumList[_resSlotsFreed] = (int) WBL_RES_REQ_SLOTS_FREED;

   _enum2StringList[(int) WBL_RES_SETUP_PREPARED] = &_resSetupPrepared;
   _enum2StringList[(int) WBL_RES_SETUP_REJECTED_USER] = &_resSetupUserRejected;
   _enum2StringList[(int) WBL_RES_SETUP_REJECTED_PRIO] = &_resSetupPrio;
   _enum2StringList[(int) WBL_RES_REQ_SLOTS_FREED] = &_resSlotsFreed;

}

WBLResolutionTypeProperty::~WBLResolutionTypeProperty()
{

}

WBLResolutionType WBLResolutionTypeProperty::getResolution2Enum(const ::std::string& value) const
{
   return (WBLResolutionType) convertString2Enum(value);
}

const ::std::string& WBLResolutionTypeProperty::getResolution2String(const WBLResolutionType value) const
{
   return convertEnum2String((const int) value);
}

LCMWiFiStateProperty::LCMWiFiStateProperty():
            DbusProperties(),
            _wifiStateOff("WIFISTATE_OFF"),
            _wifiStateBlocked("WIFISTATE_BLOCKED"),
            _wifiStateNormal("WIFISTATE_NORMAL"),
            _wifiStateNormalSwitchOffWifi("WIFISTATE_NORMAL_SWITCH_OFF_WIFI"),
            _wifiStateUnknown("WIFISTATE_UNKNOWN")
{
   _string2EnumList[_wifiStateOff] = (int) LCM_WIFISTATE_OFF;
   _string2EnumList[_wifiStateBlocked] = (int) LCM_WIFISTATE_BLOCK;
   _string2EnumList[_wifiStateNormal] = (int) LCM_WIFISTATE_NORMAL;
   _string2EnumList[_wifiStateNormalSwitchOffWifi] = (int) LCM_WIFISTATE_NORMAL_SWITCH_OFF_WIFI;
   _string2EnumList[_wifiStateUnknown] = (int) LCM_WIFISTATE_UNKNOWN;

   _enum2StringList[(int) LCM_WIFISTATE_OFF] = &_wifiStateOff;
   _enum2StringList[(int) LCM_WIFISTATE_BLOCK] = &_wifiStateBlocked;
   _enum2StringList[(int) LCM_WIFISTATE_NORMAL] = &_wifiStateNormal;
   _enum2StringList[(int) LCM_WIFISTATE_NORMAL_SWITCH_OFF_WIFI] = &_wifiStateNormalSwitchOffWifi;
   _enum2StringList[(int) LCM_WIFISTATE_UNKNOWN] = &_wifiStateUnknown;

}

LCMWiFiStateProperty::~LCMWiFiStateProperty()
{

}

LCMWiFiState LCMWiFiStateProperty::getWiFiState2Enum(const ::std::string& value) const
{
   return (LCMWiFiState) convertString2Enum(value);
}

const ::std::string& LCMWiFiStateProperty::getWiFiState2String(const LCMWiFiState value) const
{
   return convertEnum2String((const int) value);
}

WBLPowerOffReasonProperty::WBLPowerOffReasonProperty():
            DbusProperties(),
            _wifiPowerOffUserRequest("POWEROFF_USER_REQUEST"),
            _wifiPowerOffWifiState("POWEROFF_WIFI_STATE"),
            _wifiPowerOffBlockWifiState("POWEROFF_BLOCK_WIFI_STATE"),
            _wifiPowerOffUnknown("POWEROFF_UNKNOWN")

{
   _string2EnumList[_wifiPowerOffUserRequest] = (int) WIFI_POWER_OFF_USER_REQUEST;
   _string2EnumList[_wifiPowerOffWifiState] = (int) WIFI_POWER_OFF_WIFISTATE_REQUEST;
   _string2EnumList[_wifiPowerOffBlockWifiState] = (int) WIFI_POWER_OFF_BLOCK_WIFISTATE_REQUEST;
   _string2EnumList[_wifiPowerOffUnknown] = (int) WIFI_POWER_OFF_UNKNOWN;

   _enum2StringList[(int) WIFI_POWER_OFF_USER_REQUEST] = &_wifiPowerOffUserRequest;
   _enum2StringList[(int) WIFI_POWER_OFF_WIFISTATE_REQUEST] = &_wifiPowerOffWifiState;
   _enum2StringList[(int) WIFI_POWER_OFF_BLOCK_WIFISTATE_REQUEST] = &_wifiPowerOffBlockWifiState;
   _enum2StringList[(int) WIFI_POWER_OFF_UNKNOWN] = &_wifiPowerOffUnknown;

}

WBLPowerOffReasonProperty::~WBLPowerOffReasonProperty()
{

}

WBLPowerOffReason WBLPowerOffReasonProperty::getWBLPowerOffReason2Enum(const ::std::string& value) const
{
   return (WBLPowerOffReason) convertString2Enum(value);
}

const ::std::string& WBLPowerOffReasonProperty::getWBLPowerOffReason2String(const WBLPowerOffReason value) const
{
   return convertEnum2String((const int) value);
}

WBLActionProperty::WBLActionProperty():
            DbusProperties(),
            _wifiActionActivate("ACTIVATE"),
            _wifiActionUpdate("UPDATE"),
            _wifiActionRandomize("RANDOMIZE"),
            _wifiActionUnknown("UNKNOWN")

{
   _string2EnumList[_wifiActionActivate] = (int) WIFI_ACTION_ACTIVATE;
   _string2EnumList[_wifiActionUpdate] = (int) WIFI_ACTION_UPDATE;
   _string2EnumList[_wifiActionRandomize] = (int) WIFI_ACTION_RANDOMIZE;
   _string2EnumList[_wifiActionUnknown] = (int) WIFI_ACTION_UNKNOWN;

   _enum2StringList[(int) WIFI_ACTION_ACTIVATE] = &_wifiActionActivate;
   _enum2StringList[(int) WIFI_ACTION_UPDATE] = &_wifiActionUpdate;
   _enum2StringList[(int) WIFI_ACTION_RANDOMIZE] = &_wifiActionRandomize;
   _enum2StringList[(int) WIFI_ACTION_UNKNOWN] = &_wifiActionUnknown;

}

WBLActionProperty::~WBLActionProperty()
{

}

WBLActionType WBLActionProperty::getWBLActionType2Enum(const ::std::string& value) const
{
   return (WBLActionType) convertString2Enum(value);
}

const ::std::string& WBLActionProperty::getWBLActionType2String(const WBLActionType value) const
{
   return convertEnum2String((const int) value);
}

WBLTechnologyRestriction::WBLTechnologyRestriction():
            DbusProperties(),
            _wifiCPWTechnology("CarPlayWireless"),
            _wifiAATechnology("AndroidAutoWireless"),
            _wifiUnknownTechnology("UnknownTechnology")

{
   _string2EnumList[_wifiCPWTechnology] = (int) WBL_TECH_CPW;
   _string2EnumList[_wifiAATechnology] = (int) WBL_TECH_AAW;
   _string2EnumList[_wifiUnknownTechnology] = (int) WBL_TECH_UNKNOWN;

   _enum2StringList[(int) WBL_TECH_CPW] = &_wifiCPWTechnology;
   _enum2StringList[(int) WBL_TECH_AAW] = &_wifiAATechnology;
   _enum2StringList[(int) WBL_TECH_UNKNOWN] = &_wifiUnknownTechnology;

}

WBLTechnologyRestriction::~WBLTechnologyRestriction()
{

}

WBLTechnology WBLTechnologyRestriction::getWBLTechnology2Enum(const ::std::string& value) const
{
   return (WBLTechnology) convertString2Enum(value);
}

const ::std::string& WBLTechnologyRestriction::getWBLTechnology2String(const WBLTechnology value) const
{
   return convertEnum2String((const int) value);
}

WBLRestrictionState::WBLRestrictionState():
            DbusProperties(),
            _stateRequested("REQUESTED"),
            _stateActivating("ACTIVATING"),
            _stateActivated("ACTIVATED"),
            _stateDeActivating("DEACTIVATING"),
            _stateDeActivated("DEACTIVATED"),
            _stateFailed("FAILED")
{
   _string2EnumList[_stateRequested] = (int) WBL_RESTRICT_REQUESTED;
   _string2EnumList[_stateActivating] = (int) WBL_RESTRICT_ACTIVATING;
   _string2EnumList[_stateActivated] = (int) WBL_RESTRICT_ACTIVATED;
   _string2EnumList[_stateDeActivating] = (int) WBL_RESTRICT_DEACTIVATING;
   _string2EnumList[_stateDeActivated] = (int) WBL_RESTRICT_DEACTIVATED;
   _string2EnumList[_stateFailed] = (int) WBL_RESTRICT_FAILED;

   _enum2StringList[(int) WBL_RESTRICT_REQUESTED] = &_stateRequested;
   _enum2StringList[(int) WBL_RESTRICT_ACTIVATING] = &_stateActivating;
   _enum2StringList[(int) WBL_RESTRICT_ACTIVATED] = &_stateActivated;
   _enum2StringList[(int) WBL_RESTRICT_DEACTIVATING] = &_stateDeActivating;
   _enum2StringList[(int) WBL_RESTRICT_DEACTIVATED] = &_stateDeActivated;
   _enum2StringList[(int) WBL_RESTRICT_FAILED] = &_stateFailed;

}

WBLRestrictionState::~WBLRestrictionState()
{

}

WBLRestrictState WBLRestrictionState::getWBLRestriction2Enum(const ::std::string& value) const
{
   return (WBLRestrictState) convertString2Enum(value);
}

const ::std::string& WBLRestrictionState::getWBLRestriction2String(const WBLRestrictState value) const
{
   return convertEnum2String((const int) value);
}


} //namespace bosch
} //namespace org

/** @} */
