/**
 * @file WBLMessageTypes.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#include "WBLMessageTypes.h"

namespace org
{
namespace bosch
{

SSIDItem::SSIDItem() :
      isUTF8(false)
{

}

SSIDItem::SSIDItem(const SSIDItem &ref) :
      SSID(ref.SSID), isUTF8(ref.isUTF8)
{

}

SSIDItem::~SSIDItem()
{

}

bool SSIDItem::operator==(const SSIDItem &ref)
{
   return ((true == std::equal(SSID.begin(), SSID.end(), ref.SSID.begin()))
         && (isUTF8 == ref.isUTF8));
}

SSIDItem &SSIDItem::operator=(const SSIDItem &ref)
{
   if (this == &ref)
      return *this;

   SSID = ref.SSID;
   isUTF8 = ref.isUTF8;

   return *this;
}

APConfig::APConfig():
         type(WBL_AP_TYPE_UNKNOWN),
         passphrase(""),
         security(WBL_SECURITY_UNKNOWN),
         isVisible(false),
         frequency(WBL_FREQ_BAND_UNKNOWN),
         stationsToReserve(0),
         isSeparateAP(false),
         isTypeValid(false),
         isSSIDValid(false),
         isPassphraseValid(false),
         isSecurityValid(false),
         isVisibilityValid(false),
         isFrequencyValid(false),
         isChanListValid(false),
         isStationsToReserveValid(false),
         isSeparateAPValid(false)
{
}

APConfig::APConfig(const APConfig &ref) :
   type(ref.type),
   ssid(ref.ssid),
   passphrase(ref.passphrase),
   security(ref.security),
   isVisible(ref.isVisible),
   frequency(ref.frequency),
   chanList(ref.chanList),
   stationsToReserve(ref.stationsToReserve),
   isSeparateAP(ref.isSeparateAP),
   isTypeValid(ref.isTypeValid),
   isSSIDValid(ref.isSSIDValid),
   isPassphraseValid(ref.isPassphraseValid),
   isSecurityValid(ref.isSecurityValid),
   isVisibilityValid(ref.isVisibilityValid),
   isFrequencyValid(ref.isFrequencyValid),
   isChanListValid(ref.isChanListValid),
   isStationsToReserveValid(ref.isStationsToReserveValid),
   isSeparateAPValid(ref.isSeparateAPValid)
{
}

APConfig::~APConfig()
{
}

bool APConfig::operator==(const APConfig &ref)
{
   return ((type == ref.type)
         && (ssid == ref.ssid)
         && (passphrase == ref.passphrase)
         && (security == ref.security)
         && (isVisible == ref.isVisible)
         && (frequency == ref.frequency)
         && (true == std::equal(chanList.begin(), chanList.end(), ref.chanList.begin()))
         && (stationsToReserve == ref.stationsToReserve)
         && (isSeparateAP == ref.isSeparateAP)
         && (isTypeValid == ref.isTypeValid)
         && (isSSIDValid == ref.isSSIDValid)
         && (isPassphraseValid == ref.isPassphraseValid)
         && (isSecurityValid == ref.isSecurityValid)
         && (isVisibilityValid == ref.isVisibilityValid)
         && (isFrequencyValid == ref.isFrequencyValid)
         && (isChanListValid == ref.isChanListValid)
         && (isStationsToReserveValid == ref.isStationsToReserveValid)
         && (isSeparateAPValid == ref.isSeparateAPValid));
}

APConfig& APConfig::operator=(const APConfig &ref)
{
   if (this == &ref)
      return *this;

   type = ref.type;
   ssid = ref.ssid;
   passphrase = ref.passphrase;
   security = ref.security;
   isVisible = ref.isVisible;
   frequency = ref.frequency;
   chanList = ref.chanList;
   stationsToReserve = ref.stationsToReserve;
   isSeparateAP = ref.isSeparateAP;
   isTypeValid = ref.isTypeValid;
   isSSIDValid = ref.isSSIDValid;
   isPassphraseValid = ref.isPassphraseValid;
   isSecurityValid = ref.isSecurityValid;
   isVisibilityValid = ref.isVisibilityValid;
   isFrequencyValid = ref.isFrequencyValid;
   isChanListValid = ref.isChanListValid;
   isStationsToReserveValid = ref.isStationsToReserveValid;
   isSeparateAPValid = ref.isSeparateAPValid;

   return *this;
}

APSetup::APSetup() :
   passphrase(""),
   security(WBL_SECURITY_UNKNOWN),
   type(WBL_AP_TYPE_UNKNOWN),
   isVisible(false),
   macAddress(""),
   maxStations(0),
   isTethering(false),
   networkType(WIFI_PRIVATE_NETWORK)
{
}

APSetup::APSetup(const APSetup &ref) :
   SSID(ref.SSID),
   passphrase(ref.passphrase),
   security(ref.security),
   type(ref.type),
   stationList(ref.stationList),
   isVisible(ref.isVisible),
   macAddress(ref.macAddress),
   chanList(ref.chanList),
   maxStations(ref.maxStations),
   vendorIEs(ref.vendorIEs),
   supportedFrequencies(ref.supportedFrequencies),
   ipv4ConfigurationList(ref.ipv4ConfigurationList),
   isTethering(ref.isTethering),
   networkType(ref.networkType)
{
}

APSetup::~APSetup()
{
}

bool APSetup::operator==(const APSetup &ref)
{
   return ((SSID == ref.SSID)
         && (passphrase == ref.passphrase)
         && (security == ref.security)
         && (type == ref.type)
         && (isVisible == ref.isVisible)
         && (macAddress == ref.macAddress)
         && (maxStations == ref.maxStations)
         /*Todo: Below Statement causing reset*/
         /*&& (true == std::equal(stationList.begin(), stationList.end(), ref.stationList.begin()))*/
         && (true == std::equal(chanList.begin(), chanList.end(), ref.chanList.begin()))
         && (true == std::equal(vendorIEs.begin(), vendorIEs.end(), ref.vendorIEs.begin()))        
         && (true == std::equal(ipv4ConfigurationList.begin(), ipv4ConfigurationList.end(), ref.ipv4ConfigurationList.begin()))
         && (isTethering == ref.isTethering) && (networkType == ref.networkType));
        
}

APSetup& APSetup::operator =(const APSetup &ref)
{
   if (this == &ref)
      return *this;

   SSID = ref.SSID;
   passphrase = ref.passphrase;
   security = ref.security;
   type = ref.type;
   stationList = ref.stationList;
   isVisible = ref.isVisible;
   macAddress = ref.macAddress;
   chanList = ref.chanList;
   maxStations = ref.maxStations;
   vendorIEs = ref.vendorIEs;
   supportedFrequencies =  ref.supportedFrequencies;
   ipv4ConfigurationList = ref.ipv4ConfigurationList;
   isTethering = ref.isTethering;
   networkType = ref.networkType;

   return *this;
}

WifiSetUpProperty::WifiSetUpProperty() :
   mode(WIFI_MODE_UNKNOWN),
   interface(""),
   powerState(WIFI_STATE_UNKNOWN),
   powerOffType(WIFI_POWER_OFF_UNKNOWN),
   isPowered(false),
   isConnected(false),
   frequency(WBL_FREQ_BAND_UNKNOWN),
   powerFailure(WIFI_POWER_FAILURE_REASON_UNKNOWN),
   currChannel(0)
{
}

WifiSetUpProperty::WifiSetUpProperty(const WifiSetUpProperty &ref) :
   mode(ref.mode),
   interface(ref.interface),
   powerState(ref.powerState),
   powerOffType(ref.powerOffType),
   isPowered(ref.isPowered),
   isConnected(ref.isConnected),
   frequency(ref.frequency),
   powerFailure(ref.powerFailure),
   currChannel(ref.currChannel), 
   apSetup(ref.apSetup),
   connectionStatus(ref.connectionStatus)
{
}

WifiSetUpProperty::~WifiSetUpProperty()
{
}

bool WifiSetUpProperty::operator==(const WifiSetUpProperty &ref)
{
   return ((mode == ref.mode)
         && (interface == ref.interface)
         && (currChannel == ref.currChannel)
         && (powerState == ref.powerState)
         && (powerOffType == ref.powerOffType)
         && (isPowered == ref.isPowered)
         && (powerFailure == ref.powerFailure)
         && (isConnected == ref.isConnected)
         && (frequency == ref.frequency)
         && (apSetup == ref.apSetup)
         && (connectionStatus == ref.connectionStatus));
}

WifiSetUpProperty& WifiSetUpProperty::operator=(const WifiSetUpProperty &ref)
{
   if (this == &ref)
      return *this;

   mode = ref.mode;
   interface = ref.interface;
   powerState = ref.powerState;
   powerOffType = ref.powerOffType;
   isPowered = ref.isPowered;
   powerFailure = ref.powerFailure;
   isConnected = ref.isConnected;
   frequency = ref.frequency;
   currChannel = ref.currChannel;
   apSetup = ref.apSetup;
   connectionStatus = ref.connectionStatus;
   return *this;
}

WifiSetUpItem::WifiSetUpItem() :
      setupObjPath(""),
      nativeObjPath("")
{
}

WifiSetUpItem::WifiSetUpItem(const WifiSetUpItem &ref) :
   setupObjPath(ref.setupObjPath),
   nativeObjPath(ref.nativeObjPath),
   property(ref.property)
{
}

WifiSetUpItem::~WifiSetUpItem()
{
}

bool WifiSetUpItem::operator==(const WifiSetUpItem &ref)
{
   return ((setupObjPath == ref.setupObjPath)
         && (nativeObjPath == ref.nativeObjPath)
         && (property == ref.property));
}

WifiSetUpItem &WifiSetUpItem::operator=(const WifiSetUpItem &ref)
{
   if (this == &ref)
      return *this;

   setupObjPath = ref.setupObjPath;
   nativeObjPath = ref.nativeObjPath;
   property = ref.property;

   return *this;
}

bool WifiSetUpItem::isEmpty()
{
   if(setupObjPath.empty()||nativeObjPath.empty())
   {
      return true;
   }
   else
   {
      return false;
   }
}

LIMAPConfig::LIMAPConfig() :
      frequency(WBL_FREQ_BAND_UNKNOWN),
	   apType(WBL_AP_TYPE_UNKNOWN)
{
}

LIMAPConfig::LIMAPConfig(const LIMAPConfig &ref) :
      frequency(ref.frequency),
      apType(ref.apType)
{
}

LIMAPConfig::~LIMAPConfig()
{
}

bool LIMAPConfig::operator==(const LIMAPConfig &ref)
{
   return ((frequency == ref.frequency) && (apType == ref.apType));
}

LIMAPConfig &LIMAPConfig::operator =(const LIMAPConfig &ref)
{
   if (this == &ref)
      return *this;

   frequency = ref.frequency;
   apType = ref.apType;

   return *this;
}

LIMProperty::LIMProperty() :
      mode(WIFI_MODE_UNKNOWN),
      poweredSetting(false),
      powerState(WIFI_STATE_DEVICE_UNAVAILABLE)
{
}

LIMProperty::LIMProperty(const LIMProperty &ref) :
      mode(ref.mode),
      poweredSetting(ref.poweredSetting),
      limAPConfig(ref.limAPConfig),
      powerState(ref.powerState)
{
}

LIMProperty::~LIMProperty()
{
}

bool LIMProperty::operator==(const LIMProperty &ref)
{
   return ((mode == ref.mode)
         &&(poweredSetting == ref.poweredSetting)
         && (limAPConfig == ref.limAPConfig)
         && (powerState == ref.powerState));
}

LIMProperty &LIMProperty::operator=(const LIMProperty &ref)
{
   if (this == &ref)
      return *this;

   mode = ref.mode;
   poweredSetting = ref.poweredSetting;
   limAPConfig = ref.limAPConfig;
   powerState = ref.powerState;

   return *this;
}

LIMItem::LIMItem() :
      objPath("")
{
}

LIMItem::LIMItem(const LIMItem &ref) :
      objPath(ref.objPath),
      property(ref.property)
{
}

LIMItem::~LIMItem()
{

}

bool LIMItem::operator==(const LIMItem &ref)
{
   return ((objPath == ref.objPath) && (property == ref.property));
}

LIMItem &LIMItem::operator=(const LIMItem &ref)
{
   if (this == &ref)
      return *this;

   objPath = ref.objPath;
   property = ref.property;

   return *this;
}

RequestTypeItem::RequestTypeItem() :
      mode(WIFI_MODE_UNKNOWN),
      frequency(WBL_FREQ_BAND_UNKNOWN)
{

}

RequestTypeItem::RequestTypeItem(const RequestTypeItem &ref)
{
   mode = ref.mode;
   frequency = ref.frequency;
   apConfig = ref.apConfig;
}

RequestTypeItem::~RequestTypeItem()
{
}

bool RequestTypeItem::operator==(const RequestTypeItem &ref)
{
   return ((mode == ref.mode)
         && (frequency == ref.frequency)
         && (apConfig == ref.apConfig));
}

RequestTypeItem& RequestTypeItem::operator=(const RequestTypeItem &ref)
{
   if (this == &ref)
      return *this;

   mode = ref.mode;
   frequency = ref.frequency;
   apConfig =  ref.apConfig;
   return *this;
}

ConflictDetectedItem::ConflictDetectedItem() :
     // user(""),
      conflictID(0),
      conflictType(WBL_CONFLICT_UNKNOWN),
      conflictDes(""),
      numStaToFree(0)
{
}

ConflictDetectedItem::ConflictDetectedItem(const ConflictDetectedItem &ref)
{
   conflictID = ref.conflictID;
   reqConfig = ref.reqConfig;
   currConfig = ref.currConfig;
   conflictType = ref.conflictType;
   conflictDes = ref.conflictDes;
   numStaToFree = ref.numStaToFree;
}

ConflictDetectedItem::~ConflictDetectedItem()
{
}

bool ConflictDetectedItem::operator==(const ConflictDetectedItem &ref)
{
   return ((conflictID = ref.conflictID)
         && (reqConfig == ref.reqConfig)
         && (currConfig == ref.currConfig)
         && (conflictType == ref.conflictType)
         && (conflictDes == ref.conflictDes)
         && (numStaToFree == ref.numStaToFree));
}

ConflictDetectedItem& ConflictDetectedItem::operator=(
      const ConflictDetectedItem &ref)
{
   if (this == &ref)
      return *this;

   conflictID = ref.conflictID;
   reqConfig = ref.reqConfig;
   currConfig = ref.currConfig;
   conflictType = ref.conflictType;
   conflictDes = ref.conflictDes;
   numStaToFree = ref.numStaToFree;

   return *this;
}

void ConflictDetectedItem::clearConflict()
{
   conflictID = 0;
   conflictType= WBL_CONFLICT_UNKNOWN;
   conflictDes = "";
   numStaToFree = 0;
}

ConflictResolvedItem::ConflictResolvedItem() :
      conflictID(0),
      conflictType(WBL_CONFLICT_UNKNOWN),
      resType(WBL_RES_UNKNOWN),
      resolutionDes("")
{
}

ConflictResolvedItem::ConflictResolvedItem(const ConflictResolvedItem &ref)
{
   conflictID = ref.conflictID;
   conflictType = ref.conflictType;
   resType = ref.resType;
   resolutionDes = ref.resolutionDes;
}

ConflictResolvedItem::~ConflictResolvedItem()
{
}

bool ConflictResolvedItem::operator==(const ConflictResolvedItem &ref)
{
   return ((conflictID = ref.conflictID)
         && (conflictType == ref.conflictType)
         && (resType == ref.resType)
         && (resolutionDes == ref.resolutionDes));
}

ConflictResolvedItem& ConflictResolvedItem::operator=(
      const ConflictResolvedItem &ref)
{
   if (this == &ref)
      return *this;

   //user = ref.user;
   conflictID = ref.conflictID;
   conflictType = ref.conflictType;
   resType = ref.resType;
   resolutionDes = ref.resolutionDes;

   return *this;
}

DeAuthenticateStationItem::DeAuthenticateStationItem() :
      macAddress(""),
      type(""),
      objPath("")
{
}

DeAuthenticateStationItem::DeAuthenticateStationItem(const DeAuthenticateStationItem &ref)
{
   //user = ref.user;
   macAddress = ref.macAddress;
   type = ref.type;
   objPath = ref.objPath;
}

DeAuthenticateStationItem::~DeAuthenticateStationItem()
{
}

bool DeAuthenticateStationItem::operator==(const DeAuthenticateStationItem &ref)
{
   return ((macAddress == ref.macAddress)
         && (type == ref.type)
         && (objPath == ref.objPath));
}

DeAuthenticateStationItem& DeAuthenticateStationItem::operator=(
      const DeAuthenticateStationItem &ref)
{
   if (this == &ref)
      return *this;

   //user = ref.user;
   macAddress = ref.macAddress;
   type = ref.type;
   objPath = ref.objPath;

   return *this;
}

HWLimitationInfo::HWLimitationInfo() :
      isCPWSupport(true),
      is2_4GHz_Support(true),
      is5_GHz_Support(false)
{
}

HWLimitationInfo::HWLimitationInfo(const HWLimitationInfo &ref)
{
   isCPWSupport = ref.isCPWSupport;
   is2_4GHz_Support = ref.is2_4GHz_Support;
   is5_GHz_Support = ref.is5_GHz_Support;
}

HWLimitationInfo::~HWLimitationInfo()
{
}

bool HWLimitationInfo::operator==(const HWLimitationInfo &ref)
{
   return ((isCPWSupport == ref.isCPWSupport)&&(is2_4GHz_Support == ref.is2_4GHz_Support)
         && (is5_GHz_Support == ref.is5_GHz_Support));
}

HWLimitationInfo& HWLimitationInfo::operator=(
      const HWLimitationInfo &ref)
{
   if (this == &ref)
      return *this;

   isCPWSupport = ref.isCPWSupport;
   is2_4GHz_Support = ref.is2_4GHz_Support;
   is5_GHz_Support = ref.is5_GHz_Support;

   return *this;
}

WBLConnectionStatus::WBLConnectionStatus() :
      isConnected(false),
      healthIndicatorValue(100)
{
}

WBLConnectionStatus::WBLConnectionStatus(const WBLConnectionStatus &ref)
{
   isConnected = ref.isConnected;
   healthIndicatorValue = ref.healthIndicatorValue;
}

WBLConnectionStatus::~WBLConnectionStatus()
{
}

bool WBLConnectionStatus::operator==(const WBLConnectionStatus &ref)
{
   return ((isConnected == ref.isConnected) && (healthIndicatorValue == ref.healthIndicatorValue));
}

WBLConnectionStatus& WBLConnectionStatus::operator=(
      const WBLConnectionStatus &ref)
{
   if (this == &ref)
      return *this;

   isConnected = ref.isConnected;
   healthIndicatorValue = ref.healthIndicatorValue;

   return *this;
}

} //namespace bosch
} //namespace org

/** @} */
