/**
 * @file DbusProperties.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include "DbusProperties.h"

#include <cstdio>

namespace org
{
namespace bosch 
{

const ::std::string DbusProperties::_emptyString = "";
const int DbusProperties::_dummyEnum = 255;
const ::std::string DbusProperties::_unknownString = "<Unknown>";

DbusProperties::DbusProperties()
{
   // _string2EnumList
   // _enum2StringList
   // _description
}

DbusProperties::DbusProperties(const ::std::string& description)
{
   // _string2EnumList
   // _enum2StringList
   _description = description;
}

DbusProperties::~DbusProperties()
{
   try
   {
   _string2EnumList.clear();
   _enum2StringList.clear();
   _description.clear();
   }catch(...){}
}

int DbusProperties::convertString2Enum(const ::std::string& input, const bool handleError /*= true*/) const
{
   return convertString2Enum(_string2EnumList, input, handleError);
}

const ::std::string& DbusProperties::convertEnum2String(const int input, const bool handleError /*= true*/) const
{
   return convertEnum2String(_enum2StringList, input, handleError);
}

int DbusProperties::convertString2Enum(const ::std::map< std::string, int >& list, const ::std::string& input, const bool handleError /*= true*/) const
{
   ::std::map< std::string, int >::const_iterator it = list.find(input);
   if(list.end() != it)
   {
      return it->second;
   }

   if(true == handleError)
   {
      onString2EnumError(input);
   }

   return _dummyEnum;
}

const ::std::string& DbusProperties::convertEnum2String(const ::std::map< int, const std::string* >& list, const int input, const bool handleError /*= true*/) const
{
   ::std::map< int, const std::string* >::const_iterator it = list.find(input);
   if(list.end() != it)
   {
      if(it->second)
      {
         return *(it->second);
      }
   }

   if(true == handleError)
   {
      onEnum2StringError(input);
   }

   return _emptyString;
}

void DbusProperties::onString2EnumError(const ::std::string& input) const
{
   (void)input;
}

void DbusProperties::onEnum2StringError(const int input) const
{
    (void)input;
}


const ::std::string& DbusProperties::getEnum2StringTrace(const int input)
{
   const ::std::string& result = convertEnum2String((const int)input, false);

   if(_emptyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //namespace bosch
} //namespace org

/** @} */
