/**
 * @file WBLUtils.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */
#ifndef _WBL_UTILS_H
#define _WBL_UTILS_H

#include <stddef.h>
#include <stdio.h>
#include <stdint.h>
#include <time.h>
#include <linux/if_ether.h>
#include <random>
#include <sys/types.h>
#include <sys/stat.h>

namespace org {
    namespace bosch {

#define BIT(x)      (1U << (x))
/*
#define MAC2STR(x)  (x)[0],(x)[1],(x)[2],(x)[3],(x)[4],(x)[5]
#define MACSTR      "02X:02X:02X:02X:02X:02X"
*/

#ifndef MAC2STR
#define MAC2STR(a) (a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5]
#define MACSTR "%02x:%02x:%02x:%02x:%02x:%02x"
#endif

typedef enum __file_type
{
    FILE_TYPE_BLK,
    FILE_TYPE_CHR,
    FILE_TYPE_DIR,
    FILE_TYPE_FIFO,
    FILE_TYPE_LNK,
    FILE_TYPE_REG,
    FILE_TYPE_SOCK,
    NUM_FILE_TYPES
} filetype;


#define return_value_if_fail(expr, val) \
            do { if (__builtin_expect(!!(expr), 1)) { } else { return (val); } } while (0)


class cUtils {
public:
    static int convertHexToNum (char c) {
        if (c >= '0' && c <= '9')
            return c - '0';
        if (c >= 'a' && c <= 'f')
            return c - 'a' + 10;
        if (c >= 'A' && c <= 'F')
            return c - 'A' + 10;
        return -1;
    }

    static int convertHexToByte (const char *hex) {
        int a, b;
        a = convertHexToNum (*hex++);
        if (a < 0)
            return -1;
        b = convertHexToNum (*hex++);
        if (b < 0)
            return -1;
        return (a << 4) | b;
    }

    static int convertHexToBin (const char *hex,
            char *dest, size_t len) {
        size_t i = 0;
        int a;
        const char *ipos = hex;
        char *opos = dest;

        for ( ; i < len; i++) {
            a = convertHexToByte (ipos);
            if (a < 0)
                return -1;
            *opos++ = (char) a;
            ipos += 2;
        }

        return 0;
    }

    static void macToString(char *macstring, uint8_t *addr)
    {
        int i, l = 0;

        for (i = 0; i < ETH_ALEN ; i++) {
            if (i == 0) {
                sprintf(macstring+l, "%02x", addr[i]);
                l += 2;
            } else {
                sprintf(macstring+l, ":%02x", addr[i]);
                l += 3;
            }
        }
    }

    static int getMonotonicTime(struct timespec &ts)
    {
        return clock_gettime (CLOCK_MONOTONIC, &ts);
    }

    static int getRandomNo(int startRange,int endRange)
    {
       std::random_device rd;
      std::uniform_int_distribution<int> dist(startRange, endRange);
      return dist(rd);
    }

    static int file_exists (const char *filepath,
                 filetype type)
    {
        int ret;
        struct stat st;

        return_value_if_fail (filepath, -EINVAL);

        if ((ret = stat (filepath, &st)) < 0)
            return -errno;

        switch (type) {
        default:
        case NUM_FILE_TYPES:
            return -EINVAL;
        case FILE_TYPE_BLK:
            return S_ISBLK (st.st_mode);
        case FILE_TYPE_CHR:
            return S_ISCHR (st.st_mode);
        case FILE_TYPE_DIR:
            return S_ISDIR (st.st_mode);
        case FILE_TYPE_FIFO:
            return S_ISFIFO (st.st_mode);
        case FILE_TYPE_LNK:
            return S_ISLNK (st.st_mode);
        case FILE_TYPE_REG:
            return S_ISREG (st.st_mode);
        case FILE_TYPE_SOCK:
            return S_ISSOCK (st.st_mode);
        }
        return -EINVAL;
    }
};

    }
}

#endif //_WBL_UTILS_H

/** @} */
