/**
 * @file WBLTypes.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WBL_TYPES_H
#define _WBL_TYPES_H

namespace org
{
namespace bosch
{

//TO DO:Revisit
enum WifiMode
{
   WIFI_MODE_STA = 0,
   WIFI_MODE_AP1,
   WIFI_MODE_AP2,
   WIFI_MODE_P2P,
   WIFI_MODE_UNKNOWN = 255
};

enum WBLActionType
{
   WIFI_ACTION_ACTIVATE = 0,
   WIFI_ACTION_UPDATE,
   WIFI_ACTION_RANDOMIZE,
   WIFI_ACTION_UNKNOWN =255
};

enum WBLFrequencyBand
{
   WBL_FREQ_BAND_2_4_GHZ = 2400,
   WBL_FREQ_BAND_5_GHZ = 5000,
   WBL_FREQ_BAND_UNKNOWN = 255
};

enum WBLAPType
{
   WBL_AP_TYPE_NORMAL = 0,
   WBL_AP_TYPE_CARPLAY,
   WBL_AP_TYPE_AAW,
   WBL_AP_TYPE_RESTRICTED,
   WBL_AP_TYPE_UNKNOWN = 255
};

enum WBLConflictType
{
   WBL_CONFLICT_REQ_STA_UNAVAILABLE = 0,
   WBL_CONFLICT_AP_CONFIG_MISMATCH,
   WBL_CONFLICT_WIFI_POWER_OFF,
   WBL_CONFLICT_SIMULTANEOUS_OP_NOTALLOWED,
   WBL_CONFLICT_UNKNOWN = 255
};

enum WBLResolutionType
{
   WBL_RES_SETUP_PREPARED = 0,
   WBL_RES_SETUP_REJECTED_USER,
   WBL_RES_SETUP_REJECTED_PRIO,
   WBL_RES_REQ_SLOTS_FREED,
   WBL_RES_UNKNOWN = 255
};

enum WBLConflictAction
{
   WBL_CONFLICT_ACTION_PREPARE = 0,
   WBL_CONFLICT_ACTION_REJECT,
   WBL_CONFLICT_ACTION_UNKNOWN = 255
};

enum WBLSecurityType
{
   WBL_SECURITY_OPEN = 0,
   WBL_SECURITY_WEP,
   WBL_SECURITY_WPA_PSK,
   WBL_SECURITY_WPA2_PSK,
   WBL_SECURITY_UNKNOWN = 255
};

enum WBLPowerStateType
{
   WIFI_STATE_POWERING_ON = 0,
   WIFI_STATE_POWERED_ON,
   WIFI_STATE_POWERING_OFF,
   WIFI_STATE_POWERED_OFF,
   WIFI_STATE_POWER_FAILURE,
   WIFI_STATE_DEVICE_UNAVAILABLE,
   WIFI_STATE_DEVICE_AVAILABLE,
   WIFI_STATE_UNKNOWN = 255
};

enum WBLPowerFailureType
{
   WIFI_POWER_FAILURE_DEVICE_UNAVAILABLE = 0,
   WIFI_POWER_FAILURE_DEVICE_NOT_READY,
   WIFI_POWER_FAILURE_DEVICE_FAILURE,
   WIFI_POWER_FAILURE_CONFIGURATION,
   WIFI_POWER_FAILURE_INTERNAL_FAILURE,
   WIFI_POWER_FAILURE_REASON_UNKNOWN = 255
};

enum WBLPowerOffReason
{
   WIFI_POWER_OFF_USER_REQUEST = 0,
   WIFI_POWER_OFF_WIFISTATE_REQUEST,
   WIFI_POWER_OFF_BLOCK_WIFISTATE_REQUEST,
   WIFI_POWER_OFF_UNKNOWN = 255
};

enum WBLBaseMsgID
{
   //! WBL interface message IDs
   WBL_MSG_PREPARE_SETUP_REQ = 0,
   WBL_MSG_DEACTIVATE_SETUP_REQ,
   WBL_MSG_RESOLVE_CONFLICT_REQ,
   WBL_MSG_CONFLICT_DETECTED,
   WBL_MSG_CONFLICT_RESOLVED,
   WBL_MSG_ACTIVE_WIFI_SETUPS,
   WBL_MSG_DEAUTHENTICATE_STATION_REQ,
   WBL_MSG_RESTORE_SETTINGS_REQ,
   //! Internal message IDs
   WBL_MSG_INT_DISABLE_SETUP_REQ,
   WBL_MSG_UNKNOWN = 255
};

enum WBLErrorCode
{
   WBL_ERR_NOERROR = 0,
   WBL_ERR_INVALID_ARGS,
   WBL_ERR_PERM_DENIED,
   WBL_ERR_NOTSUPPORTED,
   WBL_ERR_REJECTED,
   WBL_ERR_INPROGRESS,
   WBL_ERR_CANCELLED,
   WBL_ERR_ALREADY_EXIST,
   WBL_ERR_WIFISTATE_BLOCKED,
   WBL_ERR_UNKNOWN = 255
};

enum LCMWiFiState
{
   LCM_WIFISTATE_OFF = 0,
   LCM_WIFISTATE_BLOCK,
   LCM_WIFISTATE_NORMAL,
   LCM_WIFISTATE_NORMAL_SWITCH_OFF_WIFI,
   LCM_WIFISTATE_UNKNOWN = 255
};

enum SPITechnology
{
   WBL_CPW_NOT_ALLOWED = 0,
   WBL_CPW_ALLOWED,
   WBL_AAW_NOT_ALLOWED,
   WBL_AAW_ALLOWED,
   WBL_NO_TECH= 255
};

enum WBLTechnology
{
   WBL_TECH_CPW = 0,
   WBL_TECH_AAW,
   WBL_TECH_UNKNOWN = 255
};

enum WBLRestrictState
{
   WBL_RESTRICT_REQUESTED = 0 ,
   WBL_RESTRICT_ACTIVATING,
   WBL_RESTRICT_ACTIVATED,
   WBL_RESTRICT_DEACTIVATING,
   WBL_RESTRICT_DEACTIVATED,
   WBL_RESTRICT_FAILED,
   WBL_RESTRICT_UNKNOWN = 255
};

enum WBLAPRestoreType
{
  WBL_AP_RESTORE_POWER,
  WBL_AP_RESTORE_CONFIGS,
  WBL_AP_RESTORE_UNKOWN = 255
};

enum WBLWifiStateRequest
{
   WIFI_STATE_REQUEST_IDLE = 0,
   WIFI_STATE_REQUEST_BLOCK,
   WIFI_STATE_REQUEST_BLOCK_IN_PROGRESS,
   WIFI_STATE_REQUEST_UNBLOCK,
   WIFI_STATE_REQUEST_UNBLOCK_IN_PROGRESS,
   WIFI_STATE_REQUEST_FAILED,
   WIFI_STATE_REQUEST_UNKNOWN=255
};

enum WifiAccessNetworkType
{
    WIFI_PRIVATE_NETWORK = 0,
    WIFI_PRIVATE_NETWORK_GUEST_ACCESS = 1,
    WIFI_CHARGEABLE_PUBLIC_NETWORK = 2,
    WIFI_FREE_PUBLIC_NETWORK = 3,
    WIFI_PERSONAL_DEVICE_NETWORK = 4,
    WIFI_EMERGENCY_SERIVCE_NETWORK_ONLY = 5,
    /*6->13 reserved*/
    WIFI_EXPERIMENTAL = 14,
    WIFI_WILDCARD = 15
};
} // namespace bosch
} // namespace org

#endif //_WBL_TYPES_H

/** @} */
