/**
 * @file WBLMessages.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _WBL_MESSAGES_H
#define _WBL_MESSAGES_H

#include "WBLMessageTypes.h"
#include "WBLBaseMsg.h"

namespace org
{

namespace bosch
{

class PrepareSetupMsg final : public WBLBaseMsg
{
public:
   PrepareSetupMsg() :
      WBLBaseMsg(WBL_MSG_PREPARE_SETUP_REQ),
      _mode(WIFI_MODE_UNKNOWN),
      _action(WIFI_ACTION_UNKNOWN)
   {

   }
   virtual ~PrepareSetupMsg()
   {
   }
   void setAPConfigItemParams(const APConfig& config)
   {
      _apConfig = config;
   }
   APConfig getAPConfigItemParams() const
   {
      return _apConfig;
   }
   void setWifiMode(const WifiMode& mode)
   {
      _mode = mode;
   }
   WifiMode getWifiMode() const
   {
      return _mode;
   }
   void setWifiAction(const WBLActionType& action)
   {
      _action = action;
   }
   WBLActionType getWifiAction()
   {
      return _action;
   }
private:
   WifiMode _mode;
   APConfig _apConfig;
   WBLActionType _action;
};

class DeActivateSetupMsg final : public WBLBaseMsg
{
public:
   DeActivateSetupMsg() :
      WBLBaseMsg(WBL_MSG_DEACTIVATE_SETUP_REQ),
      _mode(WIFI_MODE_UNKNOWN),
      _powerOffType(WIFI_POWER_OFF_UNKNOWN)
   {

   }
   virtual ~DeActivateSetupMsg()
   {

   }
   void setWifiMode(const WifiMode& mode)
   {
      _mode = mode;
   }
   WifiMode getWifiMode() const
   {
      return _mode;
   }
   void setRequestType(const WBLPowerOffReason powerOffType)
   {
      _powerOffType = powerOffType;
   }
   WBLPowerOffReason getRequestType() const
   {
      return _powerOffType;
   }
private:
   WifiMode _mode;
   WBLPowerOffReason _powerOffType;
};

class ActiveWifiSetupsMsg : public WBLBaseMsg
{
public:
   ActiveWifiSetupsMsg() :
      WBLBaseMsg(WBL_MSG_ACTIVE_WIFI_SETUPS)
   {
   }
   virtual ~ActiveWifiSetupsMsg()
   {
   }
   void setWifiSetUps(const WifiSetUpList& list)
   {
      _list = list;
   }
   void getWifiSetUps(WifiSetUpList& list) const
   {
      list = _list;
   }
private:
   WifiSetUpList _list;
};

class ResolveConflictMsg final :public WBLBaseMsg
{
public:
   ResolveConflictMsg() :
      WBLBaseMsg(WBL_MSG_RESOLVE_CONFLICT_REQ),
      _conflictID(0),
      _action(0)
   {
   }
   virtual ~ResolveConflictMsg()
   {
   }
   void setConflictId(const uint32& conflictID)
   {
      _conflictID = conflictID;
   }
   uint32 getConflictId() const
   {
      return _conflictID;
   }
   void setAction(const uint32& action)
   {
      _action = action;
   }
   uint32 getAction() const
   {
      return _action;
   }
private:
   uint32 _conflictID;
   uint32 _action;
   //WBLUserType _user;
};

class ConflictDetectedMsg :public WBLBaseMsg
{
public:
   ConflictDetectedMsg() :
      WBLBaseMsg(WBL_MSG_CONFLICT_DETECTED)
   {
   }
   virtual ~ConflictDetectedMsg()
   {
   }
   void setConflictDetectedItem(const ConflictDetectedItem &item)
   {
      _item = item;
   }
   void getConflictDetectedItem(ConflictDetectedItem &item)const
   {
      item = _item;
   }
private:
   ConflictDetectedItem _item;
};

class ConflictResolvedMsg :public WBLBaseMsg
{
public:
      ConflictResolvedMsg() :
      WBLBaseMsg(WBL_MSG_CONFLICT_RESOLVED)
   {
   }
   virtual ~ConflictResolvedMsg()
   {
   }
   void setConflictResolvedItem(const ConflictResolvedItem &item)
   {
      _item = item;
   }
   void getConflictResolvedItem(ConflictResolvedItem &item)const
   {
      item = _item;
   }
private:
   ConflictResolvedItem _item;
};

class DisableSetupMsg final : public WBLBaseMsg
{
public:
   DisableSetupMsg() :
      WBLBaseMsg(WBL_MSG_INT_DISABLE_SETUP_REQ),
      _mode(WIFI_MODE_UNKNOWN)
   {
   }
   virtual ~DisableSetupMsg()
   {
   }
   void setWifiMode(WifiMode mode)
   {
      _mode = mode;
   }
   WifiMode getWifiMode() const
   {
      return _mode;
   }
private:
   WifiMode _mode; 
};

class DeAuthenticateStationMsg final : public WBLBaseMsg
{
public:
   DeAuthenticateStationMsg() :
      WBLBaseMsg(WBL_MSG_DEAUTHENTICATE_STATION_REQ)
   {

   }
   virtual ~DeAuthenticateStationMsg()
   {

   }
   void setDeAuthStation(const DeAuthenticateStationItem& deAuthItem)
   {
      _deAuthItem = deAuthItem;
   }
   DeAuthenticateStationItem getDeAuthStation() const
   {
      return _deAuthItem;
   }
private:
   DeAuthenticateStationItem _deAuthItem;
};

class RestoreFactorySettingsMsg final : public WBLBaseMsg
{
public:
   RestoreFactorySettingsMsg() :
         WBLBaseMsg(WBL_MSG_RESTORE_SETTINGS_REQ),
         _mode(WIFI_MODE_UNKNOWN)
   {

   }
   virtual ~RestoreFactorySettingsMsg()
   {

   }
   void setWifiMode(const WifiMode mode)
   {
      _mode = mode;
   }
   WifiMode getWifiMode()const
   {
      return _mode;
   }
private:
   WifiMode _mode;

};

} //namespace bosch
} //namespace org

#endif //_WBL_MESSAGES_H

/** @} */
