/**
 * @file WBLDefines.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WBL_DEFINES_H
#define _WBL_DEFINES_H

#include "asf/core/Logger.h"
#include "WBLTypeProperties.h"

namespace org
{
namespace bosch
{

#define RELEASE_MEM(VAR)  \
   if (VAR)  \
   {  \
      delete VAR; \
      VAR = nullptr; \
   }  \

#define RELEASE_ARRAY_MEM(VAR)  \
   if (VAR)  \
   {  \
      delete[] VAR; \
      VAR = nullptr; \
   }  \

#define WBL_ASSERT(EXPR)   \
      if (EXPR)  \
         LOG_ERROR("Assert in %s", __PRETTY_FUNCTION__);

#define WBL_ASSERT_AND_EXIT(EXPR)   \
      if (EXPR)   { \
         LOG_ERROR("Assert in %s. Hence exiting func.", __PRETTY_FUNCTION__); \
         return;  }\

#define WBL_ASSERT_AND_RETURN(EXPR, RETURN_DATA)   \
      if (EXPR)   { \
         LOG_ERROR("Assert in %s. Hence exiting func.", __PRETTY_FUNCTION__); \
         return (RETURN_DATA);  }\

#define WBL_INTENTIONALLY_UNUSED(PARAM1)  \
   (void)(PARAM1);

#define IS_ENUM_VALID(ENUM) (255 > (ENUM))
#define IS_LIST_VALID(LIST) (!(LIST.empty()))
#define IS_STRING_VALID(STRING) (!(STRING.empty()))

} //namespace bosch
} //namespace org

#endif //_WBL_DEFINES_H

/** @} */
