/**
 * @file DataProvider.h
 * @author RBEI/ECO3 Akshay Kumar S R
 * @copyright (c) 2020 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */



#ifndef _WBL_CONFIGURATION_H
#define _WBL_CONFIGURATION_H

#include "asf/core/Logger.h"

namespace org
{
namespace bosch
{
class WBLConfiguration {
public:
   WBLConfiguration();
   ~WBLConfiguration();

   uint8_t _CPWSupportDefault;
   uint8_t _AAWSupportDefault;
   uint8_t _CPWSupportRead;
   uint8_t _AAWSupportRead;
   uint8_t _ManfNameRead;
   uint8_t _ModelNameRead;
   uint8_t _5GhzCDSupportRead;
   uint8_t _5GhzPDSupportRead;
   uint8_t _BrandTypeRead;
   uint8_t _BrandTypeDefault;
   std::string _VehicleNameDefault;
   std::string _ManfNameDefault;
   uint8_t _ManfNameLength;
   uint8_t _ModelNameLength;
   std::string _ModelNameDefault;

   uint8_t _5GHzCDSupportDefault;
   uint8_t _5GHzPDSupportDefault;
   uint16_t _CPW2_4GhzChannel;
   uint16_t _CPW5GHzChannel;
   uint16_t _AAW5GHzChannel;

private:
   DECLARE_CLASS_LOGGER();
};
}
}
#endif
