/**
 * @file IDbusProperty2EnumMapping.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _I_DBUS_PROPERTY_2_ENUM_MAPPING_H
#define _I_DBUS_PROPERTY_2_ENUM_MAPPING_H

#include <vector>
#include <map>
#include <string>

namespace org 
{
namespace bosch 
{

/**
 * DBUS property parser class.
 */
class IDbusProperty2EnumMapping
{
public:
   /**
    * Get property to enum mapping list. To be implemented by child class.
    *
    * @param[out] interfaceList: property to enum mapping list matching the given interfaces
    * @param[in] matchingInterfaces: interfaces to be checked
    */
   virtual void getInterfaces(::std::vector<const ::std::map< ::std::string, int >*>& interfaceList, const ::std::vector< int >& matchingInterfaces) const = 0;
};

} //namespace bosch
} //namespace org

#endif //_I_DBUS_PROPERTY_2_ENUM_MAPPING_H

/** @} */
