/**
 * @file WapdmanServerComponent.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @author RBEI/ECO32 Kesavan B
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief 
 *
 * @{
 */

#ifndef WAPDMAN_SERVER_COMPONENT_H
#define WAPDMAN_SERVER_COMPONENT_H

#include <iostream>
using namespace std;
#include <string>
#include <vector>
#include <algorithm>
#include "asf/core/BaseComponent.h"
#include "Stub/WapdmanServiceStub.h"
#include "boost/ptr_container/ptr_vector.hpp"

namespace Stub 
{ 
namespace server 
{
	using namespace ::asf::core;
    using namespace ::Stub::WapdmanService;
	using namespace ::Stub::WapdmanServiceTypes;
	
    class WapdmanServerComponent:public BaseComponent,public WapdmanServiceStub
    { 
		public:
		WapdmanServerComponent();
		~WapdmanServerComponent();
		static WapdmanServerComponent& rfGetServerInstance();
		void onSetSSIDRequest(const ::boost::shared_ptr< SetSSIDRequest >& setSSID);
		void vGlueonSetSSIDResponse(uint32 act);
		uint32  m_u32act;
		bool m_bool;
		struct StructAPList
		{
		/*Indicates the objPath*/
		std::string objPath;
		};
		void onDeAuthenticateStationRequest(const ::boost::shared_ptr< DeAuthenticateStationRequest >& DeAuthenticateStation);
		void vGlueonDeAuthenticateStationResponse(uint32 act);
		void onBlacklistStationRequest(const ::boost::shared_ptr< BlacklistStationRequest >& BlacklistStation);
		void vGlueonBlacklistStationResponse(uint32 act);
		void onSetOperatingChannelsRequest(const ::boost::shared_ptr< SetOperatingChannelsRequest >& SetOperatingChannels);
		void vGlueonSetOperatingChannelsResponse(uint32 act);
		void onStartWPSPushButtonRequest(const ::boost::shared_ptr< StartWPSPushButtonRequest >& StartWPSPushButton);
		void vGlueonStartWPSPushButtonResponse(uint32 act);
		void onCancelWPSRequest(const ::boost::shared_ptr< CancelWPSRequest >& CancelWPS);
		void vGlueonCancelWPSResponse(uint32 act);
		
		virtual void onRegisterVendorServiceRequest (const ::boost::shared_ptr< RegisterVendorServiceRequest >& registerVendorService);
		void vGlueonRegisterVendorServiceResponse(uint32 act);
		
		void onUnregisterVendorServiceRequest (const ::boost::shared_ptr< UnregisterVendorServiceRequest >& unregisterVendorService);
		void vGlueonUnregisterVendorServiceResponse(uint32 act);
		//Get Request
		void onGetRequest (const ::boost::shared_ptr< GetRequest >& request);
		//void vGlueonGetResponse(std::string value,uint32 act);
		// virtual void onGetSSIDRequest (const ::boost::shared_ptr< GetSSIDRequest >& getSSID);
		
		//void vGlueonGetResponse(boost::shared_ptr< ::org::freedesktop::DBus::Properties::GetResponse >& response);
	  
		/*GetAssociatedStations*/
		void onGetAssociatedStationsRequest (const ::boost::shared_ptr< GetAssociatedStationsRequest >& getAssociatedStations);
		void vGlueonGetAssociatedStationsResponse(::std::vector< ::Stub::WapdmanServiceTypes::StructASList > recv);
	  
		/*GetAccessPoints*/
		void onGetAccessPointsRequest(const ::boost::shared_ptr< GetAccessPointsRequest >& GetAccessPoints);
		void vGlueonGetAccessPointsResponse(::std::vector< ::Stub::WapdmanServiceTypes::StructAPList > recv);
	    void vGlueonAccessPointAddedResponse(::std::string Value);
		void vGlueonAccessPointRemovedResponse(::std::string Value);
	  
		/*RegisterAgent*/
		void onRegisterAgentRequest (const ::boost::shared_ptr< RegisterAgentRequest >& registerAgent);
		void vGlueonRegisterAgentResponse(uint32 act);
	    
		/*UnregisterAgent*/
		void onUnregisterAgentRequest (const ::boost::shared_ptr< UnregisterAgentRequest >& unregisterAgent);
		void vGlueonUnregisterAgentResponse(uint32 act);
	  
		/*FindAccessPoint*/
		virtual void onFindAccessPointRequest (const ::boost::shared_ptr< FindAccessPointRequest >& findAccessPoint);
		void vGlueonFindAccessPointResponse(::std::string accesspoint,uint32 act);
	  	  
		/*SSID -- Get Functionality Manually Added */
		virtual void onSSIDGetRequest (const ::boost::shared_ptr< SSIDGetRequest >& sSID);
		void vGlueonSSIDGetResponse(std::vector<uint8> ssidget,uint32 act);
	  
		/* Security -- Get Functionality Manually Added */
		virtual void onSecurityRequest (const ::boost::shared_ptr< SecurityRequest >& security);
		void vGlueonSecurityResponse(::std::string security,uint32 act);
	  
		/* MacAddress -- Get Functionality Manually Added */
		virtual void onMacAddressGetRequest (const ::boost::shared_ptr< MacAddressGetRequest >& macAddressGet);
		void vGlueonMacAddressGetResponse(::std::string macaddress,uint32 act);
	  
		/* Interface -- Get Functionality Manually Added */
		virtual void onInterfaceGetRequest (const ::boost::shared_ptr< InterfaceGetRequest >& interfaceGet);
		void vGlueonInterfaceGetResponse(::std::string interface,uint32 act);
		
		/* Passphrase -- Get Functionality Manually Added */
		virtual void onPassphraseGetRequest (const ::boost::shared_ptr< PassphraseGetRequest >& passphraseGet);
		virtual void onPassphraseSetRequest (const ::boost::shared_ptr< PassphraseSetRequest >& passphraseSet);
		void vGlueonPassphraseGetResponse(::std::string passphrase,uint32 act);
	  
		/* Powered -- Get Functionality Manually Added */
		virtual void onPoweredGetRequest (const ::boost::shared_ptr< PoweredGetRequest >& poweredGet);
		virtual void onPoweredSetRequest (const ::boost::shared_ptr< PoweredSetRequest >& poweredSet);
		void vGlueonPoweredGetResponse(bool powered,uint32 act);
	  
		/* Hidden -- Get Functionality Manually Added */
		virtual void onHiddenGetRequest (const ::boost::shared_ptr< HiddenGetRequest >& hiddenGet);
		virtual void onHiddenSetRequest (const ::boost::shared_ptr< HiddenSetRequest >& hiddenSet);
		void vGlueonHiddenGetResponse(bool hidden,uint32 act);
	  
		/* CurrentOperatingChannel -- Get Functionality Manually Added */
		virtual void onCurrentOperatingChannelGetRequest (const ::boost::shared_ptr< CurrentOperatingChannelGetRequest >& currentOperatingChannelGet);
		void vGlueonCurrentOperatingChannelGetResponse(uint16 currentoperchannel,uint32 act);
	  
		/* VendorIEs -- Get Functionality Manually Added */
		virtual void onVendorIEsGetRequest (const ::boost::shared_ptr< VendorIEsGetRequest >& vendorIEsGet);
		void vGlueonVendorIEsGetResponse(uint16 vendorIEs,uint32 act);
		
		
		/*PowerState -- Get Functionality Manually Added */
		virtual void onPowerStateGet(const ::boost::shared_ptr< PowerStateGet >& powerState);
		void vGlueonPowerStateGetResponse(::std::string powerstate,uint32 act);
		/*PowerFailureReason -- Get Functionality Manually Added */
		virtual void onPowerFailureReasonGet(const ::boost::shared_ptr< PowerFailureReasonGet >& powerFailureReason);
		void vGlueonPowerFailureReasonGetResponse(::std::string powerfailurereason,uint32 act);
		/*CurrentHwMode -- Get Functionality Manually Added */
		virtual void onCurrentHwModeGet(const ::boost::shared_ptr< CurrentHwModeGet >& currentHwMode);
		void vGlueonCurrentHwModeGetResponse(::std::string currenthwmode,uint32 act);
		/*MaximumStationsAllowed -- Get Functionality Manually Added */
		virtual void onMaximumStationsAllowedGet(const ::boost::shared_ptr< MaximumStationsAllowedGet >& maximumStationsAllowed);
		void vGlueonMaximumStationsAllowedGetResponse(uint16 maxstations,uint32 act);
		/*SupportedChannels -- Get Functionality Manually Added */
		virtual void onSupportedChannelsGet(const ::boost::shared_ptr< SupportedChannelsGet >& supportedChannels);
		void vGlueonSupportedChannelsGetResponse(::std::vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList > supportedchanllist,uint32 act);
		/*HWFeatures -- Get Functionality Manually Added */
		virtual void onHWFeaturesGet(const ::boost::shared_ptr< HWFeaturesGet >& hWFeatures);
		void vGlueonHWFeaturesGetResponse(::std::vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList > hwfeaturelist,uint32 act);
		
		/*Associated Station Properties */
		
		/* MacAddress - Associated Stations -- Get Functionality Manually Added */
		virtual void onMacAddressAsGetRequest (const ::boost::shared_ptr< MacAddressAsGetRequest >& macAddressAsGet);
		void vGlueonMacAddressAsGetResponse(::std::string macaddressasget,uint32 act);
		/* Accesspoint - Associated Stations -- Get Functionality Manually Added */
		virtual void onAccesspointAsGetRequest (const ::boost::shared_ptr< AccesspointAsGetRequest >& accesspointAsGet);
		void vGlueonAccesspointAsGetResponse(::std::string accesspointobjpath,uint32 act);
		/* Interface - Associated Stations -- Get Functionality Manually Added */
		virtual void onInterfaceAsGetRequest (const ::boost::shared_ptr< InterfaceAsGetRequest >& interfaceAsGet);
		void vGlueonInterfaceAsGetResponse(::std::string interfaceasget,uint32 act);
		/* IPAddress - Associated Stations -- Get Functionality Manually Added */
		virtual void onIPAddressAsGetRequest (const ::boost::shared_ptr< IPAddressAsGetRequest >& iPAddressAsGet);
		void vGlueonIPAddressAsGetResponse(::std::string ipaddressasget,uint32 act);
		/* Hostname - Associated Stations -- Get Functionality Manually Added */
		virtual void onHostnameAsGetRequest (const ::boost::shared_ptr< HostnameAsGetRequest >& hostnameAsGet);
		void vGlueonHostnameAsGetResponse(::std::string hostnameasget,uint32 act);
	  
		/* Accesspoint Tethering Properties */
		virtual void onTetheringGet(const ::boost::shared_ptr< TetheringGet >& tethering);
		virtual void onTetheringSetRequest (const ::boost::shared_ptr< TetheringSetRequest >& tetheringSet);
		void vGlueonTetheringGetResponse(bool tethering,uint32 act);
	  
	  
		virtual void onIPv4PoolGet(const ::boost::shared_ptr< IPv4PoolGet >& iPv4Pool);
		void vGlueonIPv4PoolGetResponse(::std::vector< ::Stub::WapdmanServiceTypes::StructIPv4List > ipv4list,uint32 act);
		private:
		static WapdmanServerComponent* m_poWapdmanServerComponent;
		DECLARE_CLASS_LOGGER ();
    };
}
}
#endif //WAPDMAN_SERVER_COMPONENT_H