/**
 * @file WapdmanClientComponent.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief 
 *
 * @{
 */
 
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusProxy.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/wapdman/Accesspoint.h"
#include "org/bosch/wapdman/AccesspointProxy.h"
#include "org/bosch/wapdman/Manager.h"
#include "org/bosch/wapdman/ManagerProxy.h"
#include "org/freedesktop/DBus/Properties.h"
#include "org/freedesktop/DBus/PropertiesProxy.h"
#include "boost/ptr_container/ptr_vector.hpp"
#include "org/bosch/wapdman/AssociatedStation.h"
#include "org/bosch/wapdman/AssociatedStationProxy.h"
#include "org/bosch/wapdman/Accesspoint/TetheringSettings.h"
#include "org/bosch/wapdman/Accesspoint/TetheringSettingsProxy.h"
#include "org/bosch/wapdman/Accesspoint/DHCPDNSConfiguration.h"
#include "org/bosch/wapdman/Accesspoint/DHCPDNSConfigurationProxy.h"

namespace Proxy 
{
namespace client 
{
	using namespace ::org::bosch::wapdman::Accesspoint;
	using namespace ::org::bosch::wapdman::Manager;
	using namespace ::org::bosch::wapdman::AssociatedStation;
	using namespace ::org::bosch::wapdman::Accesspoint::TetheringSettings;
	using namespace ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration;
	using namespace std;
	using namespace ::asf::core;
	using namespace ::org::freedesktop::DBus::Properties;
  
	class WapdmanClientComponent: public BaseComponent,ServiceAvailableIF,SetSSIDCallbackIF,DeAuthenticateStationCallbackIF,BlacklistStationCallbackIF,
								SetOperatingChannelsCallbackIF,StartWPSPushButtonCallbackIF,CancelWPSCallbackIF,GetAssociatedStationsCallbackIF,GetAccessPointsCallbackIF,
								AccessPointAddedCallbackIF,AccessPointRemovedCallbackIF,RegisterAgentCallbackIF,UnregisterAgentCallbackIF,FindAccessPointCallbackIF,
								GetCallbackIF,SSIDCallbackIF,SecurityCallbackIF,::org::bosch::wapdman::Accesspoint::MacAddressCallbackIF,::org::bosch::wapdman::Accesspoint::InterfaceCallbackIF,PassphraseCallbackIF,PoweredCallbackIF,
								HiddenCallbackIF,CurrentOperatingChannelCallbackIF,VendorIEsCallbackIF,IPAddressCallbackIF,HostnameCallbackIF,AccesspointCallbackIF,
								RegisterVendorServiceCallbackIF,UnregisterVendorServiceCallbackIF,AssociatedStationsChangedCallbackIF,
								PowerStateCallbackIF,PowerFailureReasonCallbackIF,CurrentHwModeCallbackIF,MaximumStationsAllowedCallbackIF,
								SupportedChannelsCallbackIF,HWFeaturesCallbackIF,::org::bosch::wapdman::AssociatedStation::MacAddressCallbackIF,::org::bosch::wapdman::AssociatedStation::InterfaceCallbackIF,TetheringCallbackIF,IPv4PoolCallbackIF
	{
	private:
		DECLARE_CLASS_LOGGER ();
		::boost::shared_ptr<AccesspointProxy> m_poAPProxy;
		::boost::shared_ptr<ManagerProxy> m_poMGRProxy;
		::boost::shared_ptr<AssociatedStationProxy> m_poASProxy;
		::boost::shared_ptr<PropertiesProxy> m_poPropertiesProxyyy;
		::boost::shared_ptr<TetheringSettingsProxy> m_poTSProxy;
		::boost::shared_ptr<DHCPDNSConfigurationProxy> m_poDCProxy;
		
		static WapdmanClientComponent* m_poWapdmanClientComponent;
	public:
	
		WapdmanClientComponent():
		BaseComponent(),
		//m_poAPProxy(::org::bosch::wapdman::Accesspoint::AccesspointProxy::createProxy(
        //"apPort",*this)),
		m_poMGRProxy(::org::bosch::wapdman::Manager::ManagerProxy::createProxy(
        "mgrPort",*this)),
		//m_poASProxy(::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy::createProxy(
        //"asPort",*this))//,
		// m_poPropertiesProxyy(::org::freedesktop::DBus::Properties::PropertiesProxy::createProxy(
		//  "propertiesPorts",*this)),
		m_poTSProxy(::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringSettingsProxy::createProxy(
        "tsPort",*this)),
		m_poDCProxy(::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::DHCPDNSConfigurationProxy::createProxy(
        "dhcpdnsPort",*this))	
		{
        LOG_INFO("WapdmanClientComponent::Constructor");
        m_poWapdmanClientComponent = this;
		}
		/* WapdmanClientComponent():
		BaseComponent(),
		m_poMGRProxy(::org::bosch::wapdman::Manager::ManagerProxy::createProxy(
        "mgrPort",*this))
		{
        LOG_INFO("WapdmanClientComponent::ManagerProxy::Constructor");
        m_poWapdmanClientComponent = this;
		}*/
		//WapdmanClientComponent();
		virtual ~WapdmanClientComponent(); 
		static WapdmanClientComponent& rfGetClientComponentInstance();
		/*ServiceAvailableIF interface*/
		virtual void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange &stateChange);
        virtual void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange &stateChange);
		
		/* setSSID */
		virtual void onSetSSIDError(const ::boost::shared_ptr< AccesspointProxy >& proxy, const ::boost::shared_ptr< SetSSIDError >& error)
		{}
		virtual void onSetSSIDResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SetSSIDResponse >& out);
		void vGlueSetSSIDRequest(std::vector<uint8> ssid,bool utf8ssid);
		
		/* DeAuthenticateStation */
		virtual void onDeAuthenticateStationError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationError >& error);
	//	{}
		virtual void onDeAuthenticateStationResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationResponse >& out);
		void vGlueDeAuthenticateStationRequest(std::string address);
		
		/* BlacklistStation */
		virtual void onBlacklistStationError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::BlacklistStationError >& error)
		{}
		virtual void onBlacklistStationResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::BlacklistStationResponse >& out);
		void vGlueBlacklistStationRequest(std::string address,bool allow);
	
		/* SetOperatingChannels */
		virtual void onSetOperatingChannelsError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsError >& error)
		{}
		virtual void onSetOperatingChannelsResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsResponse >& out);
		void vGlueSetOperatingChannelsRequest(std::vector<uint16> channels);
	
		/* StartWPSPushButton */
		virtual void onStartWPSPushButtonError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::StartWPSPushButtonError >& error)
		{}
		virtual void onStartWPSPushButtonResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::StartWPSPushButtonResponse >& out);
		void vGlueStartWPSPushButtonRequest();

		/* CancelWPS */
		virtual void onCancelWPSError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::CancelWPSError >& error)
		{}
		virtual void onCancelWPSResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::CancelWPSResponse >& out);
		void vGlueCancelWPSRequest();
		
		/*RegisterVendorService*/
		virtual void onRegisterVendorServiceError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceError >& error)
		{}
		virtual void onRegisterVendorServiceResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceResponse >& response);
		void vGlueRegisterVendorServiceRequest(std::vector < std::vector <uint8> > IEss);
		
		/*UnregisterVendorService*/
		virtual void onUnregisterVendorServiceError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceError >& error)
		{}
		virtual void onUnregisterVendorServiceResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceResponse >& response);
		void vGlueUnregisterVendorServiceRequest(std::vector < std::vector <uint8> > IEss);
		
		/*GetAssociatedStations*/
		virtual void onGetAssociatedStationsError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsError >& error){}
		virtual void onGetAssociatedStationsResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponse >& response);
		void vGlueGetAssociatedStationsRequest();
		
				
		virtual void onAssociatedStationsChangedError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedError >& error){}
		virtual void onAssociatedStationsChangedSignal(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignal >& signal);

		/* SSID -- Get Manual Implementation */
		virtual void onSSIDError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SSIDError >& error){}
		virtual void onSSIDUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SSIDUpdate >& update);
		void vGlueSSIDGetRequest();
		
		/* Security -- Get Manual Implementation */
		virtual void onSecurityError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SecurityError >& error){}
		virtual void onSecurityUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy,
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SecurityUpdate >& update);
		void vGlueSecurityGetRequest();
		
		/* Accesspoint Tethering Properties */
		
	virtual void onTetheringError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringSettingsProxy >& proxy,
	const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringError >& error) {}

	virtual void onTetheringUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringSettingsProxy >& proxy,
	const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringUpdate >& update);
	void vGlueTetheringGetRequest();
	void vGlueTetheringSetRequest(bool tethering);
	
	
	/*Accesspoint DHCPDNSConfiguration Properties*/
	
	virtual void onIPv4PoolError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::DHCPDNSConfigurationProxy >& proxy, 
	const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::IPv4PoolError >& error){}
	virtual void onIPv4PoolUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::DHCPDNSConfigurationProxy >& proxy, 
	const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::IPv4PoolUpdate >& update);
	void vGlueIPv4PoolGetRequest();
		
		/* MacAddress -- Get Manual Implementation */
		virtual void onMacAddressError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::MacAddressError >& error){}
		virtual void onMacAddressUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::MacAddressUpdate >& update);
		void vGlueMacAddressGetRequest();
		
		/* Interface -- Get Manual Implementation */
		virtual void onInterfaceError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::InterfaceError >& error){}
		virtual void onInterfaceUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::InterfaceUpdate >& update);
		void vGlueInterfaceGetRequest();
		
		/* Passphrase -- Get Manual Implementation */
		virtual void onPassphraseError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PassphraseError >& error){}
		virtual void onPassphraseUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PassphraseUpdate >& update);
		void vGluePassphraseGetRequest();
		void vGluePassphraseSetRequest(std::string passphrase);
		
		/* Powered -- Get Manual Implementation */
		virtual void onPoweredError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PoweredError >& error){}
		virtual void onPoweredUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PoweredUpdate >& update);
		void vGluePoweredGetRequest();
		void vGluePoweredSetRequest(bool powered);
		
		/*Hidden -- Get Manual Implementation */
		virtual void onHiddenError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::HiddenError >& error){}
	    virtual void onHiddenUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
	    const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::HiddenUpdate >& update);
		void vGlueHiddenGetRequest();
		void vGlueHiddenSetRequest(bool hidden);
		
		/*CurrentOperatingChannel -- Get Manual Implementation */
		virtual void onCurrentOperatingChannelError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelError >& error){}
		virtual void onCurrentOperatingChannelUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelUpdate >& update);
		void vGlueCurrentOperatingChannelGetRequest();
		
		/*VendorIEs -- Get Manual Implementation */
		virtual void onVendorIEsError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::VendorIEsError >& error){}
		virtual void onVendorIEsUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::VendorIEsUpdate >& update);
		void vGlueVendorIEsGetRequest();
		
		/*PowerState -- Get Functionality Manually Added */
		virtual void onPowerStateError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PowerStateError >& error){}
		virtual void onPowerStateUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PowerStateUpdate >& update);
		void vGluePowerStateGetRequest();
		
		/*PowerFailureReason -- Get Functionality Manually Added */
		virtual void onPowerFailureReasonError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PowerFailureReasonError >& error){}
		virtual void onPowerFailureReasonUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PowerFailureReasonUpdate >& update);
		void vGluePowerFailureReasonGetRequest();
		
		/*CurrentHwMode -- Get Functionality Manually Added */
		virtual void onCurrentHwModeError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::CurrentHwModeError >& error){}
		virtual void onCurrentHwModeUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::CurrentHwModeUpdate >& update);
		void vGlueCurrentHwModeGetRequest();
		
		/*MaximumStationsAllowed -- Get Functionality Manually Added */
		virtual void onMaximumStationsAllowedError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedError >& error){}
		virtual void onMaximumStationsAllowedUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedUpdate >& update);
		void vGlueMaximumStationsAllowedGetRequest();
		
		/*SupportedChannels -- Get Functionality Manually Added */
		virtual void onSupportedChannelsError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SupportedChannelsError >& error){}
		virtual void onSupportedChannelsUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SupportedChannelsUpdate >& update);
		void vGlueSupportedChannelsGetRequest();
		
		/*HWFeatures -- Get Functionality Manually Added */
		virtual void onHWFeaturesError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::HWFeaturesError >& error){}
		virtual void onHWFeaturesUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::HWFeaturesUpdate >& update);
		void vGlueHWFeaturesGetRequest();
		
		/*GetAccessPoints*/
		virtual void onGetAccessPointsError(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::GetAccessPointsError >& error)
		{}
		virtual void onGetAccessPointsResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::GetAccessPointsResponse >& response);
		void vGlueGetAccessPointsRequest();
		
		/*AccessPointAdded*/
		virtual void onAccessPointAddedSignal(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::AccessPointAddedSignal >& signal);
		virtual void onAccessPointAddedError(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::AccessPointAddedError >& error){}
		
		/*AccessPointRemoved*/
		virtual void onAccessPointRemovedError(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::AccessPointRemovedError >& error){}
		virtual void onAccessPointRemovedSignal(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::AccessPointRemovedSignal >& signal);
		
		/*RegisterAgent*/
		virtual void onRegisterAgentError(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::RegisterAgentError >& error){}
		virtual void onRegisterAgentResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::RegisterAgentResponse >& response);
		void vGlueRegisterAgentRequest(std::string path);

		/*UnregisterAgent*/
		virtual void onUnregisterAgentError(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::UnregisterAgentError >& error){}
		virtual void onUnregisterAgentResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::UnregisterAgentResponse >& response);
		void vGlueUnregisterAgentRequest(std::string path);
		
		/*FindAccessPoint*/
		virtual void onFindAccessPointError(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::FindAccessPointError >& error);
		virtual void onFindAccessPointResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::FindAccessPointResponse >& response);
		void vGlueFindAccessPointRequest(std::string pattern);
		
		virtual void onGetError(const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::PropertiesProxy >& proxy, 
		const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::GetError >& error) {}
		virtual void onGetResponse(const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::PropertiesProxy >& proxy, 
		const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::GetResponse >& response){}
		void vGlueGetRequest(std::string interface_name,std::string property_name);
		
		/* MacAddress - Associated Stations -- Get Functionality Manually Added */
		virtual void onMacAddressError(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::MacAddressError >& error){}
		virtual void onMacAddressUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::MacAddressUpdate >& update);
	    void vGlueMacAddressAsGetRequest();
		
		/* Accesspoint - Associated Stations -- Get Functionality Manually Added */
		virtual void onAccesspointError(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AccesspointError >& error){}
		virtual void onAccesspointUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AccesspointUpdate >& update);
		void vGlueAccesspointAsGetRequest();
		
		/* Interface - Associated Stations -- Get Functionality Manually Added */
		virtual void onInterfaceError(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::InterfaceError >& error){}
		virtual void onInterfaceUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::InterfaceUpdate >& update);;
		void vGlueInterfaceAsGetRequest();
		
		/* IPAddress - Associated Stations -- Get Functionality Manually Added */
		virtual void onIPAddressError(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::IPAddressError >& error){}
		virtual void onIPAddressUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::IPAddressUpdate >& update);
		void vGlueIPAddressAsGetRequest();
		
		/* Hostname - Associated Stations -- Get Functionality Manually Added */
		virtual void onHostnameError(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::HostnameError >& error){}
		virtual void onHostnameUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::HostnameUpdate >& update);
		void vGlueHostnameAsGetRequest();
		
		
		
		
		
		void* getDbusIterValue(DBusMessageIter*);
		void* getMemAlloc(size_t size);
		
	};
	/*}}*/
	/*K7*/
	//namespace PropertiesProxy {
	//namespace ClientProxy {
	class WapdmanClientComponentProperties : public BaseComponent,ServiceAvailableIF,GetCallbackIF,PropertiesChangedCallbackIF,SetCallbackIF
	{
	private:
		DECLARE_CLASS_LOGGER ();
		::boost::shared_ptr<PropertiesProxy> m_poPropertiesProxy;
		static WapdmanClientComponentProperties* m_poWapdmanClientComponentProperties;	
	public:
	
		WapdmanClientComponentProperties():
		BaseComponent(),
		m_poPropertiesProxy(::org::freedesktop::DBus::Properties::PropertiesProxy::createProxy("propertiesPort",
				"org.freedesktop.DBus.Properties",
				"/org/freedesktop/DBus/Properties", DBUS_BUS_SESSION, *this))
		{
		LOG_INFO("Properties server started");
		}
	
		virtual ~WapdmanClientComponentProperties() {}
		static WapdmanClientComponentProperties& rfGetClientComponentPropertiesInstance();
		// ServiceAvailableIF implementation
		virtual void onAvailable(const boost::shared_ptr<PropertiesProxy>& proxy, const ServiceStateChange &stateChange) 
		{
		LOG_INFO("onAvailable, proxy %p is connected", &proxy);
		if ( m_poPropertiesProxy == proxy) 
		{
			LOG_DEBUG("m_poPropertiesProxy available");
			m_poPropertiesProxy->sendPropertiesChangedRegister(*this);
		}
		}
		virtual void onUnavailable(const boost::shared_ptr<PropertiesProxy>& proxy, const ServiceStateChange &stateChange) 
		{
		m_poPropertiesProxy->sendPropertiesChangedDeregisterAll();
		}
		// GetCallbackIF implementation
		/*virtual void onGetResponse(const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::PropertiesProxy >& proxy, 
		const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::GetResponse >& response);*/
		/*{
			LOG_INFO("Received onGetResponse=\"%s\"", response->getMessage().c_str());
		}*/
		//virtual void onGetError(const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::PropertiesProxy >& proxy, const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::GetError >& error);
		/*{
		LOG_ERROR("Received onGetResponse");
		}*/
		//void vGlueGetRequest(std::string interface_name,std::string property_name);
		// PropertiesChangedCallbackIF implementation
		/*virtual void onPropertiesChangedSignal(const boost::shared_ptr<PropertiesProxy>& proxy,
		const ::boost::shared_ptr< PropertiesChangedSignal >& signal) {
		LOG_INFO("Received onPropertiesChangedSignal, message=\"%s\"", signal->getMessage().c_str());
		}
		virtual void onPropertiesChangedError(const ::boost::shared_ptr< PropertiesProxy >& proxy, 
		const ::boost::shared_ptr< PropertiesChangedError >& error) {
		LOG_ERROR("Received onPropertiesChangedError");
		}*/
	
		void vGluegetSSIDRequest();
		virtual void onPropertiesChangedSignal(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< PropertiesChangedSignal >& signal);
		/*void vParseAccessPointInfo(const ::std::string& busName,
		const ::std::string& objPath, const ::DBusBusType busType, const ::std::string& interfaceName,
		::std::map< ::std::string, ::asf::dbus::DBusVariant >& data, AccessPointProperty& property)*/
	    void* getDbusIterValue(DBusMessageIter*);
		void* getMemAlloc(size_t size);
	};
}
}