/**
 * @file WapdmanClientComponent.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief 
 *
 * @{
 */
 
#include "WapdmanServerComponent.h"
#include "WapdmanClientComponent.h"

namespace Proxy 
{
namespace client { 

	using namespace ::Stub::server;
	using namespace ::Stub::WapdmanService;
	using namespace ::org::bosch::wapdman::Accesspoint;
	using namespace ::org::bosch::wapdman::Manager;
	using namespace ::org::bosch::wapdman::AssociatedStation;
	using namespace ::org::bosch::wapdman::Accesspoint::TetheringSettings;
	using namespace ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration;
	//using namespace ::org::freedesktop::DBus::Properties;
	
	WapdmanClientComponent* WapdmanClientComponent::m_poWapdmanClientComponent=NULL;

	DEFINE_CLASS_LOGGER_AND_LEVEL ("Proxy/client", WapdmanClientComponent, Info);
	DEFINE_CLASS_LOGGER_AND_LEVEL ("Proxy/client", WapdmanClientComponentProperties, Info);
	
	WapdmanClientComponent::~WapdmanClientComponent() 
	{
		LOG_INFO("WapdmanClientComponent::Destructor");
		delete m_poWapdmanClientComponent;
		m_poWapdmanClientComponent = NULL;
	}
	
	WapdmanClientComponent& WapdmanClientComponent::rfGetClientComponentInstance()
	{
		return *m_poWapdmanClientComponent;
	}
	
	void WapdmanClientComponent::onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& sysChange)
	{
		(void)proxy;
		(void)sysChange;
		
		if(m_poAPProxy)
		{
		LOG_INFO("WIFI m_poAPProxy IS CONNECTED AND AVAILABLE");
		m_poAPProxy->sendSSIDRegister(*this);
		m_poAPProxy->sendSecurityRegister(*this);
		m_poAPProxy->sendMacAddressRegister(*this);
		m_poAPProxy->sendInterfaceRegister(*this);
		m_poAPProxy->sendPassphraseRegister(*this);
		m_poAPProxy->sendPoweredRegister(*this);
		m_poAPProxy->sendHiddenRegister(*this);
		m_poAPProxy->sendCurrentOperatingChannelRegister(*this);
		m_poAPProxy->sendVendorIEsRegister(*this);
		m_poAPProxy->sendAssociatedStationsChangedRegister(*this);
		m_poAPProxy->sendPowerStateRegister(*this);
		m_poAPProxy->sendPowerFailureReasonRegister(*this);
		m_poAPProxy->sendCurrentHwModeRegister(*this);
		m_poAPProxy->sendMaximumStationsAllowedRegister(*this);
		m_poAPProxy->sendSupportedChannelsRegister(*this);
		m_poAPProxy->sendHWFeaturesRegister(*this);
		}
		else
		{
		LOG_INFO("WIFI m_poAPProxy DOESNOT EXIST");
		}
		if(m_poMGRProxy)
		{
		LOG_INFO("WIFI ManagerProxy IS CONNECTED AND AVAILABLE");
		m_poMGRProxy->sendAccessPointAddedRegister(*this);
		m_poMGRProxy->sendAccessPointRemovedRegister(*this);
		
		}
		else
		{
		LOG_INFO("WIFI ManagerProxy DOESNOT EXIST");
		}
		if(m_poASProxy)
		{
		LOG_INFO("WIFI m_poASProxy IS CONNECTED AND AVAILABLE");
		m_poASProxy->sendMacAddressRegister(*this);
		m_poASProxy->sendAccesspointRegister(*this);
		m_poASProxy->sendInterfaceRegister(*this);
		m_poASProxy->sendIPAddressRegister(*this);
		m_poASProxy->sendHostnameRegister(*this);
		}
		else
		{
		LOG_INFO("WIFI m_poASProxy DOESNOT EXIST");
		}
		/*if(m_poPropertiesProxyy)
		{
			LOG_INFO("m_poPropertiesProxyy is available");
		}
		else
		{
			LOG_INFO("m_poPropertiesProxyy Not Available");
		}*/
		if(m_poTSProxy)
		{
		LOG_INFO("WIFI TetheringSettings Proxy IS CONNECTED AND AVAILABLE");
		m_poTSProxy->sendTetheringRegister(*this);	
		}
		else
		{
		LOG_INFO("WIFI m_poTSProxy DOESNOT EXIST");	
		}
		if(m_poDCProxy)
		{
		LOG_INFO("WIFI DHCPDNSConfiguration Proxy IS CONNECTED AND AVAILABLE");
		m_poDCProxy->sendIPv4PoolRegister(*this);	
		}
		else
		{
		LOG_INFO("WIFI m_poDCProxy DOESNOT EXIST");	
		}
	}
	void WapdmanClientComponent::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& sysChange)
	{
		(void)proxy;
		(void)sysChange;
		if(m_poAPProxy)
		{
		LOG_INFO("WIFI m_poAPProxy sendSSIDDeregister IS CONNECTED AND AVAILABLE");
		m_poAPProxy->sendSSIDDeregister(0);
		m_poAPProxy->sendSecurityDeregister(0);
		m_poAPProxy->sendMacAddressDeregister(0);
		m_poAPProxy->sendInterfaceDeregister(0);
		m_poAPProxy->sendPassphraseDeregister(0);
		m_poAPProxy->sendPoweredDeregister(0);
		m_poAPProxy->sendHiddenDeregister(0);
		m_poAPProxy->sendCurrentOperatingChannelDeregister(0);
		m_poAPProxy->sendVendorIEsDeregister(0);
		m_poAPProxy->sendAssociatedStationsChangedDeregister(0);
		m_poAPProxy->sendPowerStateDeregister(0);
		m_poAPProxy->sendPowerFailureReasonDeregister(0);
		m_poAPProxy->sendCurrentHwModeDeregister(0);
		m_poAPProxy->sendMaximumStationsAllowedDeregister(0);
		m_poAPProxy->sendSupportedChannelsDeregister(0);
		m_poAPProxy->sendHWFeaturesDeregister(0);
		}
		else
		{
		LOG_INFO("WIFI m_poAPProxy sendSSIDDeregister DOESNOT EXIST");
		}
		
		if(m_poMGRProxy)
		{
		LOG_INFO("WIFI ManagerProxy IS Dis-CONNECTED AND NOT-AVAILABLE");
		m_poMGRProxy->sendAccessPointAddedDeregister(0);
		m_poMGRProxy->sendAccessPointRemovedDeregister(0);
		}
		else
		{
		LOG_INFO("WIFI ManagerProxy DOESNOT EXIST");
		}
		if(m_poASProxy)
		{
		LOG_INFO("WIFI m_poASProxy IS Dis-CONNECTED AND Not-AVAILABLE");
		m_poASProxy->sendMacAddressDeregister(0);
		m_poASProxy->sendAccesspointDeregister(0);
		m_poASProxy->sendInterfaceDeregister(0);
		m_poASProxy->sendIPAddressDeregister(0);
		m_poASProxy->sendHostnameDeregister(0);
		}
		else
		{
		LOG_INFO("WIFI m_poASProxy DOESNOT EXIST");
		}
		/*if(m_poPropertiesProxyy)
		{
			LOG_INFO("m_poPropertiesProxyy is available");
		}
		else
		{
			LOG_INFO("m_poPropertiesProxyy Not Available");
		}*/
		if(m_poTSProxy)
		{
		LOG_INFO("WIFI TetheringSettings Proxy IS Dis-CONNECTED AND Not-AVAILABLE");
		m_poTSProxy->sendTetheringDeregister(0);	
		}
		else
		{
		LOG_INFO("WIFI m_poTSProxy DOESNOT EXIST");	
		}
		if(m_poDCProxy)
		{
		LOG_INFO("WIFI DHCPDNSConfiguration Proxy IS CONNECTED AND AVAILABLE");
		m_poDCProxy->sendIPv4PoolDeregister(0);	
		}
		else
		{
		LOG_INFO("WIFI m_poDCProxy DOESNOT EXIST");	
		}
	}
	
	void WapdmanClientComponent::onSetSSIDResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SetSSIDResponse >& out)
	{
		(void)proxy;//solving lint
		if(out)
		{
			
			uint32 _act=out->getAct();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonSetSSIDResponse(_act);
		}
		else
		{
			LOG_INFO("OUT IS NULL");
		}
	}
	
		
	
	void WapdmanClientComponent::vGlueSetSSIDRequest(std::vector<uint8> ssid,bool utf8ssid)
	{
		LOG_INFO("WapdmanClientComponent::vGlueSetSSIDRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poAPProxy->sendSetSSIDRequest(*this,ssid,utf8ssid);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}

	/* DeAuthenticateStation */
	
	void WapdmanClientComponent::onDeAuthenticateStationResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationResponse >& out)
	{
		(void)proxy;//solving lint
		if(out)
		{
			
			uint32 _act=out->getAct();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonDeAuthenticateStationResponse(_act);
		}
		else
		{
			LOG_INFO("OUT IS NULL");
		}
	}
	
	void WapdmanClientComponent::onDeAuthenticateStationError(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationError >& error)
	{
		LOG_INFO("WapdmanClientComponent::onDeAuthenticateStationError Received");
		(void)proxy;//solving lint
		if(error)
		{
			LOG_INFO("WapdmanClientComponent::onDeAuthenticateStationError Received");
			uint32 _act=error->getAct();
			//std::string deauthenticateerror = (*it).getElem1();
		    //WapdmanServerComponent::rfGetServerInstance().vGlueonBlacklistStationResponse(_act);
			
		}
		else
		{
			LOG_INFO("error::onDeAuthenticateStationError IS NULL");
		}
	}
	
	void WapdmanClientComponent::vGlueDeAuthenticateStationRequest(std::string address)
	{
		LOG_INFO("WapdmanClientComponent::vGlueDeAuthenticateStationRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poAPProxy->sendDeAuthenticateStationRequest(*this,address);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}
	
	/* BlacklistStation */

	void WapdmanClientComponent::onBlacklistStationResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::BlacklistStationResponse >& out)
	{
		(void)proxy;//solving lint
		if(out)
		{
			
			uint32 _act=out->getAct();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonBlacklistStationResponse(_act);
		}
		else
		{
			LOG_INFO("OUT IS NULL");
		}
	}
	
		
	
	void WapdmanClientComponent::vGlueBlacklistStationRequest(std::string address,bool allow)
	{
		LOG_INFO("WapdmanClientComponent::vGlueBlacklistStationRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poAPProxy->sendBlacklistStationRequest(*this,address,allow);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}	

	/* SetOperatingChannels */
	
	void WapdmanClientComponent::onSetOperatingChannelsResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsResponse >& out)
	{
		(void)proxy;//solving lint
		if(out)
		{
			
			uint32 _act=out->getAct();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonSetOperatingChannelsResponse(_act);
		}
		else
		{
			LOG_INFO("OUT IS NULL");
		}
	}
	
		
	
	void WapdmanClientComponent::vGlueSetOperatingChannelsRequest(std::vector<uint16> channels)
	{
		LOG_INFO("WapdmanClientComponent::vGlueSetOperatingChannelsRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poAPProxy->sendSetOperatingChannelsRequest(*this,channels);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}	
	
	/* StartWPSPushButton */
	
	void WapdmanClientComponent::onStartWPSPushButtonResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::StartWPSPushButtonResponse >& out)
	{
		(void)proxy;//solving lint
		if(out)
		{
			
			uint32 _act=out->getAct();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonStartWPSPushButtonResponse(_act);
		}
		else
		{
			LOG_INFO("OUT IS NULL");
		}
	}
	
		
	void WapdmanClientComponent::vGlueStartWPSPushButtonRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueStartWPSPushButtonRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poAPProxy->sendStartWPSPushButtonRequest(*this);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}

	/* CancelWPS */
	
	void WapdmanClientComponent::onCancelWPSResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::CancelWPSResponse >& out)
	{
		(void)proxy;//solving lint
		if(out)
		{
			
			uint32 _act=out->getAct();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonCancelWPSResponse(_act);
		}
		else
		{
			LOG_INFO("OUT IS NULL");
		}
	}
	
		
	void WapdmanClientComponent::vGlueCancelWPSRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueCancelWPSRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poAPProxy->sendCancelWPSRequest(*this);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}
	
	/*RegisterVendorService*/
	void WapdmanClientComponent::onRegisterVendorServiceResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceResponse >& response)
	{
		(void)proxy;//solving lint
		if(response)
		{
			LOG_INFO("WapdmanClientComponent::onRegisterVendorServiceResponse Entered");
			//uint32 _act=out->getAct();
		    //WapdmanServerComponent::rfGetServerInstance().vGlueonCancelWPSResponse(_act);
		}
		else
		{
			LOG_INFO("response for onRegisterVendorServiceResponse IS NULL");
		}		
	}
	
	void WapdmanClientComponent::vGlueRegisterVendorServiceRequest(std::vector < std::vector <uint8> > IEss)
	{
		LOG_INFO("WapdmanClientComponent::vGlueRegisterVendorServiceRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poAPProxy->sendRegisterVendorServiceRequest(*this,IEss);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}
	
	
	/*UnregisterVendorService*/
	void WapdmanClientComponent::onUnregisterVendorServiceResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceResponse >& response)
	{
		(void)proxy;//solving lint
		if(response)
		{
			LOG_INFO("WapdmanClientComponent::onUnregisterVendorServiceResponse Entered");
			//uint32 _act=out->getAct();
		    //WapdmanServerComponent::rfGetServerInstance().vGlueonCancelWPSResponse(_act);
		}
		else
		{
			LOG_INFO("response for onUnregisterVendorServiceResponse IS NULL");
		}		
	}
	
	void WapdmanClientComponent::vGlueUnregisterVendorServiceRequest(std::vector < std::vector <uint8> > IEss)
	{
		LOG_INFO("WapdmanClientComponent::vGlueUnregisterVendorServiceRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poAPProxy->sendUnregisterVendorServiceRequest(*this,IEss);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}
	
	
	/*GetAssociatedStations*/
	void WapdmanClientComponent::vGlueGetAssociatedStationsRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueGetAssociatedStationsRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("m_poAPProxy PROXY EXISTS in GetAssociatedStations");
			m_poAPProxy->sendGetAssociatedStationsRequest(*this);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}
	
    void WapdmanClientComponent::onGetAssociatedStationsResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		 const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponse >& response)
	{
		(void)proxy;//solving lint
		if(response)
		{
		LOG_INFO("WapdmanClientComponent::onGetAssociatedStationsResponse");
		uint32 _act=response->getAct();
		typedef ::std::vector< ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct > ASStructList;
        ASStructList asStructList = response->getAssociatedstations();
		::std::vector< ::Stub::WapdmanServiceTypes::StructASList > asList;
		for (ASStructList::iterator it = asStructList.begin(); it != asStructList.end(); ++it)
		{
		LOG_INFO("WapdmanClientComponent::onGetAssociatedStationsResponse1");
		std::string asObjPath = (*it).getElem1();
		LOG_INFO("WapdmanClientComponent::asObjPath %s",asObjPath.c_str());
		m_poASProxy = ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy::createProxy("asPort","org.bosch.wapdman",asObjPath, DBUS_BUS_SYSTEM,*this);
		if(m_poASProxy)
		{
			LOG_INFO("m_poASProxy PROXY EXISTS when onGetAssociatedStationsResponse is available");
		}
		else
		{
			LOG_INFO("m_poASProxy Invalid Proxy in the onGetAssociatedStationsResponse function");
		}
		StructASList *value1 = new StructASList();
		value1->setObjPath((*it).getElem1());
		typedef ::std::map< ::std::string, ::asf::dbus::DBusVariant > ApData;
		ApData apData = it->getElem2();

		asf::dbus::DBusVariant valVariant;
		for (ApData::iterator it = apData.begin(); it != apData.end(); ++it)
		{
			LOG_INFO("WapdmanClientComponent::onGetAssociatedStationsResponse2");
			valVariant = it->second;
			DBusMessageIter* valIter = valVariant.getReadIterator();
			if (!strcmp(it->first.c_str(), "Accesspoint"))
				{
				char *value = (char*)getDbusIterValue(valIter);
				std::string accesspoint = value;
				LOG_INFO("Accesspoint is %s",accesspoint.c_str());
				value1->setAccesspoint(accesspoint);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "MacAddress"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string MAC = value;
				 LOG_INFO("MAC is %s",MAC.c_str());
				 value1->setMacAddress(MAC);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "Interface"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string Interfacee = value;
				 LOG_INFO("Interfacee is %s",Interfacee.c_str());
				 value1->setInterface(Interfacee);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "IPAddress"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string IPAddress = value;
				 LOG_INFO("IPAddress is %s",IPAddress.c_str());
				 value1->setIPAddress(IPAddress);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "Hostname"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string Hostname = value;
				 LOG_INFO("Hostname is %s",Hostname.c_str());
				 value1->setHostname(Hostname);
				//apList.push_back(*value1);
				}
			}		
		asList.push_back(*value1);
		}		
		WapdmanServerComponent::rfGetServerInstance().vGlueonGetAssociatedStationsResponse(asList);
		}
		else
		{
			LOG_INFO("response IS NULL");
		}
	}
	
	/*AssociatedStationsChangedSignal*/
	void WapdmanClientComponent::onAssociatedStationsChangedSignal(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignal >& signal)
	{
		LOG_INFO("WapdmanClientComponent::onAssociatedStationsChangedSignal Signal Case Entered");
		(void)proxy;//solving lint
		if(signal)
		{
		LOG_INFO("WapdmanClientComponent::onGetAssociatedStationsResponse");
		uint32 _act=signal->getAct();
		typedef ::std::vector< ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct > ASChangedSignalList;
		ASChangedSignalList aSChangedSignalList = signal->getChangedstations();
		::std::vector< ::std::string > aSRemovedSignalList = signal->getRemovedstations();
		
		::std::vector< ::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged > asList;
		StructAssociatedStationsChanged *value1 = new StructAssociatedStationsChanged();
		
		//::std::vector< ::std::string > ASRemovedSignalList = signal->getRemovedstations();
		//::Stub::WapdmanServiceTypes::structrmvdstations
		//if(!(aSRemovedSignalList))
		//{
		//value1->setObjPath(ASRemovedSignalList);
		//asList.push_back(ASRemovedSignalList);
		//}
		/*if (!ASRemovedSignalList.empty())
		{
			LOG_INFO("WapdmanClientComponent::ASRemovedSignalList is not Emmmpty :::");
			for(std::vector< std::string >::const_iterator i=ASRemovedSignalList.begin(); i !=ASRemovedSignalList.end(); ++i)
			{
			LOG_INFO("Value is %d",i);
			value1->setRobjPath(*i);
			asList.push_back(*value1);
			}
		}*/
	
		::std::vector< ::std::string >::iterator itt;
		for (itt = aSRemovedSignalList.begin(); itt != aSRemovedSignalList.end(); ++itt)
		{
			LOG_INFO("WapdmanClientComponent::onGetASRemovedSignalList");
			LOG_INFO("Value is %d",itt);
			value1->setObjPath(*itt);
			asList.push_back(*value1);
		}
		
		
		
		for (ASChangedSignalList::iterator it = aSChangedSignalList.begin(); it != aSChangedSignalList.end(); ++it)
		{
		LOG_INFO("WapdmanClientComponent::onGetAssociatedStationsResponse1");
		std::string asObjPath = (*it).getElem1();
		LOG_INFO("WapdmanClientComponent::asObjPath %s",asObjPath.c_str());
		/*m_poASProxy = ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy::createProxy("asPort","org.bosch.wapdman",asObjPath, DBUS_BUS_SYSTEM,*this);
		if(m_poASProxy)
		{
			LOG_INFO("m_poASProxy PROXY EXISTS when onGetAssociatedStationsResponse is available");
		}
		else
		{
			LOG_INFO("m_poASProxy Invalid Proxy in the onGetAssociatedStationsResponse function");
		}*/
		//StructAssociatedStationsChanged *value1 = new StructAssociatedStationsChanged();
		value1->setObjPath((*it).getElem1());
		typedef ::std::map< ::std::string, ::asf::dbus::DBusVariant > ApData;
		ApData apData = it->getElem2();

		asf::dbus::DBusVariant valVariant;
		for (ApData::iterator it = apData.begin(); it != apData.end(); ++it)
			{
			LOG_INFO("WapdmanClientComponent::onAssociatedStationsChangedSignal2");
			valVariant = it->second;
			DBusMessageIter* valIter = valVariant.getReadIterator();
			if (!strcmp(it->first.c_str(), "Accesspoint"))
				{
				char *value = (char*)getDbusIterValue(valIter);
				std::string accesspoint = value;
				LOG_INFO("Accesspoint is %s",accesspoint.c_str());
				value1->setAccesspoint(accesspoint);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "MacAddress"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string MAC = value;
				 LOG_INFO("MAC is %s",MAC.c_str());
				 value1->setMacAddress(MAC);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "Interface"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string Interfacee = value;
				 LOG_INFO("Interfacee is %s",Interfacee.c_str());
				 value1->setInterface(Interfacee);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "IPAddress"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string IPAddress = value;
				 LOG_INFO("IPAddress is %s",IPAddress.c_str());
				 value1->setIPAddress(IPAddress);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "Hostname"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string Hostname = value;
				 LOG_INFO("Hostname is %s",Hostname.c_str());
				 value1->setHostname(Hostname);
				//apList.push_back(*value1);
				}
			}		
		asList.push_back(*value1);
		}
				LOG_INFO("WapdmanClientComponent::vGlueonGetAssociatedStationsChangedSignalResponse Evaluation is Done on Client Side");
		::std::vector< ::Stub::WapdmanServiceTypes::StructAssociatedStationsChanged >::iterator it;
		for(it = asList.begin(); it != asList.end(); ++it)
		{
		LOG_INFO("WapdmanClientComponent::vGlueonGetAssociatedStationsChangedSignalResponse Iteration");
		std::string ObjectPath = it->getObjPath();
		LOG_INFO("ObjectPath %s",ObjectPath.c_str());
		std::string accesspoint = it->getAccesspoint();
		LOG_INFO("accesspoint %s",accesspoint.c_str());
		std::string MAC = it->getMacAddress();
		LOG_INFO("MAC %s",MAC.c_str());
		std::string interface = it->getInterface();
		LOG_INFO("interface %s",interface.c_str());
		std::string Ipaddress = it->getIPAddress();
		LOG_INFO("Ipaddress %s",Ipaddress.c_str());
		std::string Hostname = it->getHostname();
		LOG_INFO("Hostname %s",Hostname.c_str());
		//Send back the request to TML
		WapdmanServerComponent::rfGetServerInstance().sendAssociatedStationsChangedEvent(*it);
		}
		asList.clear();
		//WapdmanServerComponent::rfGetServerInstance().vGlueonGetAssociatedStationsResponse(asList);
		}
		else
		{
			LOG_INFO("response IS NULL");
		}
		

		
		
		
	}
	
	
	/*SSID -- Get Manual Implementation*/
	void WapdmanClientComponent::onSSIDUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SSIDUpdate >& update)
	{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onSSIDUpdate");
			uint32 _act=update->getAct();
			std::vector <uint8> SSID1 = update->getSSID();
		
		    WapdmanServerComponent::rfGetServerInstance().vGlueonSSIDGetResponse(SSID1,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
	}
	
	void WapdmanClientComponent::vGlueSSIDGetRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueSSIDGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poAPProxy->sendSSIDGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueSSIDGetRequest Invalid Proxy");
		}
	}
	
	/*Security -- Get Manual Implementation*/
	void WapdmanClientComponent::onSecurityUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy,
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SecurityUpdate >& update)
	{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onSecurityUpdate");
			uint32 _act=update->getAct();
			std::string security = update->getSecurity();
		
		    WapdmanServerComponent::rfGetServerInstance().vGlueonSecurityResponse(security,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
	}
	
	void WapdmanClientComponent::vGlueSecurityGetRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueSecurityGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueSecurityGetRequest");
			m_poAPProxy->sendSecurityGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueSecurityGetRequest Invalid Proxy");
		}
	}
	
	/*MacAddress -- Get Manual Implementation*/
	void WapdmanClientComponent::onMacAddressUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::MacAddressUpdate >& update)
	{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onMacAddressUpdate");
			uint32 _act=update->getAct();
			std::string macaddress = update->getMacAddress();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonMacAddressGetResponse(macaddress,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
	}
	
	void WapdmanClientComponent::vGlueMacAddressGetRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueMacAddressGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueMacAddressGetRequest");
			m_poAPProxy->sendMacAddressGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueMacAddressGetRequest Invalid Proxy");
		}
	}
	
	/*Interface -- Get Manual Implementation*/
	
	 void WapdmanClientComponent::onInterfaceUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::InterfaceUpdate >& update)
		{
			(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onInterfaceUpdate");
			uint32 _act=update->getAct();
			std::string interface = update->getInterface();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonInterfaceGetResponse(interface,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
		void WapdmanClientComponent::vGlueInterfaceGetRequest()
		{
			LOG_INFO("WapdmanClientComponent::vGlueInterfaceGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueInterfaceGetRequest");
			m_poAPProxy->sendInterfaceGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueInterfaceGetRequest Invalid Proxy");
		}
		}
	/*Passphrase -- Get Manual Implementation*/
	void WapdmanClientComponent::onPassphraseUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PassphraseUpdate >& update)
		{
			(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onPassphraseUpdate");
			uint32 _act=update->getAct();
			std::string passphrase = update->getPassphrase();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonPassphraseGetResponse(passphrase,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
	void WapdmanClientComponent::vGluePassphraseGetRequest()
		{
			LOG_INFO("WapdmanClientComponent::vGluePassphraseGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGluePassphraseGetRequest");
			m_poAPProxy->sendPassphraseGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGluePassphraseGetRequest Invalid Proxy");
		}
		}
	void WapdmanClientComponent::vGluePassphraseSetRequest(std::string passphrase)
	{
		LOG_INFO("WapdmanClientComponent::vGluePassphraseSetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGluePassphraseSetRequest");
			m_poAPProxy->sendPassphraseSet(passphrase);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGluePassphraseSetRequest Invalid Proxy");
		}
	}
	/*Powered -- Get Manual Implementation*/
	void WapdmanClientComponent::onPoweredUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PoweredUpdate >& update)
		{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onPoweredUpdate");
			uint32 _act=update->getAct();
			bool powered = update->getPowered();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonPoweredGetResponse(powered,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
		void WapdmanClientComponent::vGluePoweredGetRequest()
		{
		LOG_INFO("WapdmanClientComponent::vGluePoweredGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGluePoweredGetRequest");
			m_poAPProxy->sendPoweredGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGluePoweredGetRequest Invalid Proxy");
		}
		}
		
	void WapdmanClientComponent::vGluePoweredSetRequest(bool powered)
		{
		LOG_INFO("WapdmanClientComponent::vGluePoweredSetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGluePoweredSetRequest");
			m_poAPProxy->sendPoweredSet(powered);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGluePoweredSetRequest Invalid Proxy");
		}
		}
		
		
		
	/*Hidden -- Get Manual Implementation*/
	void WapdmanClientComponent::onHiddenUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
	    const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::HiddenUpdate >& update)
		{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onHiddenUpdate");
			uint32 _act=update->getAct();
			bool hidden = update->getHidden();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonHiddenGetResponse(hidden,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
		
	void WapdmanClientComponent::vGlueHiddenGetRequest(){
		LOG_INFO("WapdmanClientComponent::vGlueHiddenGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueHiddenGetRequest");
			m_poAPProxy->sendHiddenGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueHiddenGetRequest Invalid Proxy");
		}
		}
	void WapdmanClientComponent::vGlueHiddenSetRequest(bool hidden)
	{
		LOG_INFO("WapdmanClientComponent::vGlueHiddenSetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueHiddenSetRequest");
			m_poAPProxy->sendHiddenSet(hidden);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueHiddenSetRequest Invalid Proxy");
		}
	}
	/*CurrentOperatingChannel -- Get Manual Implementation*/
	void WapdmanClientComponent::onCurrentOperatingChannelUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelUpdate >& update)
		{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onCurrentOperatingChannelUpdate");
			uint32 _act=update->getAct();
			uint16 currentoperatingchannel = update->getCurrentOperatingChannel();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonCurrentOperatingChannelGetResponse(currentoperatingchannel,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
		void WapdmanClientComponent::vGlueCurrentOperatingChannelGetRequest()
		{
			LOG_INFO("WapdmanClientComponent::vGlueCurrentOperatingChannelGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueCurrentOperatingChannelGetRequest");
			m_poAPProxy->sendCurrentOperatingChannelGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueCurrentOperatingChannelGetRequest Invalid Proxy");
		}
		}

	/*VendorIEs -- Get Manual Implementation*/
	void WapdmanClientComponent::onVendorIEsUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::VendorIEsUpdate >& update)
		{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onVendorIEsUpdate");
			//uint32 _act=update->getAct();
			//uint16 currentoperatingchannel = update->getCurrentOperatingChannel();
		    //WapdmanServerComponent::rfGetServerInstance().vGlueonCurrentOperatingChannelGetResponse(currentoperatingchannel,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
	void WapdmanClientComponent::vGlueVendorIEsGetRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueVendorIEsGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueVendorIEsGetRequest");
			m_poAPProxy->sendVendorIEsGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueVendorIEsGetRequest Invalid Proxy");
		}
	}
	
	
	/*PowerState -- Get Functionality Manually Added */
	void WapdmanClientComponent::onPowerStateUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PowerStateUpdate >& update)
	{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onPowerStateUpdate");
			uint32 _act=update->getAct();
			std::string powerstate = update->getPowerState();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonPowerStateGetResponse(powerstate,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
	}
	void WapdmanClientComponent::vGluePowerStateGetRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGluePowerStateGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGluePowerStateGetRequest");
			m_poAPProxy->sendPowerStateGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGluePowerStateGetRequest Invalid Proxy");
		}
	}
		
	/*PowerFailureReason -- Get Functionality Manually Added */
	void WapdmanClientComponent::onPowerFailureReasonUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::PowerFailureReasonUpdate >& update)
	{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onPowerFailureReasonUpdate");
			uint32 _act=update->getAct();
			std::string powerfailurereason = update->getPowerFailureReason();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonPowerFailureReasonGetResponse(powerfailurereason,_act);
		}
		else
		{
			LOG_INFO("update onPowerFailureReasonUpdate IS NULL");
		}
	}
	void WapdmanClientComponent::vGluePowerFailureReasonGetRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGluePowerFailureReasonGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGluePowerFailureReasonGetRequest");
			m_poAPProxy->sendPowerFailureReasonGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGluePowerFailureReasonGetRequest Invalid Proxy");
		}	
	}
		
	/*CurrentHwMode -- Get Functionality Manually Added */
	void WapdmanClientComponent::onCurrentHwModeUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::CurrentHwModeUpdate >& update)
	{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onCurrentHwModeUpdate");
			uint32 _act=update->getAct();
			std::string currenthwmode = update->getCurrentHwMode();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonCurrentHwModeGetResponse(currenthwmode,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
	}
	void WapdmanClientComponent::vGlueCurrentHwModeGetRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueCurrentHwModeGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueCurrentHwModeGetRequest");
			m_poAPProxy->sendCurrentHwModeGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueCurrentHwModeGetRequest Invalid Proxy");
		}
	}
		
	/*MaximumStationsAllowed -- Get Functionality Manually Added */
	void WapdmanClientComponent::onMaximumStationsAllowedUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedUpdate >& update)
	{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onMaximumStationsAllowedUpdate");
			uint32 _act=update->getAct();
			uint16 maxstations = update->getMaximumStationsAllowed();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonMaximumStationsAllowedGetResponse(maxstations,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}	
	}
	
	void WapdmanClientComponent::vGlueMaximumStationsAllowedGetRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueMaximumStationsAllowedGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueMaximumStationsAllowedGetRequest");
			m_poAPProxy->sendMaximumStationsAllowedGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueMaximumStationsAllowedGetRequest Invalid Proxy");
		}
	}
	
	/*SupportedChannels -- Get Functionality Manually Added */
	void WapdmanClientComponent::onSupportedChannelsUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::SupportedChannelsUpdate >& update)
	{
		(void)proxy;//solving lint
		if(update)
		{
		LOG_INFO("WapdmanClientComponent::onSupportedChannelsUpdate");
		uint32 _act=update->getAct();
		::std::vector< ::Stub::WapdmanServiceTypes::SupportedChannelsList > supportedchannellist;
		SupportedChannelsList *value1 = new SupportedChannelsList();
		typedef ::std::map< ::std::string, ::asf::dbus::DBusVariant > ApData;
		ApData apData = update->getSupportedChannels();
		asf::dbus::DBusVariant valVariant;
		for (ApData::iterator it = apData.begin(); it != apData.end(); ++it)
		{
			LOG_INFO("WapdmanClientComponent::onSupportedChannelsUpdate for Each Items");
			valVariant = it->second;
			DBusMessageIter* valIter = valVariant.getReadIterator();
			if (!strcmp(it->first.c_str(), "channel 1"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel1 = *value;
				 LOG_INFO("Channel 1 is %d",channel1);
				 value1->setChannels1(channel1);
				}
			if (!strcmp(it->first.c_str(), "channel 2"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel2 = *value;
				 LOG_INFO("Channel 2 is %d",channel2);
				 value1->setChannels2(channel2);
				}
			if (!strcmp(it->first.c_str(), "channel 3"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel3 = *value;
				 LOG_INFO("Channel 3 is %d",channel3);
				 value1->setChannels3(channel3);
				}
			if (!strcmp(it->first.c_str(), "channel 4"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel4 = *value;
				 LOG_INFO("Channel 4 is %d",channel4);
				 value1->setChannels4(channel4);
				}
			if (!strcmp(it->first.c_str(), "channel 5"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel5 = *value;
				 value1->setChannels5(channel5);
				}
			if (!strcmp(it->first.c_str(), "channel 6"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel6 = *value;
				 value1->setChannels6(channel6);
				}
			if (!strcmp(it->first.c_str(), "channel 7"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel7 = *value;
				 value1->setChannels7(channel7);
				}
			if (!strcmp(it->first.c_str(), "channel 8"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel8 = *value;
				 value1->setChannels8(channel8);
				}
			if (!strcmp(it->first.c_str(), "channel 9"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel9 = *value;
				 value1->setChannels9(channel9);
				}
				if (!strcmp(it->first.c_str(), "channel 9"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel9 = *value;
				 value1->setChannels9(channel9);
				}
				if (!strcmp(it->first.c_str(), "channel 10"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel10 = *value;
				 value1->setChannels10(channel10);
				}
				if (!strcmp(it->first.c_str(), "channel 11"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel11 = *value;
				 value1->setChannels11(channel11);
				}
				if (!strcmp(it->first.c_str(), "channel 12"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel12 = *value;
				 value1->setChannels12(channel12);
				}
				if (!strcmp(it->first.c_str(), "channel 13"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel13 = *value;
				 value1->setChannels13(channel13);
				}
				if (!strcmp(it->first.c_str(), "channel 14"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel14 = *value;
				 value1->setChannels14(channel14);
				}
				if (!strcmp(it->first.c_str(), "channel 36"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel36 = *value;
				 value1->setChannels36(channel36);
				}
				if (!strcmp(it->first.c_str(), "channel 40"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel40 = *value;
				 value1->setChannels40(channel40);
				}
				if (!strcmp(it->first.c_str(), "channel 44"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel44 = *value;
				 value1->setChannels44(channel44);
				}
				if (!strcmp(it->first.c_str(), "channel 48"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel48 = *value;
				 value1->setChannels48(channel48);
				}
								if (!strcmp(it->first.c_str(), "channel 52"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel52 = *value;
				 value1->setChannels52(channel52);
				}
				if (!strcmp(it->first.c_str(), "channel 56"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel56 = *value;
				 value1->setChannels56(channel56);
				}
				if (!strcmp(it->first.c_str(), "channel 60"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel60 = *value;
				 value1->setChannels60(channel60);
				}

			if (!strcmp(it->first.c_str(), "channel 64"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel64 = *value;
				 LOG_INFO("Channel 64 is %d",channel64);
				 value1->setChannels64(channel64);
				}
			if (!strcmp(it->first.c_str(), "channel 100"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel100 = *value;
				 LOG_INFO("Channel 100 is %d",channel100);
				 value1->setChannels100(channel100);
				}
			if (!strcmp(it->first.c_str(), "channel 104"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel104 = *value;
				 LOG_INFO("Channel 104 is %d",channel104);
				 value1->setChannels104(channel104);
				}				
			if (!strcmp(it->first.c_str(), "channel 108"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel108 = *value;
				 LOG_INFO("Channel 108 is %d",channel108);
				 value1->setChannels108(channel108);
				}	
			if (!strcmp(it->first.c_str(), "channel 112"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel112 = *value;
				 LOG_INFO("Channel 112 is %d",channel112);
				 value1->setChannels112(channel112);
				}	
			if (!strcmp(it->first.c_str(), "channel 116"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel116 = *value;
				 LOG_INFO("Channel 116 is %d",channel116);
				 value1->setChannels116(channel116);
				}	
			if (!strcmp(it->first.c_str(), "channel 120"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel120 = *value;
				 LOG_INFO("Channel 120 is %d",channel120);
				 value1->setChannels120(channel120);
				}
			if (!strcmp(it->first.c_str(), "channel 124"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel124 = *value;
				 value1->setChannels124(channel124);
				}
			if (!strcmp(it->first.c_str(), "channel 128"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel128 = *value;
				 value1->setChannels128(channel128);
				}
			if (!strcmp(it->first.c_str(), "channel 132"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel132 = *value;
				 value1->setChannels132(channel132);
				}
			if (!strcmp(it->first.c_str(), "channel 136"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel136 = *value;
				 value1->setChannels136(channel136);
				}
								if (!strcmp(it->first.c_str(), "channel 140"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel140 = *value;
				 value1->setChannels140(channel140);
				}
								if (!strcmp(it->first.c_str(), "channel 144"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel144 = *value;
				 value1->setChannels144(channel144);
				}
								if (!strcmp(it->first.c_str(), "channel 149"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel149 = *value;
				 value1->setChannels149(channel149);
				}
								if (!strcmp(it->first.c_str(), "channel 153"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel153 = *value;
				 value1->setChannels153(channel153);
				}
								if (!strcmp(it->first.c_str(), "channel 157"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel157 = *value;
				 value1->setChannels157(channel157);
				}
								if (!strcmp(it->first.c_str(), "channel 161"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel161 = *value;
				 value1->setChannels161(channel161);
				}
								if (!strcmp(it->first.c_str(), "channel 165"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 channel165 = *value;
				 value1->setChannels165(channel165);
				}
				
		}	
			supportedchannellist.push_back(*value1);
		    WapdmanServerComponent::rfGetServerInstance().vGlueonSupportedChannelsGetResponse(supportedchannellist,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}	
	}
	void WapdmanClientComponent::vGlueSupportedChannelsGetRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueSupportedChannelsGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueSupportedChannelsGetRequest");
			m_poAPProxy->sendSupportedChannelsGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueSupportedChannelsGetRequest Invalid Proxy");
		}	
	}
	
	/*HWFeatures -- Get Functionality Manually Added */
	void WapdmanClientComponent::onHWFeaturesUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::AccesspointProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::HWFeaturesUpdate >& update)
	{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onHWFeaturesUpdate");
			uint32 _act=update->getAct();
			::std::vector< ::Stub::WapdmanServiceTypes::StructHWFeaturesList > hwfeaturelist;
			StructHWFeaturesList *value1 = new StructHWFeaturesList();
			typedef ::std::map< ::std::string, ::asf::dbus::DBusVariant > ApData;
			ApData apData = update->getHWFeatures();
			asf::dbus::DBusVariant valVariant;
			for (ApData::iterator it = apData.begin(); it != apData.end(); ++it)
			{
			LOG_INFO("WapdmanClientComponent::onHWFeaturesUpdate for Each Items");
			valVariant = it->second;
			DBusMessageIter* valIter = valVariant.getReadIterator();
			
			// Below Parsing to be Modified based on the DBUS_TYPE_ARRAY.... Need to check with Component Team
			
			if (!strcmp(it->first.c_str(), "Mode B"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 ModeB = *value;
				 LOG_INFO("ModeB is %d",ModeB);
				 value1->setModeB(ModeB);
				}
			if (!strcmp(it->first.c_str(), "Mode G"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 ModeG = *value;
				 LOG_INFO("ModeG is %d",ModeG);
				 value1->setModeG(ModeG);
				}			
			if (!strcmp(it->first.c_str(), "Mode A"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 ModeA = *value;
				 LOG_INFO("ModeA is %d",ModeA);
				 value1->setModeA(ModeA);
				}				
			}	
			hwfeaturelist.push_back(*value1);
		    WapdmanServerComponent::rfGetServerInstance().vGlueonHWFeaturesGetResponse(hwfeaturelist,_act);
		}
		else
		{
			LOG_INFO("onHWFeaturesUpdate IS NULL");
		}		
	}
	void WapdmanClientComponent::vGlueHWFeaturesGetRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueHWFeaturesGetRequest");
		if(m_poAPProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueHWFeaturesGetRequest");
			m_poAPProxy->sendHWFeaturesGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueHWFeaturesGetRequest Invalid Proxy");
		}	
	}
	
	/*RegisterAgent*/
	void WapdmanClientComponent::onRegisterAgentResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::RegisterAgentResponse >& response)
		{
		(void)proxy;//solving lint
		if(response)
		{
			uint32 _act=response->getAct();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonRegisterAgentResponse(_act);
		}
		else
		{
			LOG_INFO("response IS NULL");
		}
		}
	
	void WapdmanClientComponent::vGlueRegisterAgentRequest(std::string path)
		{
		LOG_INFO("WapdmanClientComponent::vGlueRegisterAgentRequest");
		if(m_poMGRProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poMGRProxy->sendRegisterAgentRequest(*this,path);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
		}
	
	/*UnregisterAgent*/
	void WapdmanClientComponent::onUnregisterAgentResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::UnregisterAgentResponse >& response)
		{
		(void)proxy;//solving lint
		if(response)
		{
			uint32 _act=response->getAct();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonUnregisterAgentResponse(_act);
		}
		else
		{
			LOG_INFO("response IS NULL");
		}
		}
	
	void WapdmanClientComponent::vGlueUnregisterAgentRequest(std::string path)
		{
		LOG_INFO("WapdmanClientComponent::vGlueUnregisterAgentRequest");
		if(m_poMGRProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poMGRProxy->sendUnregisterAgentRequest(*this,path);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
		}
	
	/*FindAccessPoint*/
	
	void WapdmanClientComponent::onFindAccessPointError(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::FindAccessPointError >& error)
		{
			LOG_INFO("WapdmanClientComponent::onFindAccessPointError Received.....");
		}
	
	void WapdmanClientComponent::onFindAccessPointResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::FindAccessPointResponse >& response)
		{
		(void)proxy;//solving lint
		if(response)
		{
			uint32 _act=response->getAct();
			std::string accesspoint = response->getAccesspoint();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonFindAccessPointResponse(accesspoint,_act);
		}
		else
		{
			LOG_INFO("response IS NULL");
		}
		}
	void WapdmanClientComponent::vGlueFindAccessPointRequest(std::string pattern)
		{
		LOG_INFO("WapdmanClientComponent::vGlueFindAccessPointRequest");
		if(m_poMGRProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poMGRProxy->sendFindAccessPointRequest(*this,pattern);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
		}
	
	/*AccessPointAdded*/
	
	void WapdmanClientComponent::onAccessPointAddedSignal(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
	const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::AccessPointAddedSignal >& signal)
		{ 
		(void)proxy;
		LOG_INFO("WapdmanClientComponent::onAccessPointAddedSignal");
		WapdmanServerComponent::rfGetServerInstance().vGlueonAccessPointAddedResponse(signal->getAccesspoint());	
		}
	
	/*AccessPointRemoved*/
	void WapdmanClientComponent::onAccessPointRemovedSignal(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::AccessPointRemovedSignal >& signal)
		{
		(void)proxy;
		LOG_INFO("WapdmanClientComponent::onAccessPointRemovedSignal");	
		WapdmanServerComponent::rfGetServerInstance().vGlueonAccessPointRemovedResponse(signal->getAccesspoint());
		}
		
		
		
/*GET*/

	/*void WapdmanClientComponent::onGetResponse(const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::PropertiesProxy >& proxy, 
	const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::GetResponse >& response)
	{
		//(void)proxy;//solving lint
		if(response)
		{
			LOG_INFO("WapdmanClientComponent::onGetResponse Received...... Success");
			uint32 _act=response->getAct();
		    //WapdmanServerComponent::rfGetServerInstance().vGlueonGetResponse(std::string(response->getValue()),_act);
		}
		else
		{
			LOG_INFO("response IS NULL");
		}
	}*/
	
	
		void WapdmanClientComponent::vGlueGetRequest(std::string interface_name,std::string property_name)
	{
		LOG_INFO("WapdmanClientComponent::vGlueGetRequest");
		::boost::shared_ptr< PropertiesProxy > propertiesProxy;
		propertiesProxy = PropertiesProxy::createProxy("propertiesPort","org.freedesktop.DBus.Properties","/org/bosch/wapdman/wlan1/AccessPoint_34_c7_31_ff_ea_dc", DBUS_BUS_SYSTEM, *this);
		if(propertiesProxy)
		{
			LOG_INFO("PROXY EXISTS");
			
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
		//m_poPropertiesProxyyy->createProxy("propertiesPort","org.freedesktop.DBus.Properties","/org/bosch/wapdman/wlan1/AccessPoint_34_c7_31_ff_ea_dc", DBUS_BUS_SYSTEM, *this);
     /* {

        LOG_INFO("WapdmanClientComponent::Constructor m_poPropertiesProxyyy->createProxy");
        m_poWapdmanClientComponent = this;
      }*/
		/*if(m_poPropertiesProxyyy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poPropertiesProxyyy->sendGetRequest(*this,interface_name,property_name);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}*/
	}
	
		/* GetAccessPoints */
	
	void WapdmanClientComponent::onGetAccessPointsResponse(const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::ManagerProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Manager::GetAccessPointsResponse >& response)
	{
		(void)proxy;//solving lint
		if(response)
		{
			LOG_INFO("WapdmanClientComponent::onGetAccessPointsResponse");
			uint32 _act=response->getAct();
			typedef ::std::vector< ::org::bosch::wapdman::Manager::GetAccessPointsResponseAccesspointsStruct > APStructList;
			   APStructList apStructList = response->getAccesspoints();
			   
		//K7
			::std::vector< ::Stub::WapdmanServiceTypes::StructAPList > apList;
			
		for (APStructList::iterator it = apStructList.begin(); it != apStructList.end(); ++it)
		{
			LOG_INFO("WapdmanClientComponent::onGetAccessPointsResponse1");
			std::string apObjPath = (*it).getElem1();
			//LOG_INFO("WapdmanClientComponent::apObjPath %s",apObjPath);
			m_poAPProxy = ::org::bosch::wapdman::Accesspoint::AccesspointProxy::createProxy("apPort","org.bosch.wapdman",apObjPath, DBUS_BUS_SYSTEM,*this);
			if(m_poAPProxy)
			{
				LOG_INFO("PROXY EXISTS");
			}
			else
			{
				LOG_INFO("Invalid Proxy");
			}
			StructAPList *value1 = new StructAPList();
			value1->setObjPath((*it).getElem1());
			//apList.push_back(*value1);
			typedef ::std::map< ::std::string, ::asf::dbus::DBusVariant > ApData;
			ApData apData = it->getElem2();

			asf::dbus::DBusVariant valVariant;
   
			for (ApData::iterator it = apData.begin(); it != apData.end(); ++it)
			{
			LOG_INFO("WapdmanClientComponent::onGetAccessPointsResponse2");
			valVariant = it->second;
			DBusMessageIter* valIter = valVariant.getReadIterator();
			if (!strcmp(it->first.c_str(), "Interface"))
				{
				char *value = (char*)getDbusIterValue(valIter);
				std::string interface = value;
				LOG_INFO("interface is %s",interface.c_str());
				value1->setInterface(interface);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "SSID"))
				{
				//std::vector <uint8> SSID1 = (void*)getDbusIterValue(valIter);
				/*for(std::vector<uint8>::const_iterator i=getDbusIterValue(valIter).begin(); i !=getDbusIterValue(valIter).end(); ++i)
				{
					LOG_INFO("Value is %d",*i);
				}*/
				char *value= (char*)getDbusIterValue(valIter);
				std::string ssid = value;
				LOG_INFO("ssid is %s",ssid.c_str());
				value1->setSSID(ssid);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "MacAddress"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string MAC = value;
				 LOG_INFO("MAC is %s",MAC.c_str());
				 value1->setAddress(MAC);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "Powered"))
				{
				 dbus_bool_t *value = (dbus_bool_t*)getDbusIterValue(valIter);
				 bool Poweredd = value;
				 LOG_INFO("Poweredd is %d",Poweredd);
				 value1->setPowered(Poweredd);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "PowerState"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string powerstate = value;
				 LOG_INFO("PowerState is %s",powerstate.c_str());
				 value1->setPowerState(powerstate);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "PowerFailureReason"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string powerfailurereason = value;
				 LOG_INFO("PowerFailureReason is %s",powerfailurereason.c_str());
				 value1->setPowerFailureReason(powerfailurereason);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "CurrentOperatingChannel"))
				{
				// char *value = (char*)getDbusIterValue(valIter);
				// std::string COP = value;
				// LOG_INFO("COP is %s",COP.c_str());
				// value1->setCurrentOperatingChannel(COP);
				//apList.push_back(*value1);
				
				dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				uint16 currentoperatingchannel = *value;
				LOG_INFO("CurrentOperatingChannel is %d",currentoperatingchannel);
				value1->setCurrentOperatingChannel(currentoperatingchannel);
				}
			if (!strcmp(it->first.c_str(), "CurrentHwMode"))
			{
				char *value = (char*)getDbusIterValue(valIter);
				std::string currenthwmode = value;
				LOG_INFO("CurrentHwMode is %s",currenthwmode.c_str());
				value1->setCurrentHwMode(currenthwmode);
				//apList.push_back(*value1);
			}
			/*if (!strcmp(it->first.c_str(), "HWFeatures"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string HWFeaturess = value;
				 LOG_INFO("HWFeatures is %s",HWFeaturess.c_str());
				 value1->setHWFeatures(HWFeaturess);
				//apList.push_back(*value1);
				}*/
			if (!strcmp(it->first.c_str(), "Hidden"))
				{
				 dbus_bool_t *value = (dbus_bool_t*)getDbusIterValue(valIter);
				 bool Hiddenn = value;
				 LOG_INFO("Hiddenn is %d",Hiddenn);
				 value1->setHidden(Hiddenn);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "MaximumStationsAllowed"))
				{
				 dbus_uint16_t *value = (dbus_uint16_t*)getDbusIterValue(valIter);
				 uint16 MaximumStationsAllowedd = *value;
				 LOG_INFO("MaximumStationsAllowedd is %d",MaximumStationsAllowedd);
				 value1->setMaximumStationsAllowed(MaximumStationsAllowedd);
				//apList.push_back(*value1);
				}
			if (!strcmp(it->first.c_str(), "Passphrase"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string Passphrasee = value;
				 LOG_INFO("Passphrasee is %s",Passphrasee.c_str());
				 value1->setPassphrase(Passphrasee);
				//apList.push_back(*value1);
				}

			if (!strcmp(it->first.c_str(), "Security"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string Securityy = value;
				 LOG_INFO("Securityy is %s",Securityy.c_str());
				 value1->setSecurity(Securityy);
				//apList.push_back(*value1);
				}
			/*if (!strcmp(it->first.c_str(), "SupportedChannels"))
				{
				 char *value = (char*)getDbusIterValue(valIter);
				 std::string SupportedChannelss = value;
				 LOG_INFO("SupportedChannelss is %s",SupportedChannelss.c_str());
				 value1->setSupportedChannels(SupportedChannelss);
				//apList.push_back(*value1);
				}*/
			}		
			
			apList.push_back(*value1);
			//string value = <::std::string>(response->getAccesspoints());
			//const std::vector<::org::bosch::wapdman::Manager::GetAccessPointsResponseAccesspointsStruct> value = (response->getAccesspoints());
		    //WapdmanServerComponent::rfGetServerInstance().vGlueonGetAccessPointsResponse(value,_act);
		}
		WapdmanServerComponent::rfGetServerInstance().vGlueonGetAccessPointsResponse(apList);
		}
		else
		{
			LOG_INFO("response IS NULL");
		}
	}
	
		
	void WapdmanClientComponent::vGlueGetAccessPointsRequest()
	{
		LOG_INFO("WapdmanClientComponent::vGlueGetAccessPointsRequest");
		if(m_poMGRProxy)
		{
			LOG_INFO("m_poMGRProxy PROXY EXISTS in GetAccessPoints");
			m_poMGRProxy->sendGetAccessPointsRequest(*this);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}
	
	
	/* MacAddress - Associated Stations -- Get Functionality Manually Added */
	void WapdmanClientComponent::onMacAddressUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::MacAddressUpdate >& update)
		{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onMacAddressUpdate Associated Stations MacAddress Update");
			uint32 _act=update->getAct();
			std::string macAddress = update->getMacAddress();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonMacAddressAsGetResponse(macAddress,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
	    void WapdmanClientComponent::vGlueMacAddressAsGetRequest()
		{
		LOG_INFO("WapdmanClientComponent::vGlueMacAddressAsGetRequest");
		if(m_poASProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueMacAddressAsGetRequest");
			m_poASProxy->sendMacAddressGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueMacAddressAsGetRequest Invalid Proxy");
		}
		}
		
		/* Accesspoint - Associated Stations -- Get Functionality Manually Added */
		
		 void WapdmanClientComponent::onAccesspointUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AccesspointUpdate >& update)
		{
			(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onAccesspointUpdate");
			uint32 _act=update->getAct();
			std::string accesspoint = update->getAccesspoint();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonAccesspointAsGetResponse(accesspoint,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
		void WapdmanClientComponent::vGlueAccesspointAsGetRequest()
		{
			LOG_INFO("WapdmanClientComponent::vGlueAccesspointAsGetRequest");
		if(m_poASProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueAccesspointAsGetRequest");
			m_poASProxy->sendAccesspointGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueAccesspointAsGetRequest Invalid Proxy");
		}
		}
		
		/* Interface - Associated Stations -- Get Functionality Manually Added */
		void WapdmanClientComponent::onInterfaceUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::InterfaceUpdate >& update)
		{
					(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onInterfaceUpdate AssociatedStation InterfaceUpdate");
			uint32 _act=update->getAct();
			std::string interface = update->getInterface();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonInterfaceAsGetResponse(interface,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
		void WapdmanClientComponent::vGlueInterfaceAsGetRequest()
		{
			LOG_INFO("WapdmanClientComponent::vGlueInterfaceAsGetRequest");
		if(m_poASProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueInterfaceAsGetRequest");
			m_poASProxy->sendInterfaceGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueInterfaceAsGetRequest Invalid Proxy");
		}
		}
		
		/* IPAddress - Associated Stations -- Get Functionality Manually Added */
		void WapdmanClientComponent::onIPAddressUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::IPAddressUpdate >& update)
		{
					(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onIPAddressUpdate");
			uint32 _act=update->getAct();
			std::string ipaddress = update->getIPAddress();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonIPAddressAsGetResponse(ipaddress,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
		void WapdmanClientComponent::vGlueIPAddressAsGetRequest()
		{
			LOG_INFO("WapdmanClientComponent::vGlueIPAddressAsGetRequest");
		if(m_poASProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueIPAddressAsGetRequest");
			m_poASProxy->sendIPAddressGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueIPAddressAsGetRequest Invalid Proxy");
		}
		}
		
		/* Hostname - Associated Stations -- Get Functionality Manually Added */
		void WapdmanClientComponent::onHostnameUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::AssociatedStationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::AssociatedStation::HostnameUpdate >& update)
		{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onHostnameUpdate");
			uint32 _act=update->getAct();
			std::string hostname = update->getHostname();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonHostnameAsGetResponse(hostname,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}
		}
		void WapdmanClientComponent::vGlueHostnameAsGetRequest()
		{
			LOG_INFO("WapdmanClientComponent::vGlueHostnameAsGetRequest");
		if(m_poASProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueHostnameAsGetRequest");
			m_poASProxy->sendHostnameGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueHostnameAsGetRequest Invalid Proxy");
		}
		}
	
		/* Accesspoint Tethering Properties */
		
		void WapdmanClientComponent::onTetheringUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringSettingsProxy >& proxy,
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringUpdate >& update)
		{
		(void)proxy;//solving lint
		if(update)
		{
			LOG_INFO("WapdmanClientComponent::onTetheringUpdate");
			uint32 _act=update->getAct();
			bool tethering = update->getTethering();
		    WapdmanServerComponent::rfGetServerInstance().vGlueonTetheringGetResponse(tethering,_act);
		}
			else
		{
			LOG_INFO("update IS NULL");
		}
		}
		void WapdmanClientComponent::vGlueTetheringGetRequest()
		{
		LOG_INFO("WapdmanClientComponent::vGlueTetheringGetRequest");
		if(m_poTSProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueTetheringGetRequest");
			m_poTSProxy->sendTetheringGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueTetheringGetRequest Invalid Proxy");
		}	
		}
		
		void WapdmanClientComponent::vGlueTetheringSetRequest(bool tethering)
	{
		LOG_INFO("WapdmanClientComponent::vGlueTetheringSetRequest");
		if(m_poTSProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueTetheringSetRequest");
			m_poTSProxy->sendTetheringSet(tethering);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueTetheringSetRequest Invalid Proxy");
		}
	}
		/*Accesspoint DHCPDNSConfiguration Properties*/
	
		void WapdmanClientComponent::onIPv4PoolUpdate(const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::DHCPDNSConfigurationProxy >& proxy, 
		const ::boost::shared_ptr< ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::IPv4PoolUpdate >& update)
		{
		(void)proxy;//solving lint
		if(update)
		{
		LOG_INFO("WapdmanClientComponent::onIPv4PoolUpdate");
		uint32 _act=update->getAct();
		::std::vector< ::Stub::WapdmanServiceTypes::StructIPv4List > structipv4list;
		StructIPv4List *value1 = new StructIPv4List();
		typedef ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > > ApData;
		ApData apData = update->getIPv4Pool();
		asf::dbus::DBusVariant valVariant;
		for (ApData::iterator itt = apData.begin(); itt != apData.end(); ++itt)
		{
			typedef ::std::map< ::std::string, ::asf::dbus::DBusVariant > IPv4Data;
			
			IPv4Data ipv4Data = (*itt);
			for(IPv4Data::iterator it = ipv4Data.begin(); it != ipv4Data.end(); ++it)
			{
			LOG_INFO("WapdmanClientComponent::onIPv4PoolUpdate for Each Items");
			valVariant = it->second;
			DBusMessageIter* valIter = valVariant.getReadIterator();
			if (!strcmp(it->first.c_str(), "start"))
				{
				char *value = (char*)getDbusIterValue(valIter);
				std::string startaddress = value;
				LOG_INFO("StartAddress is %s",startaddress.c_str());
				value1->setStart(startaddress);
				}
				if (!strcmp(it->first.c_str(), "end"))
				{
				char *value = (char*)getDbusIterValue(valIter);
				std::string endaddress = value;
				LOG_INFO("EndAddress is %s",endaddress.c_str());
				value1->setEnd(endaddress);
				}
				if (!strcmp(it->first.c_str(), "netmask"))
				{
				char *value = (char*)getDbusIterValue(valIter);
				std::string netmask = value;
				LOG_INFO("netmask is %s",netmask.c_str());
				value1->setNetmask(netmask);
				}
				if (!strcmp(it->first.c_str(), "network"))
				{
				char *value = (char*)getDbusIterValue(valIter);
				std::string network = value;
				LOG_INFO("Network IPV4 is %s",network.c_str());
				value1->setNetwork(network);
				}
				if (!strcmp(it->first.c_str(), "broadcast"))
				{
				char *value = (char*)getDbusIterValue(valIter);
				std::string broadcast = value;
				LOG_INFO("Broadcast is %s",broadcast.c_str());
				value1->setBroadcast(broadcast);
				}
				if (!strcmp(it->first.c_str(), "router"))
				{
				char *value = (char*)getDbusIterValue(valIter);
				std::string router = value;
				LOG_INFO("Router is %s",router.c_str());
				value1->setRouter(router);
				}
				if (!strcmp(it->first.c_str(), "leasetime"))
				{
				 dbus_uint32_t *value = (dbus_uint32_t*)getDbusIterValue(valIter);
				 uint32 leasetime = *value;
				 LOG_INFO("leasetime is %d",leasetime);
				 value1->setLeasetime(leasetime);
				}
			}
		}	
			structipv4list.push_back(*value1);
		    WapdmanServerComponent::rfGetServerInstance().vGlueonIPv4PoolGetResponse(structipv4list,_act);
		}
		else
		{
			LOG_INFO("update IS NULL");
		}	
		}
		void WapdmanClientComponent::vGlueIPv4PoolGetRequest()
		{
		LOG_INFO("WapdmanClientComponent::vGlueIPv4PoolGetRequest");
		if(m_poDCProxy)
		{
			LOG_INFO("PROXY EXISTS vGlueIPv4PoolGetRequest");
			m_poDCProxy->sendIPv4PoolGet(*this);
		}
		else
		{
			LOG_INFO("WapdmanClientComponent::vGlueIPv4PoolGetRequest Invalid Proxy");
		}	
		}
		
		
		
	
//}}

//K7
//namespace PropertiesProxy { namespace ClientProxy { 

	//using namespace ::Stub::server;
	//using namespace ::Stub::WapdmanService;
	//using namespace ::org::freedesktop::DBus::Properties;
	
	WapdmanClientComponentProperties* WapdmanClientComponentProperties::m_poWapdmanClientComponentProperties=NULL;

	//DEFINE_CLASS_LOGGER_AND_LEVEL ("PropertiesProxy/ClientProxy", WapdmanClientComponentProperties, Info);
	
	/*WapdmanClientComponentProperties::~WapdmanClientComponentProperties() 
	{
		LOG_INFO("WapdmanClientComponentProperties::Destructor");
		delete m_poWapdmanClientComponentProperties;
		m_poWapdmanClientComponentProperties = NULL;
	}*/
	
	WapdmanClientComponentProperties& WapdmanClientComponentProperties::rfGetClientComponentPropertiesInstance()
	{
		return *m_poWapdmanClientComponentProperties;
	}
	
	/*void WapdmanClientComponent::onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& sysChange)
	{
		(void)proxy;
		(void)sysChange;
		
	}
	void WapdmanClientComponent::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& sysChange)
	{
		(void)proxy;
		(void)sysChange;
		
	}*/
	
	/*void WapdmanClientComponentProperties::onGetResponse(const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::PropertiesProxy >& proxy, 
	const ::boost::shared_ptr< ::org::freedesktop::DBus::Properties::GetResponse >& response)
	{
		//(void)proxy;//solving lint
		if(response)
		{
			LOG_INFO("WapdmanClientComponentProperties::onGetResponse Received...... Success");
			uint32 _act=response->getAct();
		    //WapdmanServerComponent::rfGetServerInstance().vGlueonGetResponse(std::string(response->getValue()),_act);
		}
		else
		{
			LOG_INFO("response IS NULL");
		}
	}*/
	
	//void WapdmanClientComponentProperties::onPropertiesChangedSignal(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< PropertiesChangedSignal >& signal)
//	{
	//	   LOG_INFO ("WapdmanClientComponentProperties::onPropertiesChangedSignal() entered ");

  // typedef ::std::map< ::std::string, ::asf::dbus::DBusVariant >   ChangedProperties;
  // ChangedProperties changedProperties = signal->getChanged_properties();
   //Take below part later
   //::std::vector< ::std::string > invalidatedProperties = signal->getInvalidated_properties(); //TODO - when will this occur?

   //::std::vector< ::std::string > changedPropertyNames;
  // for (ChangedProperties::iterator it = changedProperties.begin(); it != changedProperties.end(); ++it)
  // {
    //  changedPropertyNames.push_back(it->first);
  // } // for (ChangedProperties::iterator it =...)

   //std::string objPath = proxy->getDBusObjectPath();  //TODO - use interface name or obj path?
   /*if (true == bIsAccessPoint(objPath))
   {*/
   //   AccessPointProperty apProperty;
      //vUpdateAccessPoint(objPath, apProperty, invalidatedProperties);
  //    vParseAccessPointInfo(proxy->getDBusBusName(), objPath,
    //        proxy->getBusType(), proxy->getInterfaceName(), changedProperties, apProperty);
     /*vUpdateAccessPoint(objPath, apProperty, changedPropertyNames);
   //}*/
  /* else if (true == bIsAssociatedStation(objPath))
   {
      AssociatedStationProperty asProperty;
      //vUpdateAssociatedStation(objPath, asProperty, invalidatedProperties);
      vParseAssociatedStationInfo(proxy->getDBusBusName(), objPath,
            proxy->getBusType(), proxy->getInterfaceName(), changedProperties, asProperty);
      vUpdateAssociatedStation(objPath, asProperty, changedPropertyNames);
   }*/
	//}
	
	
	
/*	void WapdmanClientComponentProperties::vParseAccessPointInfo(const ::std::string& busName,
      const ::std::string& objPath, const ::DBusBusType busType, const ::std::string& interfaceName,
      ::std::map< ::std::string, ::asf::dbus::DBusVariant >& data, AccessPointProperty& property)
{
   LOG_INFO ("WapdmanClientComponentProperties::vParseAccessPointInfo() entered ");

   //WapdmgrDbusParser parser;
   //parser.setTraces(true);

   ::std::vector<int> matchingInterfaces;
   matchingInterfaces.push_back((int)IF_ACCESS_POINT);

   ::std::vector< DbusVariantProperty > ifProperties;
   parser.parseProperties(ifProperties, matchingInterfaces, data,
         busType, busName, objPath, interfaceName);

   for(size_t i = 0; i < ifProperties.size(); ++i)
   {
      AccessPointPropertyName propertyName = static_cast<AccessPointPropertyName>(ifProperties[i].propEnum);
      switch(propertyName)
      {
         case AP_MAC_ADDRESS:
         {
            property.macAddress = ifProperties[i].propData.getString();
            break;
         }
         case AP_SSID:
         {
            property.SSID = ifProperties[i].propData.getString();
            break;
         }
         default:
         {
            break;
         }
      } 
   } 
} */

	
	
	/*void WapdmanClientComponentProperties::vGlueGetRequest(std::string interface_name,std::string property_name)
	{
		LOG_INFO("WapdmanClientComponentProperties::vGlueGetRequest");
		if(m_poPropertiesProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poPropertiesProxy->sendGetRequest(*this,interface_name,property_name);
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}*/

	void WapdmanClientComponentProperties::onPropertiesChangedSignal(const ::boost::shared_ptr< PropertiesProxy >& proxy, const ::boost::shared_ptr< PropertiesChangedSignal >& signal)
	{
		LOG_INFO ("WapdmanClientComponentProperties::onPropertiesChangedSignal() entered ");

   typedef ::std::map< ::std::string, ::asf::dbus::DBusVariant > ChangedProperties;
   asf::dbus::DBusVariant valVariant;
   
   ChangedProperties changedProperties = signal->getChanged_properties();
  
   for (ChangedProperties::iterator it = changedProperties.begin(); it != changedProperties.end(); ++it)
   {
      valVariant = it->second;
      DBusMessageIter* valIter = valVariant.getReadIterator();
	  if (!strcmp(it->first.c_str(), "SSID"))
      {
		  LOG_INFO("SSID Compare Entered");
         char *value = (char*)getDbusIterValue(valIter);
         //std::string SSID = value;
		 //LOG_INFO("SSID is %s",SSID.c_str());
      }
	}
	}
	
	void WapdmanClientComponentProperties::vGluegetSSIDRequest()
	{
		LOG_INFO("WapdmanClientComponentProperties::vGluegetSSIDRequest");
		if(m_poPropertiesProxy)
		{
			LOG_INFO("PROXY EXISTS");
			m_poPropertiesProxy->sendGetRequest(*this,"org.bosch.wapdman.Accesspoint","SSID");
		}
		else
		{
			LOG_INFO("Invalid Proxy");
		}
	}
	
	void* WapdmanClientComponent::getDbusIterValue(DBusMessageIter* iter)
{
   void* pVal = NULL;
   int type = dbus_message_iter_get_arg_type(iter);
   if (type == DBUS_TYPE_INVALID)
   {
      return NULL;
   }
   switch (type)
   {
      case DBUS_TYPE_STRING:
      case DBUS_TYPE_SIGNATURE:
      case DBUS_TYPE_OBJECT_PATH:
      {
         char* val;
         dbus_message_iter_get_basic(iter, &val);
         if (val)
         {
            char* cpVal = (char*)getMemAlloc(strlen(val) + 1);
            if (cpVal)
            {
               strcpy(cpVal, val);
               return cpVal;
            }
         }
         break;
      }
      case DBUS_TYPE_INT16:
      case DBUS_TYPE_UINT16:
      {
         dbus_uint16_t val;
         dbus_message_iter_get_basic(iter, &val);
         pVal = getMemAlloc(sizeof(val));
         if (pVal != NULL)
         {
            memcpy(pVal, &val, sizeof(val));
         }
         break;
      }
      case DBUS_TYPE_INT32:
      case DBUS_TYPE_UINT32:
      {
         dbus_uint32_t val;
         dbus_message_iter_get_basic(iter, &val);
         pVal = getMemAlloc(sizeof(val));
         if (pVal != NULL)
         {
            memcpy(pVal, &val, sizeof(val));
         }
         break;
      }
      case DBUS_TYPE_INT64:
      case DBUS_TYPE_UINT64:
      {
         dbus_uint64_t val;
         dbus_message_iter_get_basic(iter, &val);
         pVal = getMemAlloc(sizeof(val));
         if (pVal != NULL)
         {
            memcpy(pVal, &val, sizeof(val));
         }
         break;
      }
      case DBUS_TYPE_DOUBLE:
      {
         double val;
         dbus_message_iter_get_basic(iter, &val);
         pVal = getMemAlloc(sizeof(val));
         if (pVal != NULL)
         {
            memcpy(pVal, &val, sizeof(val));
         }
         break;
      }
      case DBUS_TYPE_BYTE:
      {
		  LOG_INFO("Kesavan DBUS_TYPE_BYTE");
         unsigned char val;
         dbus_message_iter_get_basic(iter, &val);
         int iVal = static_cast<int>(val);
         pVal = getMemAlloc(sizeof(int));
         if (pVal != NULL)
         {
            memcpy(pVal, &iVal, sizeof(val));
         }
         break;
      }

      case DBUS_TYPE_BOOLEAN:
      {
         dbus_bool_t val;
         dbus_message_iter_get_basic(iter, &val);
         pVal = getMemAlloc(sizeof(bool));
         if (pVal != NULL)
         {
            memcpy(pVal, &val, sizeof(bool));
         }
         return pVal;
         break;
      }
      case DBUS_TYPE_VARIANT:
      {
         DBusMessageIter subiter;
         dbus_message_iter_recurse(iter, &subiter);
         void* vpVal = getDbusIterValue(&subiter);
         return vpVal;
      }
      case DBUS_TYPE_DICT_ENTRY:
      {
         DBusMessageIter subiter;
         dbus_message_iter_recurse(iter, &subiter);
         getDbusIterValue(&subiter);
         dbus_message_iter_next(&subiter);
         void* vpVal = getDbusIterValue(&subiter);
         return vpVal;
      }
      case DBUS_TYPE_ARRAY:
      case DBUS_TYPE_STRUCT:
      {
		 LOG_INFO("Kesavan DBUS_TYPE_ARRAY");
         int current_type;
         DBusMessageIter subiter;
         dbus_message_iter_recurse(iter, &subiter);
         void* vpVal = NULL;
         while ((current_type = dbus_message_iter_get_arg_type(&subiter)) != DBUS_TYPE_INVALID)
         {
            vpVal = getDbusIterValue(&subiter);
            dbus_message_iter_next(&subiter);
            if (dbus_message_iter_get_arg_type(&subiter) != DBUS_TYPE_INVALID)
            {
             /*  ETG_TRACE_USR4(("WifiConnman_Technology::VALID_DBUS_TYPE"));*/
            }
         }
         return vpVal;
      }
      default:
      {
         return pVal;
      }
   }
   return pVal;
}

void* WapdmanClientComponent::getMemAlloc(size_t size)
{
   void* memPtr = malloc(size);
   if (NULL != memPtr)
   {
      memset(memPtr, 0, size);
   }
   return memPtr;
}
	
	
	
	void* WapdmanClientComponentProperties::getDbusIterValue(DBusMessageIter* iter)
{
   void* pVal = NULL;
   int type = dbus_message_iter_get_arg_type(iter);
   if (type == DBUS_TYPE_INVALID)
   {
      return NULL;
   }
   switch (type)
   {
      case DBUS_TYPE_STRING:
      case DBUS_TYPE_SIGNATURE:
      case DBUS_TYPE_OBJECT_PATH:
      {
         char* val;
         dbus_message_iter_get_basic(iter, &val);
         if (val)
         {
            char* cpVal = (char*)getMemAlloc(strlen(val) + 1);
            if (cpVal)
            {
               strcpy(cpVal, val);
               return cpVal;
            }
         }
         break;
      }
      case DBUS_TYPE_INT16:
      case DBUS_TYPE_UINT16:
      {
         dbus_uint16_t val;
         dbus_message_iter_get_basic(iter, &val);
         pVal = getMemAlloc(sizeof(val));
         if (pVal != NULL)
         {
            memcpy(pVal, &val, sizeof(val));
         }
         break;
      }
      case DBUS_TYPE_INT32:
      case DBUS_TYPE_UINT32:
      {
         dbus_uint32_t val;
         dbus_message_iter_get_basic(iter, &val);
         pVal = getMemAlloc(sizeof(val));
         if (pVal != NULL)
         {
            memcpy(pVal, &val, sizeof(val));
         }
         break;
      }
      case DBUS_TYPE_INT64:
      case DBUS_TYPE_UINT64:
      {
         dbus_uint64_t val;
         dbus_message_iter_get_basic(iter, &val);
         pVal = getMemAlloc(sizeof(val));
         if (pVal != NULL)
         {
            memcpy(pVal, &val, sizeof(val));
         }
         break;
      }
      case DBUS_TYPE_DOUBLE:
      {
         double val;
         dbus_message_iter_get_basic(iter, &val);
         pVal = getMemAlloc(sizeof(val));
         if (pVal != NULL)
         {
            memcpy(pVal, &val, sizeof(val));
         }
         break;
      }
      case DBUS_TYPE_BYTE:
      {
         unsigned char val;
         dbus_message_iter_get_basic(iter, &val);
         int iVal = static_cast<int>(val);
         pVal = getMemAlloc(sizeof(int));
         if (pVal != NULL)
         {
            memcpy(pVal, &iVal, sizeof(val));
         }
         break;
      }

      case DBUS_TYPE_BOOLEAN:
      {
         dbus_bool_t val;
         dbus_message_iter_get_basic(iter, &val);
         pVal = getMemAlloc(sizeof(bool));
         if (pVal != NULL)
         {
            memcpy(pVal, &val, sizeof(bool));
         }
         return pVal;
         break;
      }
      case DBUS_TYPE_VARIANT:
      {
         DBusMessageIter subiter;
         dbus_message_iter_recurse(iter, &subiter);
         void* vpVal = getDbusIterValue(&subiter);
         return vpVal;
      }
      case DBUS_TYPE_DICT_ENTRY:
      {
         DBusMessageIter subiter;
         dbus_message_iter_recurse(iter, &subiter);
         getDbusIterValue(&subiter);
         dbus_message_iter_next(&subiter);
         void* vpVal = getDbusIterValue(&subiter);
         return vpVal;
      }
      case DBUS_TYPE_ARRAY:
      case DBUS_TYPE_STRUCT:
      {
         int current_type;
         DBusMessageIter subiter;
         dbus_message_iter_recurse(iter, &subiter);
         void* vpVal = NULL;
         while ((current_type = dbus_message_iter_get_arg_type(&subiter)) != DBUS_TYPE_INVALID)
         {
            vpVal = getDbusIterValue(&subiter);
            dbus_message_iter_next(&subiter);
            if (dbus_message_iter_get_arg_type(&subiter) != DBUS_TYPE_INVALID)
            {
             /*  ETG_TRACE_USR4(("WifiConnman_Technology::VALID_DBUS_TYPE"));*/
            }
         }
         return vpVal;
      }
      default:
      {
         return pVal;
      }
   }
   return pVal;
}

void* WapdmanClientComponentProperties::getMemAlloc(size_t size)
{
   void* memPtr = malloc(size);
   if (NULL != memPtr)
   {
      memset(memPtr, 0, size);
   }
   return memPtr;
}

	
}}


