/**
 * @file servicereg.h
 * @author RBEI/ECO3-Usman Sheik
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup
 *
 * @brief
 *
 * @{
 */

#ifndef SERVICEREG_H
#define SERVICEREG_H

#include <linux/nl80211.h>

typedef
struct __service_reg_ops {
    const char *name;
    enum nl80211_iftype iftype;
    int (*register_service) (void *vendor_element,
                             void *userdata,
                             void *invocation);
    int (*unregister_service) (void *vendor_element,
                               void *userdata,
                               void *invocation);
} serviceregops;

int servicereg_init ();
int servicereg_deinit ();
int vendor_service_driver_register (serviceregops *ops);
int vendor_service_driver_unregister (serviceregops *ops);

int register_vendor_service (const enum nl80211_iftype iftype,
                             const char *owner,
                             void *vendor_elements,
                             void *userdata,
                             void *invocation);

int unregister_vendor_service (const enum nl80211_iftype iftype,
                               const char *owner,
                               void *vendor_elements,
                               void *userdata,
                               void *invocation);

#endif //SERVICEREG_H

/** @} */
